/* 
 * Created on 2-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: EditTemplateDialog.java,v $
 * @version $Revision: 1.26 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2007/01/18 18:19:13 $ (UTC date of last check in)
 */

package com.gui;

import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.Mount;
import com.model.Settings;
import com.model.Template;
import com.util.FileUtils;
import com.util.ListUtils;
import swing2swt.layout.BorderLayout;


public class EditTemplateDialog extends Dialog {

	private Text keyboard_layout;
	private Button timed;
	private Button autofire;
	private Button swap34;
	private Button glide;
  private Text glideport;
  private Text vsyncrate;
  private Combo vsyncmode;
  private Combo videoram;
  private Combo svgachipset;
  private Text overscan;
  private Combo mt32rate;
  private Combo pixelshader;
  private TabItem infoTabItem;
  private Text title;
  private Button reloadSettingsButton;
  private Combo dbversion;
  private Button waitonerror;
  private Button exit;
  private Combo priority_inactive;
  private Combo priority_active;
  private Text captures;
  private Text language;
  private Combo windowresolution;
  private Combo fullresolution;
  private Combo frameskip;
  private Combo output;
  private Button fullscreen;
  private Button fulldouble;
  private Combo scaler;
  private Button aspect;
  private Combo machine;
  private Combo cycles_down;
  private Combo cycles_up;
  private Combo cycles;
  private Combo core;
  private Button timesynched;
  private Button xms;
  private Button ems;
  private Combo umb;
  private Combo memsize;
  private Button nosound;
  private Button mixer;
  private Button pcspeaker;
  private Button disney;
  private Button gus;
  private Combo tandy;
  private Combo tandyrate;
  private Text midi_config;
  private Combo device;
  private Combo mpu401;
  private Text ultradir;
  private Combo gusrate;
  private Combo irq2;
  private Combo dma2;
  private Combo dma1;
  private Combo irq1;
  private Combo gusbase;
  private Combo pcrate;
  private Combo hdma;
  private Combo dma;
  private Combo irq;
  private Combo sbbase;
  private Combo oplrate;
  private Combo oplmode;
  private Combo sbtype;
  private Combo prebuffer;
  private Combo blocksize;
  private Combo rate;
  private Button usescancodes;
  private Button autolock;
  private Text serial4;
  private Text serial3;
  private Text serial2;
  private Text serial1;
  private Combo joysticktype;
  private Text mapperfile;
  private Combo sensitivity;
  private Button ipx;
  private List mountingpoints;
  private Button booterButton;
  private Button dosButton;
  
  protected Shell shell;
  private java.util.List<DosboxVersion> dbversionsList;
  private Database db;
  private Configuration templateConf;
  private Settings settings;
  protected Object result;
  
  /**
   * Create the dialog
   * @param parent
   */
  public EditTemplateDialog(Shell parent) {
    super(parent, SWT.NONE);
  }
  
  public void setTemplate(Template template) {
    this.result = template;
  }

  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
  	settings = Settings.getInstance();
  	db = Database.getInstance();
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    try {
			dbversionsList = db.readDosboxVersionsList();
		} catch (SQLException e) {
			GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
		}
    
    shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
    shell.setLayout(new BorderLayout(0, 0));
    shell.setSize(610, 475);
    
    if (result != null) {
      // meaning we are essentially editing an existing template
      shell.setText("Edit Template " + ((Template)result).getTitle() + " (" + ((Template)result).getId() + ")");
    } else {
      shell.setText("Add Template");
    }

    final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

    infoTabItem = new TabItem(tabFolder, SWT.NONE);
    infoTabItem.setText("Info");

    final Composite composite = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 2;
    composite.setLayout(gridLayout);
    infoTabItem.setControl(composite);

    final Label titleLabel = new Label(composite, SWT.NONE);
    titleLabel.setText("Title");

    title = new Text(composite, SWT.BORDER);
    title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    
    final TabItem generalTabItem = new TabItem(tabFolder, SWT.NONE);
    generalTabItem.setText("General");

    final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout_1 = new GridLayout();
    gridLayout_1.numColumns = 3;
    composite_1.setLayout(gridLayout_1);
    generalTabItem.setControl(composite_1);

    final Label dosboxVersionLabel = new Label(composite_1, SWT.NONE);
    dosboxVersionLabel.setText("Dosbox version");

    dbversion = new Combo(composite_1, SWT.READ_ONLY);
    dbversion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    dbversion.setVisibleItemCount(10);
    
    reloadSettingsButton = new Button(composite_1, SWT.NONE);
    reloadSettingsButton.setText("Reload Settings");
    reloadSettingsButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        templateConf = EditProfileDialog.loadDBVersionConfig(dbversionsList.get(dbversion.getSelectionIndex()), shell);
        selectSettingsByConfiguration(templateConf);
        // enable 'exit afterwards' hardcoded, by default
        exit.setSelection(true);
      }
    });
    
    final Label label = new Label(composite_1, SWT.SEPARATOR | SWT.HORIZONTAL);
    label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 3, 1));
    new Label(composite_1, SWT.NONE);

    final Label activeLabel = new Label(composite_1, SWT.NONE);
    activeLabel.setText("Active");

    final Label inactiveLabel = new Label(composite_1, SWT.NONE);
    inactiveLabel.setText("Inactive");

    final Label priorityLabel = new Label(composite_1, SWT.NONE);
    priorityLabel.setText("Priority");

    priority_active = new Combo(composite_1, SWT.READ_ONLY);
    priority_active.setItems(settings.getValues("profile", "priority_active"));
    final GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, true, false);
    gridData.minimumWidth = 150;
    priority_active.setLayoutData(gridData);

    priority_inactive = new Combo(composite_1, SWT.READ_ONLY);
    priority_inactive.setItems(settings.getValues("profile", "priority_inactive"));
    priority_inactive.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));

    final Label waitOnErrorLabel = new Label(composite_1, SWT.NONE);
    waitOnErrorLabel.setText("Wait On Error");

    waitonerror = new Button(composite_1, SWT.CHECK);
    new Label(composite_1, SWT.NONE);

    final Label exitAfterwardsLabel = new Label(composite_1, SWT.NONE);
    exitAfterwardsLabel.setText("Exit afterwards");

    exit = new Button(composite_1, SWT.CHECK);
    new Label(composite_1, SWT.NONE);

    final Label languageFileLabel = new Label(composite_1, SWT.NONE);
    languageFileLabel.setLayoutData(new GridData());
    languageFileLabel.setText("Language File");

    language = new Text(composite_1, SWT.BORDER);
    language.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    
    final TabItem displayTabItem = new TabItem(tabFolder, SWT.NONE);
    displayTabItem.setText("Display");

    final Composite composite_2 = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout_5 = new GridLayout();
    gridLayout_5.numColumns = 4;
    composite_2.setLayout(gridLayout_5);
    displayTabItem.setControl(composite_2);

    final Label outputLabel = new Label(composite_2, SWT.NONE);
    outputLabel.setText("Output");

    output = new Combo(composite_2, SWT.READ_ONLY);
    output.setItems(settings.getValues("profile", "output"));
    output.setVisibleItemCount(10);
    output.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label frameskipLabel = new Label(composite_2, SWT.NONE);
    frameskipLabel.setText("Frameskip");

    frameskip = new Combo(composite_2, SWT.READ_ONLY);
    frameskip.setItems(settings.getValues("profile", "frameskip"));
    frameskip.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label scalerLabel = new Label(composite_2, SWT.NONE);
    scalerLabel.setText("Scaler");

    scaler = new Combo(composite_2, SWT.READ_ONLY);
    scaler.setItems(settings.getValues("profile", "scaler"));
    scaler.setVisibleItemCount(15);
    scaler.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label pixelshaderLabel = new Label(composite_2, SWT.NONE);
    pixelshaderLabel.setLayoutData(new GridData());
    pixelshaderLabel.setText("Pixelshader");

    pixelshader = new Combo(composite_2, SWT.READ_ONLY);
    pixelshader.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    pixelshader.setVisibleItemCount(15);
    pixelshader.setItems(settings.getValues("profile", "pixelshader"));

    final Label fullscreenLabel = new Label(composite_2, SWT.NONE);
    fullscreenLabel.setText("Fullscreen");

    fullscreen = new Button(composite_2, SWT.CHECK);
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label doubleBufferingLabel = new Label(composite_2, SWT.NONE);
    doubleBufferingLabel.setText("Double Buffering");

    fulldouble = new Button(composite_2, SWT.CHECK);
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label resolutionLabel = new Label(composite_2, SWT.NONE);
    resolutionLabel.setText("Fullscreen Resolution");

    fullresolution = new Combo(composite_2, SWT.READ_ONLY);
    fullresolution.setItems(settings.getValues("profile", "fullresolution"));
    fullresolution.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    fullresolution.setVisibleItemCount(10);

    final Label windowResolutionLabel = new Label(composite_2, SWT.NONE);
    windowResolutionLabel.setText("Window Resolution");

    windowresolution = new Combo(composite_2, SWT.READ_ONLY);
    windowresolution.setItems(settings.getValues("profile", "windowresolution"));
    windowresolution.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    windowresolution.setVisibleItemCount(10);

    final Label aspectCorrectionLabel = new Label(composite_2, SWT.NONE);
    aspectCorrectionLabel.setText("Aspect Correction");

    aspect = new Button(composite_2, SWT.CHECK);
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final TabItem machineTabItem = new TabItem(tabFolder, SWT.NONE);
    machineTabItem.setText("Machine");

    final Composite composite_3 = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout_2 = new GridLayout();
    composite_3.setLayout(gridLayout_2);
    machineTabItem.setControl(composite_3);

    final Group cpuGroup = new Group(composite_3, SWT.NONE);
    cpuGroup.setText("CPU");
    final GridLayout gridLayout_3 = new GridLayout();
    gridLayout_3.numColumns = 6;
    cpuGroup.setLayout(gridLayout_3);

    final Label overscanLabel = new Label(composite_2, SWT.NONE);
    overscanLabel.setText("Overscan");

    overscan = new Text(composite_2, SWT.BORDER);
    overscan.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label svgaChipsetLabel = new Label(composite_2, SWT.NONE);
    svgaChipsetLabel.setText("SVGA Chipset");

    svgachipset = new Combo(composite_2, SWT.READ_ONLY);
    svgachipset.setItems(settings.getValues("profile", "svgachipset"));
    svgachipset.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label videoRamLabel = new Label(composite_2, SWT.NONE);
    videoRamLabel.setText("Video RAM in KB");

    videoram = new Combo(composite_2, SWT.READ_ONLY);
    videoram.setItems(settings.getValues("profile", "videoram"));
    videoram.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite_2, SWT.NONE);
    new Label(composite_2, SWT.NONE);

    final Label vsyncModeLabel = new Label(composite_2, SWT.NONE);
    vsyncModeLabel.setText("Vsync Mode");

    vsyncmode = new Combo(composite_2, SWT.READ_ONLY);
    vsyncmode.setItems(settings.getValues("profile", "vsyncmode"));
    vsyncmode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label vsyncRateLabel = new Label(composite_2, SWT.NONE);
    vsyncRateLabel.setLayoutData(new GridData());
    vsyncRateLabel.setText("Vsync Rate");

    vsyncrate = new Text(composite_2, SWT.BORDER);
    vsyncrate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label glideLabel = new Label(composite_2, SWT.NONE);
    glideLabel.setText("Glide");

    glide = new Button(composite_2, SWT.CHECK);
    glide.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		glideport.setEnabled(glide.getSelection());
    	}
    });

    final Label glidePortLabel = new Label(composite_2, SWT.NONE);
    glidePortLabel.setText("Glide port");

    glideport = new Text(composite_2, SWT.BORDER);
    glideport.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label machineLabel = new Label(cpuGroup, SWT.NONE);
    machineLabel.setText("Machine");

    machine = new Combo(cpuGroup, SWT.READ_ONLY);
    machine.setItems(settings.getValues("profile", "machine"));
    machine.setLayoutData(new GridData());
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);

    final Label coreLabel = new Label(cpuGroup, SWT.NONE);
    coreLabel.setText("Core");

    core = new Combo(cpuGroup, SWT.READ_ONLY);
    core.setItems(settings.getValues("profile", "core"));
    core.setLayoutData(new GridData());
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);

    final Label cyclesLabel = new Label(cpuGroup, SWT.NONE);
    cyclesLabel.setText("Cycles");

    cycles = new Combo(cpuGroup, SWT.NONE);
    cycles.setItems(settings.getValues("profile", "cycles"));
    cycles.setLayoutData(new GridData());
    cycles.setVisibleItemCount(15);

    final Label upLabel = new Label(cpuGroup, SWT.NONE);
    upLabel.setLayoutData(new GridData());
    upLabel.setText("Up");

    cycles_up = new Combo(cpuGroup, SWT.NONE);
    cycles_up.setItems(settings.getValues("profile", "cycles_up"));
    cycles_up.setLayoutData(new GridData());

    final Label downLabel = new Label(cpuGroup, SWT.NONE);
    downLabel.setLayoutData(new GridData());
    downLabel.setText("Down");

    cycles_down = new Combo(cpuGroup, SWT.NONE);
    cycles_down.setItems(settings.getValues("profile", "cycles_down"));
    cycles_down.setLayoutData(new GridData());

    final Label timesynchedLabel = new Label(cpuGroup, SWT.NONE);
    timesynchedLabel.setText("Timesynched");

    timesynched = new Button(cpuGroup, SWT.CHECK);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);
    new Label(cpuGroup, SWT.NONE);

    final Group memoryGroup = new Group(composite_3, SWT.NONE);
    memoryGroup.setText("Memory");
    memoryGroup.setLayoutData(new GridData());
    final GridLayout gridLayout_4 = new GridLayout();
    gridLayout_4.numColumns = 2;
    memoryGroup.setLayout(gridLayout_4);

    final Label sizeLabel = new Label(memoryGroup, SWT.NONE);
    sizeLabel.setText("Size");

    memsize = new Combo(memoryGroup, SWT.READ_ONLY);
    memsize.setItems(settings.getValues("profile", "memsize"));
    memsize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label xmsLabel = new Label(memoryGroup, SWT.NONE);
    xmsLabel.setText("XMS");

    xms = new Button(memoryGroup, SWT.CHECK);

    final Label emsLabel = new Label(memoryGroup, SWT.NONE);
    emsLabel.setText("EMS");

    ems = new Button(memoryGroup, SWT.CHECK);

    final Label umbLabel = new Label(memoryGroup, SWT.NONE);
    umbLabel.setText("UMB");

    umb = new Combo(memoryGroup, SWT.READ_ONLY);
    umb.setItems(settings.getValues("profile", "umb"));
    umb.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final TabItem audioTabItem = new TabItem(tabFolder, SWT.NONE);
    audioTabItem.setText("Audio");

    final Composite composite_4 = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout_9 = new GridLayout();
    gridLayout_9.numColumns = 3;
    composite_4.setLayout(gridLayout_9);
    audioTabItem.setControl(composite_4);

    final Group generalGroup = new Group(composite_4, SWT.NONE);
    generalGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
    final GridLayout gridLayout_6 = new GridLayout();
    gridLayout_6.numColumns = 2;
    generalGroup.setLayout(gridLayout_6);
    generalGroup.setText("General");

    final Label silentModeLabel = new Label(generalGroup, SWT.NONE);
    silentModeLabel.setText("Silent Mode");

    nosound = new Button(generalGroup, SWT.CHECK);

    final Label sampleRateLabel = new Label(generalGroup, SWT.NONE);
    sampleRateLabel.setText("Sample Rate");

    rate = new Combo(generalGroup, SWT.READ_ONLY);
    rate.setItems(settings.getValues("profile", "rate"));
    rate.setLayoutData(new GridData());

    final Label blockSizeLabel = new Label(generalGroup, SWT.NONE);
    blockSizeLabel.setText("Block Size");

    blocksize = new Combo(generalGroup, SWT.READ_ONLY);
    blocksize.setItems(settings.getValues("profile", "blocksize"));
    blocksize.setLayoutData(new GridData());

    final Label prebufferLabel = new Label(generalGroup, SWT.NONE);
    prebufferLabel.setText("Prebuffer");

    prebuffer = new Combo(generalGroup, SWT.NONE);
    prebuffer.setItems(settings.getValues("profile", "prebuffer"));
    prebuffer.setLayoutData(new GridData());

    final Label mpu401Label = new Label(generalGroup, SWT.NONE);
    mpu401Label.setText("MPU-401");

    mpu401 = new Combo(generalGroup, SWT.READ_ONLY);
    mpu401.setItems(settings.getValues("profile", "mpu401"));
    mpu401.setLayoutData(new GridData());

    final Label midiDeviceLabel = new Label(generalGroup, SWT.NONE);
    midiDeviceLabel.setText("Midi Device");

    device = new Combo(generalGroup, SWT.READ_ONLY);
    device.setItems(settings.getValues("profile", "device"));
    device.setLayoutData(new GridData());

    final Label configLabel = new Label(generalGroup, SWT.NONE);
    configLabel.setText("Config");

    midi_config = new Text(generalGroup, SWT.BORDER);
    midi_config.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label mt32RateLabel = new Label(generalGroup, SWT.NONE);
    mt32RateLabel.setText("MT-32 Rate");

    mt32rate = new Combo(generalGroup, SWT.READ_ONLY);
    mt32rate.setItems(settings.getValues("profile", "mt32rate"));
    mt32rate.setLayoutData(new GridData());

    final Group soundblasterGroup = new Group(composite_4, SWT.NONE);
    soundblasterGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
    soundblasterGroup.setText("Soundblaster");
    final GridLayout gridLayout_7 = new GridLayout();
    gridLayout_7.numColumns = 2;
    soundblasterGroup.setLayout(gridLayout_7);

    final Label typeLabel = new Label(soundblasterGroup, SWT.NONE);
    typeLabel.setText("Type");

    sbtype = new Combo(soundblasterGroup, SWT.READ_ONLY);
    sbtype.setItems(settings.getValues("profile", "sbtype"));
    sbtype.setLayoutData(new GridData());

    final Label oplRateLabel = new Label(soundblasterGroup, SWT.NONE);
    oplRateLabel.setText("OPL Rate");

    oplrate = new Combo(soundblasterGroup, SWT.READ_ONLY);
    oplrate.setItems(settings.getValues("profile", "oplrate"));
    oplrate.setLayoutData(new GridData());

    final Label oplModeLabel = new Label(soundblasterGroup, SWT.NONE);
    oplModeLabel.setLayoutData(new GridData());
    oplModeLabel.setText("OPL Mode");

    oplmode = new Combo(soundblasterGroup, SWT.READ_ONLY);
    oplmode.setItems(settings.getValues("profile", "oplmode"));
    oplmode.setLayoutData(new GridData());

    final Label addressLabel = new Label(soundblasterGroup, SWT.NONE);
    addressLabel.setText("Address");

    sbbase = new Combo(soundblasterGroup, SWT.READ_ONLY);
    sbbase.setItems(settings.getValues("profile", "sbbase"));
    sbbase.setLayoutData(new GridData());

    final Label irqLabel = new Label(soundblasterGroup, SWT.NONE);
    irqLabel.setText("IRQ");

    irq = new Combo(soundblasterGroup, SWT.READ_ONLY);
    irq.setItems(settings.getValues("profile", "irq"));
    irq.setLayoutData(new GridData());

    final Label dmaLabel = new Label(soundblasterGroup, SWT.NONE);
    dmaLabel.setText("DMA");

    dma = new Combo(soundblasterGroup, SWT.READ_ONLY);
    dma.setItems(settings.getValues("profile", "dma"));
    dma.setLayoutData(new GridData());

    final Label hdmaLabel = new Label(soundblasterGroup, SWT.NONE);
    hdmaLabel.setLayoutData(new GridData());
    hdmaLabel.setText("HDMA");

    hdma = new Combo(soundblasterGroup, SWT.READ_ONLY);
    hdma.setItems(settings.getValues("profile", "hdma"));
    hdma.setLayoutData(new GridData());

    final Label mixerLabel = new Label(soundblasterGroup, SWT.NONE);
    mixerLabel.setText("Mixer");

    mixer = new Button(soundblasterGroup, SWT.CHECK);

    final Group gusGroup = new Group(composite_4, SWT.NONE);
    gusGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
    gusGroup.setText("Gravis Ultrasound");
    final GridLayout gridLayout_8 = new GridLayout();
    gridLayout_8.numColumns = 2;
    gusGroup.setLayout(gridLayout_8);

    final Label enableLabel_1 = new Label(gusGroup, SWT.NONE);
    enableLabel_1.setLayoutData(new GridData());
    enableLabel_1.setText("Enable");

    gus = new Button(gusGroup, SWT.CHECK);
    gus.setLayoutData(new GridData());

    final Label sampleRateLabel_2 = new Label(gusGroup, SWT.NONE);
    sampleRateLabel_2.setText("Sample Rate");

    gusrate = new Combo(gusGroup, SWT.READ_ONLY);
    gusrate.setItems(settings.getValues("profile", "gusrate"));
    gusrate.setLayoutData(new GridData());

    final Label addressLabel_1 = new Label(gusGroup, SWT.NONE);
    addressLabel_1.setText("Address");

    gusbase = new Combo(gusGroup, SWT.READ_ONLY);
    gusbase.setItems(settings.getValues("profile", "gusbase"));
    gusbase.setLayoutData(new GridData());

    final Label irqLabel_1 = new Label(gusGroup, SWT.NONE);
    irqLabel_1.setText("IRQ1");

    irq1 = new Combo(gusGroup, SWT.READ_ONLY);
    irq1.setItems(settings.getValues("profile", "irq1"));
    irq1.setLayoutData(new GridData());

    final Label irq2Label = new Label(gusGroup, SWT.NONE);
    irq2Label.setText("IRQ2");

    irq2 = new Combo(gusGroup, SWT.READ_ONLY);
    irq2.setItems(settings.getValues("profile", "irq2"));
    irq2.setLayoutData(new GridData());

    final Label dmaLabel_1 = new Label(gusGroup, SWT.NONE);
    dmaLabel_1.setText("DMA1");

    dma1 = new Combo(gusGroup, SWT.READ_ONLY);
    dma1.setItems(settings.getValues("profile", "dma1"));
    dma1.setLayoutData(new GridData());

    final Label hdmaLabel_1 = new Label(gusGroup, SWT.NONE);
    hdmaLabel_1.setLayoutData(new GridData());
    hdmaLabel_1.setText("DMA2");

    dma2 = new Combo(gusGroup, SWT.READ_ONLY);
    dma2.setItems(settings.getValues("profile", "dma2"));
    dma2.setLayoutData(new GridData());

    final Label ultradirLabel = new Label(gusGroup, SWT.NONE);
    ultradirLabel.setText("Ultradir");

    ultradir = new Text(gusGroup, SWT.BORDER);
    ultradir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Group speakerGroup = new Group(composite_4, SWT.NONE);
    speakerGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
    speakerGroup.setText("PC Speaker");
    final GridLayout gridLayout_10 = new GridLayout();
    gridLayout_10.numColumns = 2;
    speakerGroup.setLayout(gridLayout_10);

    final Label enableLabel = new Label(speakerGroup, SWT.NONE);
    enableLabel.setText("Enable");

    pcspeaker = new Button(speakerGroup, SWT.CHECK);

    final Label sampleRateLabel_1 = new Label(speakerGroup, SWT.NONE);
    sampleRateLabel_1.setText("Sample Rate");

    pcrate = new Combo(speakerGroup, SWT.READ_ONLY);
    pcrate.setItems(settings.getValues("profile", "pcrate"));
    pcrate.setLayoutData(new GridData());

    final Group tandyGroup = new Group(composite_4, SWT.NONE);
    tandyGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
    tandyGroup.setText("Tandy");
    final GridLayout gridLayout_11 = new GridLayout();
    gridLayout_11.numColumns = 2;
    tandyGroup.setLayout(gridLayout_11);

    final Label enableLabel_2 = new Label(tandyGroup, SWT.NONE);
    enableLabel_2.setText("Enable");

    tandy = new Combo(tandyGroup, SWT.READ_ONLY);
    tandy.setItems(settings.getValues("profile", "tandy"));
    tandy.setLayoutData(new GridData());

    final Label sampleRateLabel_1_1 = new Label(tandyGroup, SWT.NONE);
    sampleRateLabel_1_1.setText("Sample Rate");

    tandyrate = new Combo(tandyGroup, SWT.READ_ONLY);
    tandyrate.setItems(settings.getValues("profile", "tandyrate"));
    tandyrate.setLayoutData(new GridData());

    final Group disneyGroup = new Group(composite_4, SWT.NONE);
    disneyGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
    disneyGroup.setText("Disney Sound Source");
    final GridLayout gridLayout_12 = new GridLayout();
    gridLayout_12.numColumns = 2;
    disneyGroup.setLayout(gridLayout_12);

    final Label enableLabel_3 = new Label(disneyGroup, SWT.NONE);
    enableLabel_3.setText("Enable");

    disney = new Button(disneyGroup, SWT.CHECK);

    final TabItem inputTabItem = new TabItem(tabFolder, SWT.NONE);
    inputTabItem.setText("I/O");

    final Composite composite_5 = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout_17 = new GridLayout();
    gridLayout_17.numColumns = 3;
    composite_5.setLayout(gridLayout_17);
    inputTabItem.setControl(composite_5);

    final Group mouseGroup = new Group(composite_5, SWT.NONE);
    mouseGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
    mouseGroup.setText("Mouse");
    final GridLayout gridLayout_13 = new GridLayout();
    gridLayout_13.numColumns = 2;
    mouseGroup.setLayout(gridLayout_13);

    final Label autolockLabel = new Label(mouseGroup, SWT.NONE);
    autolockLabel.setText("Autolock");

    autolock = new Button(mouseGroup, SWT.CHECK);

    final Label sensitivityLabel = new Label(mouseGroup, SWT.NONE);
    sensitivityLabel.setText("Sensitivity");

    sensitivity = new Combo(mouseGroup, SWT.READ_ONLY);
    sensitivity.setItems(settings.getValues("profile", "sensitivity"));
    sensitivity.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
    sensitivity.setVisibleItemCount(20);

    final Group keyboardGroup = new Group(composite_5, SWT.NONE);
    keyboardGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
    keyboardGroup.setText("Keyboard");
    final GridLayout gridLayout_14 = new GridLayout();
    gridLayout_14.numColumns = 2;
    keyboardGroup.setLayout(gridLayout_14);

    final Label useScancodesLabel = new Label(keyboardGroup, SWT.NONE);
    useScancodesLabel.setText("Use Scancodes");

    usescancodes = new Button(keyboardGroup, SWT.CHECK);

    final Label mapperFileLabel = new Label(keyboardGroup, SWT.NONE);
    mapperFileLabel.setText("Mapper File");

    mapperfile = new Text(keyboardGroup, SWT.BORDER);
    mapperfile.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label layoutLabel = new Label(keyboardGroup, SWT.NONE);
    layoutLabel.setText("Layout");

    keyboard_layout = new Text(keyboardGroup, SWT.BORDER);
    keyboard_layout.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Group joystickGroup = new Group(composite_5, SWT.NONE);
    joystickGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
    joystickGroup.setText("Joystick");
    final GridLayout gridLayout_15 = new GridLayout();
    gridLayout_15.numColumns = 2;
    joystickGroup.setLayout(gridLayout_15);

    final Label typeLabel_1 = new Label(joystickGroup, SWT.NONE);
    typeLabel_1.setText("Type");

    joysticktype = new Combo(joystickGroup, SWT.READ_ONLY);
    joysticktype.setItems(settings.getValues("profile", "joysticktype"));
    joysticktype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label timedEmulationLabel = new Label(joystickGroup, SWT.NONE);
    timedEmulationLabel.setText("Timed emulation");

    timed = new Button(joystickGroup, SWT.CHECK);

    final Label autofireLabel = new Label(joystickGroup, SWT.NONE);
    autofireLabel.setText("Autofire");

    autofire = new Button(joystickGroup, SWT.CHECK);

    final Label swapAxes3Label = new Label(joystickGroup, SWT.NONE);
    swapAxes3Label.setText("Swap axes 3&&4");

    swap34 = new Button(joystickGroup, SWT.CHECK);

    final Group modemGroup = new Group(composite_5, SWT.NONE);
    modemGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    modemGroup.setText("Modem");
    final GridLayout gridLayout_16 = new GridLayout();
    gridLayout_16.numColumns = 2;
    modemGroup.setLayout(gridLayout_16);

    final Label serial1Label = new Label(modemGroup, SWT.NONE);
    serial1Label.setText("Serial 1");

    serial1 = new Text(modemGroup, SWT.BORDER);
    serial1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label serial2Label = new Label(modemGroup, SWT.NONE);
    serial2Label.setText("Serial 2");

    serial2 = new Text(modemGroup, SWT.BORDER);
    serial2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label serial3Label = new Label(modemGroup, SWT.NONE);
    serial3Label.setText("Serial 3");

    serial3 = new Text(modemGroup, SWT.BORDER);
    serial3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Label serial4Label = new Label(modemGroup, SWT.NONE);
    serial4Label.setText("Serial 4");

    serial4 = new Text(modemGroup, SWT.BORDER);
    serial4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Group networkGroup = new Group(composite_5, SWT.NONE);
    networkGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
    networkGroup.setText("Network");
    final GridLayout gridLayout_20 = new GridLayout();
    gridLayout_20.numColumns = 2;
    networkGroup.setLayout(gridLayout_20);

    final Label ipxLabel = new Label(networkGroup, SWT.NONE);
    ipxLabel.setText("Enable IPX");

    ipx = new Button(networkGroup, SWT.CHECK);
    new Label(composite_5, SWT.NONE);

    final TabItem mountingTabItem = new TabItem(tabFolder, SWT.NONE);
    mountingTabItem.setText("Mounting");

    final Composite composite_6 = new Composite(tabFolder, SWT.NONE);
    composite_6.setLayout(new GridLayout());
    mountingTabItem.setControl(composite_6);

    final Group mountGroup = new Group(composite_6, SWT.NONE);
    mountGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    mountGroup.setText("Mounting Overview");
    final GridLayout gridLayout_19 = new GridLayout();
    gridLayout_19.numColumns = 2;
    mountGroup.setLayout(gridLayout_19);

    mountingpoints = new List(mountGroup, SWT.V_SCROLL | SWT.BORDER);
    final GridData gridData_2 = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 3);
    mountingpoints.setLayoutData(gridData_2);

    final Button addButton = new Button(mountGroup, SWT.NONE);
    addButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
    addButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        final EditMountDialog addMountDialog = new EditMountDialog(shell);
        java.util.List<Character> freeDriveletters =
        	Mount.getFreeDriveletters(booterButton.getSelection(), mountingpoints.getItems());
        if (freeDriveletters.size() > 0)
        	addMountDialog.setDefaultDriveletter(freeDriveletters.get(0));
        String mount = (String)addMountDialog.open();
        if (mount != null) {
          mountingpoints.add(mount);
          mountingpoints.select(mountingpoints.getItemCount() - 1);
        }
      }
    });
    addButton.setText("Add");

    final Button editButton = new Button(mountGroup, SWT.NONE);
    editButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
    editButton.setText("Edit");
    editButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (mountingpoints.getSelectionIndex() != -1) {
          final EditMountDialog editMountDialog = new EditMountDialog(shell);
          editMountDialog.setMount(mountingpoints.getItem(mountingpoints.getSelectionIndex()));
          String mount = (String)editMountDialog.open();
          if (mount != null) {
            mountingpoints.setItem(mountingpoints.getSelectionIndex(), mount);
          }
        }
      }
    });

    final Button removeButton = new Button(mountGroup, SWT.NONE);
    removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
    removeButton.setText("Remove");
    removeButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (mountingpoints.getSelectionIndex() != -1) {
          mountingpoints.remove(mountingpoints.getSelectionIndex());
        } else if (mountingpoints.getItemCount() == 1) {
        	mountingpoints.removeAll();
        }
      }
    });

    final Group executeGroup = new Group(composite_6, SWT.NONE);
    executeGroup.setLayoutData(new GridData());
    executeGroup.setText("Execute");
    final GridLayout gridLayout_18 = new GridLayout();
    executeGroup.setLayout(gridLayout_18);

    dosButton = new Button(executeGroup, SWT.RADIO);
    dosButton.setText("Dos");

    final Label label_1 = new Label(executeGroup, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));

    booterButton = new Button(executeGroup, SWT.RADIO);
    booterButton.setText("Booter");

    final Composite composite_7 = new Composite(shell, SWT.NONE);
    composite_7.setLayout(new RowLayout());
    composite_7.setLayoutData(BorderLayout.SOUTH);

    final Label capturesLabel = new Label(composite_1, SWT.NONE);
    capturesLabel.setLayoutData(new GridData());
    capturesLabel.setText("Captures");

    captures = new Text(composite_1, SWT.BORDER);
    captures.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    captures.setEditable(false);

    final Label defaultLabel = new Label(composite, SWT.NONE);
    defaultLabel.setText("Default");

    final Button defaultButton = new Button(composite, SWT.CHECK);

    final Button okButton = new Button(composite_7, SWT.NONE);
    shell.setDefaultButton(okButton);
    final RowData rowData = new RowData();
    rowData.width = 80;
    okButton.setLayoutData(rowData);
    okButton.setText("OK");
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
        int dbversionId = dbversionsList.get(dbversion.getSelectionIndex()).getId();
				try {
					int templateId = db.addOrEditTemplate(title.getText(), dbversionId,
					        defaultButton.getSelection(), result != null ? ((Template)result).getId(): -1);
					result = new Template(templateId, title.getText(), dbversionId, defaultButton.getSelection());
	        Configuration dosboxConf = EditProfileDialog.loadDBVersionConfig(
	        		dbversionsList.get(dbversion.getSelectionIndex()), shell);
	        getConfigurationBySettings(dosboxConf, templateConf);
	        templateConf.substract(dosboxConf);
	        EditProfileDialog.saveConfig(templateConf,
	        		FileUtils.constructTemplateFileLocation(templateId), shell);
				} catch (SQLException e1) {
					GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
				}
        shell.close();
      }
    });

    final Button cancelButton = new Button(composite_7, SWT.NONE);
    final RowData rowData_1 = new RowData();
    rowData_1.width = 80;
    cancelButton.setLayoutData(rowData_1);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    // init values
    for (DosboxVersion dbv: dbversionsList) dbversion.add(dbv.getTitle());
    
    if (result != null) {
      // meaning we are essentially editing an existing template
      // so we need to set previous values
      title.setText(((Template)result).getTitle());
      defaultButton.setSelection(((Template)result).isDefault());
      int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, ((Template)result).getdbversionId()); 
      dbversion.select(dbversionIndex);
      templateConf = EditProfileDialog.loadTemplateConfig(dbversionsList.get(dbversionIndex), (Template)result, shell);
      selectSettingsByConfiguration(templateConf);
    } else {
      // set default values for new template
      int dbversionIndex = ListUtils.findTIDefaultDosboxVersion(dbversionsList);
      dbversion.select(dbversionIndex);
      templateConf = EditProfileDialog.loadDBVersionConfig(dbversionsList.get(dbversionIndex), shell);
      selectSettingsByConfiguration(templateConf);
      // enabled 'exit afterwards' hardcoded, by default
      exit.setSelection(true);
      title.setFocus();
    }
  }
  
  private String getAutoexecSectionBySettings() {
    return new Autoexec(mountingpoints.getItems(), false, "", "", "", "", "",
    		booterButton.getSelection()? "file": "", "", exit.getSelection() ).toString(false);
  }
    
  private void selectSettingsByAutoexec(Configuration templateConf) {
    Autoexec autoexec = new Autoexec(templateConf.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
    exit.setSelection(autoexec.isExit());
    if (mountingpoints.getItemCount() == 0) {
      mountingpoints.setItems(autoexec.getMountingpoints());
      mountingpoints.setSelection(0);
    }
    dosButton.setSelection(!autoexec.isBooter());
    booterButton.setSelection(autoexec.isBooter());
  }
  
  private void selectSettingsByConfiguration(Configuration profileConf) {
    String priority = profileConf.getValue("sdl", "priority");
    String[] priorities = priority.split(",");
    if ((priorities != null) && (priorities.length >= 2)) {
      priority_active.setText(priorities[0]);
      priority_inactive.setText(priorities[1]);
    }
    waitonerror.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "waitonerror")).booleanValue());
    language.setText(profileConf.getValue("dosbox", "language"));
    captures.setText(profileConf.getValue("dosbox", "captures"));
    output.setText(profileConf.getValue("sdl", "output"));
    frameskip.setText(profileConf.getValue("render", "frameskip"));
    scaler.setText(profileConf.getValue("render", "scaler"));
    pixelshader.setText(profileConf.getValue("sdl", "pixelshader"));
    pixelshader.setEnabled(profileConf.hasValue("sdl", "pixelshader"));
    fullscreen.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "fullscreen")).booleanValue());
    fulldouble.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "fulldouble")).booleanValue());
    fullresolution.setText(profileConf.getValue("sdl", "fullresolution"));
    windowresolution.setText(profileConf.getValue("sdl", "windowresolution"));
    aspect.setSelection(Boolean.valueOf(profileConf.getValue("render", "aspect")).booleanValue());
    overscan.setText(profileConf.getValue("sdl", "overscan"));
    overscan.setEnabled(profileConf.hasValue("sdl", "overscan"));
    svgachipset.setText(profileConf.getValue("vga", "svgachipset"));
    svgachipset.setEnabled(profileConf.hasValue("vga", "svgachipset"));
    videoram.setText(profileConf.getValue("vga", "videoram"));
    videoram.setEnabled(profileConf.hasValue("vga", "videoram"));
    vsyncmode.setText(profileConf.getValue("vsync", "vsyncmode"));
    vsyncmode.setEnabled(profileConf.hasValue("vsync", "vsyncmode"));
    vsyncrate.setText(profileConf.getValue("vsync", "vsyncrate"));
    vsyncrate.setEnabled(profileConf.hasValue("vsync", "vsyncrate"));
    glide.setSelection(Boolean.valueOf(profileConf.getValue("glide", "glide")).booleanValue());
    glide.setEnabled(profileConf.hasValue("glide", "glide"));
    glideport.setText(profileConf.getValue("glide", "port"));
    glideport.setEnabled(profileConf.hasValue("glide", "port") && glide.getSelection());
    machine.setText(profileConf.getValue("dosbox", "machine"));
    core.setText(profileConf.getValue("cpu", "core"));
    cycles.setText(profileConf.getValue("cpu", "cycles"));
    cycles_up.setText(profileConf.getValue("cpu", "cycleup"));
    cycles_down.setText(profileConf.getValue("cpu", "cycledown"));
    timesynched.setSelection(Boolean.valueOf(profileConf.getValue("cpu", "timesynched")).booleanValue());
    timesynched.setEnabled(profileConf.hasValue("cpu", "timesynched"));
    memsize.setText(profileConf.getValue("dosbox", "memsize"));
    xms.setSelection(Boolean.valueOf(profileConf.getValue("dos", "xms")).booleanValue());
    ems.setSelection(Boolean.valueOf(profileConf.getValue("dos", "ems")).booleanValue());
    umb.setText(profileConf.getValue("dos", "umb"));
    nosound.setSelection(Boolean.valueOf(profileConf.getValue("mixer", "nosound")).booleanValue());
    rate.setText(profileConf.getValue("mixer", "rate"));
    mt32rate.setText(profileConf.getValue("midi", "mt32rate"));
    mt32rate.setEnabled(profileConf.hasValue("midi", "mt32rate"));
    blocksize.setText(profileConf.getValue("mixer", "blocksize"));
    prebuffer.setText(profileConf.getValue("mixer", "prebuffer"));
    mpu401.setText(profileConf.getValue("midi", "mpu401"));
    device.setText(profileConf.getValue("midi", "device"));
    midi_config.setText(profileConf.getValue("midi", "config"));
    sbtype.setText(profileConf.getValue("sblaster", "sbtype"));
    oplmode.setText(profileConf.getValue("sblaster", "oplmode"));
    oplrate.setText(profileConf.getValue("sblaster", "oplrate"));
    sbbase.setText(profileConf.getValue("sblaster", "sbbase"));
    irq.setText(profileConf.getValue("sblaster", "irq"));
    dma.setText(profileConf.getValue("sblaster", "dma"));
    hdma.setText(profileConf.getValue("sblaster", "hdma"));
    mixer.setSelection(Boolean.valueOf(profileConf.getValue("sblaster", "mixer")).booleanValue());
    gus.setSelection(Boolean.valueOf(profileConf.getValue("gus", "gus")).booleanValue());
    gusrate.setText(profileConf.getValue("gus", "gusrate"));
    gusbase.setText(profileConf.getValue("gus", "gusbase"));
    irq1.setText(profileConf.getValue("gus", "irq1"));
    irq2.setText(profileConf.getValue("gus", "irq2"));
    dma1.setText(profileConf.getValue("gus", "dma1"));
    dma2.setText(profileConf.getValue("gus", "dma2"));
    ultradir.setText(profileConf.getValue("gus", "ultradir"));
    pcspeaker.setSelection(Boolean.valueOf(profileConf.getValue("speaker", "pcspeaker")).booleanValue());
    pcrate.setText(profileConf.getValue("speaker", "pcrate"));
    tandy.setText(profileConf.getValue("speaker", "tandy"));
    tandyrate.setText(profileConf.getValue("speaker", "tandyrate"));
    disney.setSelection(Boolean.valueOf(profileConf.getValue("speaker", "disney")).booleanValue());
    autolock.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "autolock")).booleanValue());
    sensitivity.setText(profileConf.getValue("sdl", "sensitivity"));
    usescancodes.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "usescancodes")).booleanValue());
    mapperfile.setText(profileConf.getValue("sdl", "mapperfile"));
    keyboard_layout.setText(profileConf.getValue("dos", "keyboardlayout"));
    keyboard_layout.setEnabled(profileConf.hasValue("dos", "keyboardlayout"));
    boolean usingNewJoystickSection = profileConf.hasValue("joystick", "joysticktype");
    if (!usingNewJoystickSection) {
    	joysticktype.setText(profileConf.getValue("bios", "joysticktype"));
    } else {
    	joysticktype.setText(profileConf.getValue("joystick", "joysticktype"));
    	timed.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "timed")).booleanValue());
    	autofire.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "autofire")).booleanValue());
    	swap34.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "swap34")).booleanValue());
    }
    timed.setEnabled(usingNewJoystickSection);
    autofire.setEnabled(usingNewJoystickSection);
    swap34.setEnabled(usingNewJoystickSection);
    serial1.setText(profileConf.getValue("serial", "serial1"));
    serial2.setText(profileConf.getValue("serial", "serial2"));
    serial3.setText(profileConf.getValue("serial", "serial3"));
    serial4.setText(profileConf.getValue("serial", "serial4"));
    ipx.setSelection(Boolean.valueOf(profileConf.getValue("ipx", "ipx")).booleanValue());
    
    selectSettingsByAutoexec(profileConf);
  }
  
  private void getConfigurationBySettings(Configuration dbversionConf, Configuration profileConf) {
    profileConf.setValue("sdl", "priority", priority_active.getText() + "," + priority_inactive.getText());
    profileConf.setValue("sdl", "waitonerror", String.valueOf(waitonerror.getSelection()));
    profileConf.setValue("dosbox", "language", language.getText());
    profileConf.setValue("dosbox", "captures", captures.getText());
    profileConf.setValue("sdl", "output", output.getText());
    profileConf.setValue("render", "frameskip", frameskip.getText());
    profileConf.setValue("render", "scaler", scaler.getText());
    profileConf.updateValue("sdl", "pixelshader", pixelshader.getText());
    profileConf.setValue("sdl", "fullscreen", String.valueOf(fullscreen.getSelection()));
    profileConf.setValue("sdl", "fulldouble", String.valueOf(fulldouble.getSelection()));
    profileConf.setValue("sdl", "fullresolution", fullresolution.getText());
    profileConf.setValue("sdl", "windowresolution", windowresolution.getText());
    profileConf.setValue("render", "aspect", String.valueOf(aspect.getSelection()));
    profileConf.updateValue("sdl", "overscan", overscan.getText());
    profileConf.updateValue("vga", "svgachipset", svgachipset.getText());
    profileConf.updateValue("vga", "videoram", videoram.getText());
    profileConf.updateValue("vsync", "vsyncmode", vsyncmode.getText());
    profileConf.updateValue("vsync", "vsyncrate", vsyncrate.getText());
    profileConf.updateValue("glide", "glide", String.valueOf(glide.getSelection()));
    profileConf.updateValue("glide", "port", glideport.getText());
    profileConf.setValue("dosbox", "machine", machine.getText());
    profileConf.setValue("cpu", "core", core.getText());
    profileConf.setValue("cpu", "cycles", cycles.getText());
    profileConf.setValue("cpu", "cycleup", cycles_up.getText());
    profileConf.setValue("cpu", "cycledown", cycles_down.getText());
    profileConf.updateValue("cpu", "timesynched", String.valueOf(timesynched.getSelection()));
    profileConf.setValue("dosbox", "memsize", memsize.getText());
    profileConf.setValue("dos", "xms", String.valueOf(xms.getSelection()));
    profileConf.setValue("dos", "ems", String.valueOf(ems.getSelection()));
    profileConf.setValue("dos", "umb", umb.getText());
    profileConf.setValue("mixer", "nosound", String.valueOf(nosound.getSelection()));
    profileConf.setValue("mixer", "rate", rate.getText());
    profileConf.updateValue("midi", "mt32rate", mt32rate.getText());
    profileConf.setValue("mixer", "blocksize", blocksize.getText());
    profileConf.setValue("mixer", "prebuffer", prebuffer.getText());
    profileConf.setValue("midi", "mpu401", mpu401.getText());
    profileConf.setValue("midi", "device", device.getText());
    profileConf.setValue("midi", "config", midi_config.getText());
    profileConf.setValue("sblaster", "sbtype", sbtype.getText());
    profileConf.setValue("sblaster", "oplmode", oplmode.getText());
    profileConf.setValue("sblaster", "oplrate", oplrate.getText());
    profileConf.setValue("sblaster", "sbbase", sbbase.getText());
    profileConf.setValue("sblaster", "irq", irq.getText());
    profileConf.setValue("sblaster", "dma", dma.getText());
    profileConf.setValue("sblaster", "hdma", hdma.getText());
    profileConf.setValue("sblaster", "mixer", String.valueOf(mixer.getSelection()));
    profileConf.setValue("gus", "gus", String.valueOf(gus.getSelection()));
    profileConf.setValue("gus", "gusrate", gusrate.getText());
    profileConf.setValue("gus", "gusbase", gusbase.getText());
    profileConf.setValue("gus", "irq1", irq1.getText());
    profileConf.setValue("gus", "irq2", irq2.getText());
    profileConf.setValue("gus", "dma1", dma1.getText());
    profileConf.setValue("gus", "dma2", dma2.getText());
    profileConf.setValue("gus", "ultradir", ultradir.getText());
    profileConf.setValue("speaker", "pcspeaker", String.valueOf(pcspeaker.getSelection()));
    profileConf.setValue("speaker", "pcrate", pcrate.getText());
    profileConf.setValue("speaker", "tandy", tandy.getText());
    profileConf.setValue("speaker", "tandyrate", tandyrate.getText());
    profileConf.setValue("speaker", "disney", String.valueOf(disney.getSelection()));
    profileConf.setValue("sdl", "autolock", String.valueOf(autolock.getSelection()));
    profileConf.setValue("sdl", "sensitivity", sensitivity.getText());
    profileConf.setValue("sdl", "usescancodes", String.valueOf(usescancodes.getSelection()));
    profileConf.setValue("sdl", "mapperfile", mapperfile.getText());
    profileConf.setValue("dos", "keyboardlayout", keyboard_layout.getText());
    if (!dbversionConf.hasValue("dos", "keyboardlayout"))
    	profileConf.removeValue("dos", "keyboardlayout");
    boolean usingNewJoystickSection = dbversionConf.hasValue("joystick", "joysticktype");
    if (!usingNewJoystickSection) {
    	profileConf.removeSection("joystick");
    	profileConf.setValue("bios", "joysticktype", joysticktype.getText());
    } else {
    	profileConf.removeSection("bios");
    	profileConf.setValue("joystick", "joysticktype", joysticktype.getText());
    	profileConf.setValue("joystick", "timed", String.valueOf(timed.getSelection()));
    	profileConf.setValue("joystick", "autofire", String.valueOf(autofire.getSelection()));
    	profileConf.setValue("joystick", "swap34", String.valueOf(swap34.getSelection()));
    }
    profileConf.setValue("serial", "serial1", serial1.getText());
    profileConf.setValue("serial", "serial2", serial2.getText());
    profileConf.setValue("serial", "serial3", serial3.getText());
    profileConf.setValue("serial", "serial4", serial4.getText());
    profileConf.setValue("ipx", "ipx", String.valueOf(ipx.getSelection()));
    
    profileConf.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, getAutoexecSectionBySettings());
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (title.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a template title", title, infoTabItem);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
