/* 
 * Created on 1-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: DosboxVersion.java,v $
 * @version $Revision: 1.8 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/11/18 22:00:09 $ (UTC date of last check in)
 */

package com.model;

import com.util.FileUtils;


public class DosboxVersion {

  private int id;
  private String title;
  private String path;
  private boolean multiConfig;
  private boolean defaultVersion;
  private String parameters;
  
  
  public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean version,
  		String parameters) {
    this.id = id;
    this.title = title;
    this.path = path;
    this.multiConfig = multiConfig;
    this.defaultVersion = version;
    this.parameters = parameters;
  }
  /**
   * @return Returns the defaultVersion.
   */
  public boolean isDefaultVersion() {
    return defaultVersion;
  }
  /**
   * @return Returns the defaultVersion as String.
   */
  public String isDefaultVersionString() {
    return defaultVersion ? "Yes": "No";
  }
  /**
   * @return Returns multiConfig.
   */
  public boolean isMultiConfig() {
    return multiConfig;
  }
  /**
   * @return Returns multiConfig as String.
   */
  public String isMultiConfigString() {
    return multiConfig ? "Yes": "No";
  }
  /**
   * @return Returns the id.
   */
  public int getId() {
    return id;
  }
  /**
   * @return Returns the path.
   */
  public String getPath() {
    return path;
  }
  
  /**
   * @return Returns the title.
   */
  public String getTitle() {
    return title;
  }
  
  public String getExecutable() {
  	return FileUtils.constructCanonicalDBExeLocation(path);
  }
  
  public String getConfigFile() {
  	return FileUtils.constructCanonicalDBConfLocation(path);
  }
  
  public String getParameters() {
  	return parameters;
  }
  
  public void toggleDefault() {
  	defaultVersion = !defaultVersion;
  }
}
