/* 
 * Created on 30-jun-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: Profile.java,v $
 * @version $Revision: 1.8 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/10/25 20:05:28 $ (UTC date of last check in)
 */

package com.model;

import com.util.FileUtils;


public class Profile {

  private int id;
  private String title;
  private String developerName;
  private String publisherName;
  private String genre;
  private String year;
  private int dbversionId;
  private String setup;
  private String setupParams;
  private String notes;
  private String link1;
  private String link2;
  private boolean favorite;
  private String status;
  private String confPathAndFile;
  private String captures;
  
  
  public Profile(int id, String title, String devName, String publName, String genre, String year, int dbversionId,
  		String setup, String setupParams, String notes, String link1, String link2, boolean favorite, String status,
  		String confPathAndFile, String captures) {
    this.id = id;
    this.title = title;
    this.developerName = devName;
    this.publisherName = publName;
    this.genre = genre;
    this.year = year;
    this.dbversionId = dbversionId;
    this.setup = setup;
    this.setupParams = setupParams;
    this.notes = notes;
    this.link1 = link1;
    this.link2 = link2;
    this.favorite = favorite;
    this.status = status;
    this.confPathAndFile = confPathAndFile;
    this.captures = captures;
  }
  /**
   * @return Returns the developerName.
   */
  public String getDeveloperName() {
    return developerName;
  }
  /**
   * @return Returns the genre.
   */
  public String getGenre() {
    return genre;
  }
  /**
   * @return Returns the id.
   */
  public int getId() {
    return id;
  }
  /**
   * @return Returns the publisherName.
   */
  public String getPublisherName() {
    return publisherName;
  }
  /**
   * @return Returns the title.
   */
  public String getTitle() {
    return title;
  }
  /**
   * @return Returns the year.
   */
  public String getYear() {
    return year;
  }
  /**
   * @return Returns the dbversionId.
   */
  public int getDbversionId() {
    return dbversionId;
  }
  /**
   * @return Returns whether the profile has a setup tool
   */
  public String hasSetup() {
    return setup.equals("")? "No": "Yes";
  }
  /**
   * @return Returns whether the profile has a setup tool
   */
  public boolean hasSetupBoolean() {
    return !setup.equals("");
  }
  /**
   * @return Returns the link1.
   */
  public String getLink1() {
    return link1;
  }
  /**
   * @return Returns the link2.
   */
  public String getLink2() {
    return link2;
  }
  /**
   * @return Returns the notes.
   */
  public String getNotes() {
    return notes;
  }
  /**
   * @return Returns the setup.
   */
  public String getSetup() {
    return setup;
  }
  /**
   * @return Returns the setup parameters.
   */
  public String getSetupParameters() {
    return setupParams;
  }
  /**
   * @return Returns the favorite.
   */
  public boolean isFavorite() {
    return favorite;
  }
  /**
   * @return Returns the favorite.
   */
  public String isFavoriteString() {
    return favorite? "Yes": "No";
  }
  /**
   * @return Returns the status.
   */
  public String getStatus() {
    return status;
  }
  
  public void toggleFavorite() {
  	favorite = !favorite;
  }
  
	public String getConfPathAndFile() {
		return confPathAndFile;
	}

	public String getCanonicalConfPathAndFile() {
		return FileUtils.constructCanonicalProfileConfig(confPathAndFile);
	}

  public String getCaptures() {
		return captures;
	}
}
