package com.gui;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.model.DosboxVersion;
import com.util.DFendImportThread;
import com.util.FileUtils;


public class DFendImportDialog extends Dialog {

	private Text location;
	private Text logText;
	private DosboxVersion defaultDosboxVersion;
	private DFendImportThread importThread;
	private Button cancelButton;
	private Label profileLabel;
	protected Shell shell;

	/**
	 * Create the dialog
	 * @param parent
	 * @param style
	 */
	public DFendImportDialog(Shell parent, int style) {
		super(parent, style);
	}

	/**
	 * Create the dialog
	 * @param parent
	 */
	public DFendImportDialog(Shell parent) {
		this(parent, SWT.NONE);
	}
	
	public void setDefaultDosboxVersion(DosboxVersion dbversion) {
		this.defaultDosboxVersion = dbversion;
	}
	
	/**
	 * Open the dialog
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (importThread != null && !importThread.isAlive() && !cancelButton.getText().equals("Close")) {
				GeneralPurposeDialogs.infoMessage(shell, "D-Fend profiles import completed successfully.");
				profileLabel.setText("Please review the log below for possible problems");
				profileLabel.pack();
				cancelButton.setText("Close");
			}	
			if (!display.readAndDispatch())
				display.sleep();
		}
		return importThread;
	}

	/**
	 * Create contents of the dialog
	 */
	protected void createContents() {
		shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setLayout(new GridLayout());
		shell.setSize(500, 375);
		shell.setText("Import D-Fend Profiles");

		final Group optionsGroup = new Group(shell, SWT.NONE);
		optionsGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		optionsGroup.setText("Options");
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		optionsGroup.setLayout(gridLayout);

		final Label dfendLocationLabel = new Label(optionsGroup, SWT.NONE);
		dfendLocationLabel.setText("D-Fend Location");

		location = new Text(optionsGroup, SWT.BORDER);
		location.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		location.setText(FileUtils.DFEND_PATH + FileUtils.DFEND_PROFILES);

		final Button browseButton = new Button(optionsGroup, SWT.NONE);
		browseButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				FileDialog dialog = new FileDialog (shell, SWT.OPEN);
		    dialog.setFilterPath(FileUtils.DFEND_PATH);
		    dialog.setFileName(FileUtils.DFEND_PROFILES);
		    dialog.setFilterNames (new String [] {"D-Fend Profiles"});
		    dialog.setFilterExtensions (new String [] {FileUtils.DFEND_PROFILES});
		    String dfendProfilesFile = dialog.open();
		    if (dfendProfilesFile != null)
		    	location.setText(dfendProfilesFile);
			}
		});
		browseButton.setText("Browse..");

		final Label cleanUpLabel = new Label(optionsGroup, SWT.NONE);
		cleanUpLabel.setText("Clean Up");

		final Button cleanup = new Button(optionsGroup, SWT.CHECK);
		cleanup.setText("(remove sections directserial, modem, ipx and sdl)");
		cleanup.setSelection(true);
		new Label(optionsGroup, SWT.NONE);

		final Button startImportButton = new Button(optionsGroup, SWT.NONE);
		shell.setDefaultButton(startImportButton);
		startImportButton.setLayoutData(new GridData(80, SWT.DEFAULT));
		startImportButton.setText("Start Import");

		cancelButton = new Button(optionsGroup, SWT.NONE);
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				shell.close();
			}
		});
		cancelButton.setLayoutData(new GridData(80, SWT.DEFAULT));
		cancelButton.setText("Cancel");
		new Label(optionsGroup, SWT.NONE);

		final Group progressGroup = new Group(shell, SWT.NONE);
		progressGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		progressGroup.setText("Progress");
		progressGroup.setLayout(new GridLayout());

		final ProgressBar progressBar = new ProgressBar(progressGroup, SWT.NONE);
		progressBar.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

		profileLabel = new Label(progressGroup, SWT.NONE);

		logText = new Text(progressGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.H_SCROLL);
		logText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		startImportButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				try {
					importThread = new DFendImportThread(location.getText(), cleanup.getSelection(), defaultDosboxVersion, logText, progressBar, profileLabel);
					location.setEnabled(false);
					browseButton.setEnabled(false);
					cleanup.setEnabled(false);
					startImportButton.setEnabled(false);
					importThread.start();
				} catch (IOException ex) {
					GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
					importThread = null;
				}
			}
		});
	}
}
