/* 
 * Created on Jul 9, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: EditMountDialog.java,v $
 * @version $Revision: 1.17 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2007/01/22 20:52:28 $ (UTC date of last check in)
 */

package com.gui;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.model.Mount;
import com.model.Settings;
import com.util.StringUtils;
import swing2swt.layout.BorderLayout;


public class EditMountDialog extends Dialog {

	private char defaultDriveletter = 'C';
	private Combo driveletter;
  private Button mountZipButton;
  private Button mountImageButton;
  private Button mountDirectoryButton;
  private Text mount_dir;
  private Text mount_label;
  private Combo mount_type;
  private Text imgmount_image;
  private Text zipmount_write;
  private Text zipmount_zip;
  private Text zipmount_label;
  private Combo zipmount_type;
  private Settings settings;
  protected Object result;
  protected Shell shell;

  /**
   * Create the dialog
   * @param parent
   */
  public EditMountDialog(Shell parent) {
    super(parent, SWT.NONE);
  }

  public void setMount(String mount) {
    this.result = mount;
  }
  
  public void setDefaultDriveletter(char driveletter) {
    this.defaultDriveletter = driveletter;
  }
  
  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
  	settings = Settings.getInstance();
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
    shell.setLayout(new BorderLayout(0, 0));
    shell.setSize(480, 440);
    if (result != null) {
      // meaning we are essentially editing an existing mount point
      shell.setText("Edit Mount Point");
    } else {
      shell.setText("Add Mount Point");
    }

    final Composite composite = new Composite(shell, SWT.NONE);
    final GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 4;
    composite.setLayout(gridLayout);

    final Label driveLetterLabel = new Label(composite, SWT.NONE);
    driveLetterLabel.setText("Drive Letter");

    driveletter = new Combo(composite, SWT.READ_ONLY);
    driveletter.setItems(new String[] {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
    		"N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"});
    driveletter.setLayoutData(new GridData());
    driveletter.select(defaultDriveletter - 'A');
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    mountDirectoryButton = new Button(composite, SWT.RADIO);
    mountDirectoryButton.setText("Mount Directory");

    mount_dir = new Text(composite, SWT.BORDER);
    mount_dir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    
    mount_dir.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(true);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(false);
      }
    });

    final Button browseButton = new Button(composite, SWT.NONE);
    browseButton.setLayoutData(new GridData());
    browseButton.setText("Browse..");
    browseButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (mount_dir.getText());
        String result = dialog.open();
        if (result != null) {
          mount_dir.setText(result);
        }
      }
    });
    new Label(composite, SWT.NONE);

    final Label asLabel = new Label(composite, SWT.NONE);
    asLabel.setLayoutData(new GridData());
    asLabel.setText("As");

    mount_type = new Combo(composite, SWT.READ_ONLY);
    mount_type.setItems(settings.getValues("profile", "mount_type"));
    mount_type.add("", 0);
    mount_type.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
    new Label(composite, SWT.NONE);

    final Label label = new Label(composite, SWT.NONE);
    label.setLayoutData(new GridData());
    label.setText("Label");

    mount_label = new Text(composite, SWT.BORDER);
    mount_label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    final Label lowlevelCdLabel = new Label(composite, SWT.NONE);
    lowlevelCdLabel.setLayoutData(new GridData());
    lowlevelCdLabel.setText("Force ioctl");

    final Button ioctlButton = new Button(composite, SWT.CHECK);
    ioctlButton.setLayoutData(new GridData());
    new Label(composite, SWT.NONE);

    final Label label_1 = new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1));

    mountImageButton = new Button(composite, SWT.RADIO);
    mountImageButton.setText("Mount CD-Image(s)");

    imgmount_image = new Text(composite, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL);
    imgmount_image.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
    imgmount_image.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(true);
        mountZipButton.setSelection(false);
      }
    });

    final Button browseButton_1 = new Button(composite, SWT.NONE);
    browseButton_1.setLayoutData(new GridData());
    browseButton_1.setText("Browse..");
    browseButton_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        FileDialog dialog = new FileDialog (shell, SWT.OPEN | SWT.MULTI);
        dialog.setFilterNames (new String [] {"CD Images", "*.*"});
        dialog.setFilterExtensions (new String [] {"*.iso;*.ISO;*.cue;*.CUE", "*.*"});
        String fPath = imgmount_image.getText().split(imgmount_image.getLineDelimiter())[0];
        dialog.setFilterPath(fPath);
        String result = dialog.open();
        if (result != null) {
        	String path = StringUtils.fixDir(dialog.getFilterPath());
        	String images = "";
        	for (String file: dialog.getFileNames())
        		images += path + File.separatorChar + file + "\n";
          imgmount_image.setText(images);
        }
      }
    });

    final Label label_2 = new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1));

    mountZipButton = new Button(composite, SWT.RADIO);
    mountZipButton.setText("Mount Zip");

    final Label zipLabel = new Label(composite, SWT.NONE);
    zipLabel.setLayoutData(new GridData());
    zipLabel.setText("Zip");

    zipmount_zip = new Text(composite, SWT.BORDER);
    zipmount_zip.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    zipmount_zip.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(true);
      }
    });

    final Button browseButton_2 = new Button(composite, SWT.NONE);
    browseButton_2.setLayoutData(new GridData());
    browseButton_2.setText("Browse..");
    browseButton_2.setText("Browse..");
    browseButton_2.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        FileDialog dialog = new FileDialog (shell, SWT.OPEN);
        dialog.setFilterNames (new String [] {"Zip files", "*.*"});
        dialog.setFilterExtensions (new String [] {"*.zip;*.ZIP", "*.*"});
        dialog.setFilterPath (zipmount_zip.getText());
        String result = dialog.open();
        if (result != null) {
          zipmount_zip.setText(result);
        }
      }
    });
    new Label(composite, SWT.NONE);

    final Label writeLabel = new Label(composite, SWT.NONE);
    writeLabel.setLayoutData(new GridData());
    writeLabel.setText("Write");

    zipmount_write = new Text(composite, SWT.BORDER);
    zipmount_write.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Button browseButton_3 = new Button(composite, SWT.NONE);
    browseButton_3.setLayoutData(new GridData());
    browseButton_3.setText("Browse..");
    browseButton_3.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (zipmount_write.getText());
        String result = dialog.open();
        if (result != null) {
          zipmount_write.setText(result);
        }
      }
    });
    new Label(composite, SWT.NONE);

    final Label asLabel_1 = new Label(composite, SWT.NONE);
    asLabel_1.setLayoutData(new GridData());
    asLabel_1.setText("As");

    zipmount_type = new Combo(composite, SWT.READ_ONLY);
    zipmount_type.setItems(settings.getValues("profile", "zipmount_type"));
    zipmount_type.add("", 0);
    zipmount_type.setLayoutData(new GridData());
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    final Label label_3 = new Label(composite, SWT.NONE);
    label_3.setLayoutData(new GridData());
    label_3.setText("Label");

    zipmount_label = new Text(composite, SWT.BORDER);
    zipmount_label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite, SWT.NONE);

    final Composite composite_1 = new Composite(shell, SWT.NONE);
    composite_1.setLayout(new RowLayout());
    composite_1.setLayoutData(BorderLayout.SOUTH);

    final Button okButton = new Button(composite_1, SWT.NONE);
    final RowData rowData = new RowData();
    rowData.width = 80;
    okButton.setLayoutData(rowData);
    shell.setDefaultButton(okButton);
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
        Mount mount = null;
        if (mountDirectoryButton.getSelection())
          mount = new Mount(Mount.MountingType.DIR, mount_type.getText(), driveletter.getText(),
                  mount_dir.getText(), mount_label.getText(), ioctlButton.getSelection(), "");
        else if (mountImageButton.getSelection())
          mount = new Mount(Mount.MountingType.IMAGE, "iso", driveletter.getText(),
                  imgmount_image.getText().replaceAll(imgmount_image.getLineDelimiter(), "\n"), "", false, "");
        else if (mountZipButton.getSelection())
          mount = new Mount(Mount.MountingType.PHYSFS, zipmount_type.getText(), driveletter.getText(),
                  zipmount_zip.getText(), zipmount_label.getText(), false, zipmount_write.getText());
        result = mount.toString();
        shell.close();
      }
    });
    okButton.setText("OK");

    final Button cancelButton = new Button(composite_1, SWT.NONE);
    final RowData rowData_1 = new RowData();
    rowData_1.width = 80;
    cancelButton.setLayoutData(rowData_1);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    mount_dir.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(true);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(false);
      }
    });
    imgmount_image.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(true);
        mountZipButton.setSelection(false);
      }
    });
    zipmount_zip.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(true);
      }
    });
    
    if (result != null) {
      // meaning we are essentially editing an existing mount point
      // so we need to set previous values
      Mount mount = new Mount((String)result);
      driveletter.setText(mount.getDriveletterString());
      switch (mount.getMountingType()) {
        case DIR:
          mountDirectoryButton.setSelection(true);
          mount_dir.setText(mount.getPath());
          if (!mount.getMountAs().equals(""))
            mount_type.setText(mount.getMountAs());
          mount_label.setText(mount.getLabel());
          ioctlButton.setSelection(mount.isIoctl());
          break;
        case PHYSFS:
          mountZipButton.setSelection(true);
          zipmount_zip.setText(mount.getPath());
          zipmount_write.setText(mount.getWrite());
          if (!mount.getMountAs().equals(""))
            zipmount_type.setText(mount.getMountAs());
          zipmount_label.setText(mount.getLabel());
          break;
        case IMAGE:
          mountImageButton.setSelection(true);
          imgmount_image.setText(mount.getPath());
      }
    } else {
      // new mount point, set default values
      mountDirectoryButton.setSelection(true);
    }
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (mountDirectoryButton.getSelection() && mount_dir.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a path to mount", mount_dir);
    else if (mountImageButton.getSelection() && imgmount_image.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter at least one image to mount", imgmount_image);
    else if (mountZipButton.getSelection() && zipmount_zip.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter an zip to mount", zipmount_zip);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
