package com.model;

import java.util.Enumeration;
import java.util.Vector;


public class OrderingVector {

	private class OrderingElement {

		private int column;
		private boolean ascending;

		OrderingElement(int c, boolean a) {
			this.column = c;
			this.ascending = a;
		}

		public boolean equals(Object obj) {
			return this.column == ((OrderingElement) obj).column;
		}

		public String toString() {
			return GAME_LIST_ORDER[column] + (ascending ? " ASC" : " DESC");
		}
	}

	private static final int MAX_ORDERING_COLUMNS = 3;
	private static final String[] GAME_LIST_ORDER = { "GAM.TITLE", "GAM.SETUP", "DEV.NAME",
		"PUBL.NAME", "GEN.NAME", "YR.YEAR", "STAT.STAT", "GAM.FAVORITE", "GAM.ID" };
	
	private Vector<OrderingElement> vector = null;
	
	
	public OrderingVector() {
		vector = new Vector<OrderingElement>(); 
	}
	
	public OrderingVector(int[] columnArray, boolean[] ascendingArray) {
		this();
		for (int i = 0; i < columnArray.length; i++)
			vector.add(new OrderingElement(columnArray[i], ascendingArray[i]));
	}
	
	public void addOrdering(int column, boolean ascending) {
	  OrderingElement newOrdering = new OrderingElement(column, ascending);
	  int existingIndex = vector.indexOf(newOrdering);
	  if (existingIndex != -1)
	  	vector.removeElementAt(existingIndex);
	  vector.insertElementAt(newOrdering, 0);
	  if (vector.size() > MAX_ORDERING_COLUMNS)
	  	vector.remove(MAX_ORDERING_COLUMNS);
	}
	
	public int[] getColumns() {
		int[] columnArray = new int[vector.size()];
		for (int i = 0; i < columnArray.length; i++)
			columnArray[i] = vector.get(i).column;
		return columnArray;
	}
	
	public boolean[] getAscendings() {
		boolean[] ascendingArray = new boolean[vector.size()];
		for (int i = 0; i < ascendingArray.length; i++)
			ascendingArray[i] = vector.get(i).ascending;
		return ascendingArray;
	}
  
	public String toClause() {
		StringBuffer orderingClause = new StringBuffer();
	  for (Enumeration<OrderingElement> e = vector.elements(); e.hasMoreElements();) {
	  	orderingClause.append(e.nextElement().toString()); 
	  	if (e.hasMoreElements()) orderingClause.append(",");
	  }
	  return orderingClause.toString();
	}
	
	public String toString() {
		return vector.toString();
	}
}
