package com.gui;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;


public class AutoSelectCombo {

	private Combo combo;
	private boolean programmaticallyChanging;
	private int currentLength;

	
	public AutoSelectCombo(Composite composite, int style) {
		combo = new Combo(composite, style);
		programmaticallyChanging = false;
		currentLength = 0;

		combo.addModifyListener(new ModifyListener() {
			
			public void modifyText(ModifyEvent e) {
				if (!programmaticallyChanging) {
					int index = indexOfClosestMatch(combo.getText());
					int newLength = combo.getText().length();
					if ((newLength > currentLength) && (index != -1)) {
						programmaticallyChanging = true;
						combo.setText(combo.getText() + combo.getItem(index).substring(newLength));
						combo.setSelection(new Point(newLength, combo.getText().length()));
						programmaticallyChanging = false;
					}
					currentLength = newLength;
				}
			}
		});
	}

	public void setLayoutData(Object arg0) {
		combo.setLayoutData(arg0);
	}

	public void setVisibleItemCount(int arg0) {
		combo.setVisibleItemCount(arg0);
	}

	public void add(String arg0) {
		combo.add(arg0);
	}

	public String getText() {
		return combo.getText();
	}

	public void select(int arg0) {
		combo.select(arg0);
	}

	public void setText(String arg0) {
		combo.setText(arg0);
		currentLength = combo.getText().length();
	}

	public int getSelectionIndex() {
		return combo.getSelectionIndex();
	}

	public int indexOf(String arg0) {
		return combo.indexOf(arg0);
	}

	public int indexOfClosestMatch(String text) {
		for (int i = 0; i < combo.getItemCount(); i++)
			if (combo.getItem(i).toLowerCase().startsWith(text.toLowerCase()))
				return i;
		return -1;
	}
}