package com.gui;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import com.util.FileUtils;


public class BrowseArchiveDialog extends Dialog {

	private List files;
	private String archive;
	protected Object result;
	protected Shell shell;

	/**
	 * Create the dialog
	 * @param parent
	 * @param style
	 */
	public BrowseArchiveDialog(Shell parent, int style) {
		super(parent, style);
		archive = null;
	}

	/**
	 * Create the dialog
	 * @param parent
	 */
	public BrowseArchiveDialog(Shell parent) {
		this(parent, SWT.NONE);
	}
	
	public void setArchive(String archive) {
		this.archive = archive;
	}

	/**
	 * Open the dialog
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		return result;
	}

	/**
	 * Create contents of the dialog
	 */
	protected void createContents() {
		shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		shell.setLayout(gridLayout);
		shell.setSize(400, 375);
		shell.setText("Archive Browser");

		files = new List(shell, SWT.V_SCROLL | SWT.BORDER);
		files.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		try {
			files.setItems(FileUtils.getExecutablesInZip(archive));
			if (files.getItemCount() <= 0) {
				GeneralPurposeDialogs.warningMessage(shell, "The archive doesn't appear to contain any executables.");
				return;
			}
			files.setSelection(0);
		} catch (IOException e) {
			GeneralPurposeDialogs.warningMessage(shell, "Could not read contents of archive: " + e.getMessage());
			return;
		}
		files.addMouseListener(new MouseAdapter() {
			public void mouseDoubleClick(final MouseEvent e) {
				result = archive + ':' + File.separatorChar + files.getItem(files.getSelectionIndex());
				shell.close();
			}
		});
		
		final Button okButton = new Button(shell, SWT.NONE);
		okButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				result = archive + ':' + File.separatorChar + files.getItem(files.getSelectionIndex());
				shell.close();
			}
		});
		final GridData gridData = new GridData(80, SWT.DEFAULT);
		okButton.setLayoutData(gridData);
		shell.setDefaultButton(okButton);
		okButton.setText("OK");

		final Button cancelButton = new Button(shell, SWT.NONE);
		final GridData gridData_1 = new GridData(80, SWT.DEFAULT);
		cancelButton.setLayoutData(gridData_1);
		cancelButton.setText("Cancel");
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				shell.close();
			}
		});
	}
}
