/* 
 * Created on Jul 23, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: Thumb.java,v $
 * @version $Revision: 1.4 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/14 19:44:26 $ (UTC date of last check in)
 */

package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import com.swtdesigner.SWTResourceManager;


public class Thumb extends Dialog {

  private static final double THUMB_FACTOR = 2.0;
  
  protected Object result;
  protected Shell shell;
  private Image thumb = null;

  /**
   * Create the dialog
   * @param parent
   * @param style
   */
  public Thumb(Shell parent, int style) {
    super(parent, style);
  }

  /**
   * Create the dialog
   * @param parent
   */
  public Thumb(Shell parent) {
    this(parent, SWT.NONE);
  }
  
  public void setThumb(String filename) {
    Image orgthumb = SWTResourceManager.getImage(filename);
    ImageData bigThumb = orgthumb.getImageData();
    int width = bigThumb.width;
    int height = bigThumb.height;
    if ((width <= 400) && (height <= 350))
      bigThumb = bigThumb.scaledTo((int)(width * THUMB_FACTOR), (int)(height * THUMB_FACTOR));
    thumb = new Image(this.getParent().getDisplay(), bigThumb);
  }

  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    if (thumb != null && !thumb.isDisposed())
      thumb.dispose();
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    if (thumb != null) {
      shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
      shell.setLayout(new FillLayout());
      shell.setSize(thumb.getImageData().width + 24, thumb.getImageData().height + 50);
      shell.setText("Screenshot");
      final Button button = new Button(shell, SWT.FLAT);
      button.addSelectionListener(new SelectionAdapter() {
        public void widgetSelected(final SelectionEvent e) {
          shell.close();
        }
      });
      button.setImage(thumb);
      button.pack();
    }
  }
}
