/* 
 * Created on 30-jun-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: Profile.java,v $
 * @version $Revision: 1.8 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/10/25 20:05:28 $ (UTC date of last check in)
 */

package com.model;

import com.util.FileUtils;


public class Profile {

  private int id;
  private String title;
  private String developerName;
  private String publisherName;
  private String genre;
  private String year;
  private int dbversionId;
  private String setup;
  private String setupParams;
  private String notes;
  private String[] link;
  private boolean favorite;
  private String status;
  private String confPathAndFile;
  private String captures;
  private String[] customString;
  private int[] customInt;
  
  
  public Profile(int id, String title, String devName, String publName, String genre, String year, int dbversionId,
  		String setup, String setupParams, String notes, String link1, String link2, boolean favorite, String status,
  		String confPathAndFile, String captures, String link3, String link4, 
  		String c1, String c2, String c3, String c4, String c5, String c6, String c7, String c8, int c9, int c10) {
    this.id = id;
    this.title = title;
    this.developerName = devName;
    this.publisherName = publName;
    this.genre = genre;
    this.year = year;
    this.dbversionId = dbversionId;
    this.setup = setup;
    this.setupParams = setupParams;
    this.notes = notes;
    this.favorite = favorite;
    this.status = status;
    this.confPathAndFile = confPathAndFile;
    this.captures = captures;
    this.link = new String[] {link1, link2, link3, link4};
    this.customString = new String[] {c1, c2, c3, c4, c5, c6, c7, c8};
    this.customInt = new int[] {c9, c10};
  }
  
  public Profile(int id, String confFile, String captures, Profile prof) {
  	this(id, prof.getTitle(), prof.getDeveloperName(),
    		prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getDbversionId(),
    		prof.getSetup(), prof.getSetupParameters(), prof.getNotes(), prof.getLink(0),
    		prof.getLink(1), prof.isFavorite(), prof.getStatus(), confFile, captures,
    		prof.getLink(2), prof.getLink(3), prof.getCustomString(0), prof.getCustomString(1),
    		prof.getCustomString(2), prof.getCustomString(3), prof.getCustomString(4), 
    		prof.getCustomString(5), prof.getCustomString(6), prof.getCustomString(7),
        prof.getCustomInt(0), prof.getCustomInt(1));
  }
  
  /**
   * @return Returns the developerName.
   */
  public String getDeveloperName() {
    return developerName;
  }
  /**
   * @return Returns the genre.
   */
  public String getGenre() {
    return genre;
  }
  /**
   * @return Returns the id.
   */
  public int getId() {
    return id;
  }
  /**
   * @return Returns the publisherName.
   */
  public String getPublisherName() {
    return publisherName;
  }
  /**
   * @return Returns the title.
   */
  public String getTitle() {
    return title;
  }
  /**
   * @return Returns the year.
   */
  public String getYear() {
    return year;
  }
  /**
   * @return Returns the dbversionId.
   */
  public int getDbversionId() {
    return dbversionId;
  }
  /**
   * @return Returns whether the profile has a setup tool
   */
  public String hasSetup() {
    return setup.equals("")? "No": "Yes";
  }
  /**
   * @return Returns whether the profile has a setup tool
   */
  public boolean hasSetupBoolean() {
    return !setup.equals("");
  }
  /**
   * @return Returns the link.
   */
  public String getLink(int i) {
    return link[i];
  }
  /**
   * @return Returns the notes.
   */
  public String getNotes() {
    return notes;
  }
  /**
   * @return Returns the setup.
   */
  public String getSetup() {
    return setup;
  }
  /**
   * @return Returns the setup parameters.
   */
  public String getSetupParameters() {
    return setupParams;
  }
  /**
   * @return Returns the favorite.
   */
  public boolean isFavorite() {
    return favorite;
  }
  /**
   * @return Returns the favorite.
   */
  public String isFavoriteString() {
    return favorite? "Yes": "No";
  }
  /**
   * @return Returns the status.
   */
  public String getStatus() {
    return status;
  }
  
  public void toggleFavorite() {
  	favorite = !favorite;
  }
  
	public String getConfPathAndFile() {
		return confPathAndFile;
	}

	public String getCanonicalConfPathAndFile() {
		return FileUtils.constructCanonicalProfileConfig(confPathAndFile);
	}

  public String getCaptures() {
		return captures;
	}
  
  public String getCustomString(int i) {
  	return customString[i];
  }
  
  public int getCustomInt(int i) {
  	return customInt[i];
  }
}
