package com.model;

import java.io.IOException;
import com.util.StringUtils;


public class Settings extends Configuration {

	private static final String SETTINGS_CONF = "settings.conf";
	
	
	private Settings() {
		super();
		try {
			parseConfigurationFile(SETTINGS_CONF, true);
		} catch (IOException e) {
			// if settings could not be read, use defaults
		}
		init();
  }
  
  private static class SettingsHolder {
  	private static Settings instance = new Settings();
  }
  
  public static Settings getInstance() {
    return SettingsHolder.instance;
  }
  
  public Settings(Settings settings) {
  	super(settings);
  }
  
	public void init() {
		createSection("gui");
		setDefaultValue("gui", "width", "904");
		setDefaultValue("gui", "height", "475");
		setDefaultValue("gui", "x", "10");
		setDefaultValue("gui", "y", "10");
		setDefaultBooleanValue("gui", "maximized", false);
		setDefaultValue("gui", "column1width", "150");
		setDefaultValue("gui", "column2width", "48");
		setDefaultValue("gui", "column3width", "100");
		setDefaultValue("gui", "column4width", "100");
		setDefaultValue("gui", "column5width", "70");
		setDefaultValue("gui", "column6width", "40");
		setDefaultValue("gui", "column7width", "60");
		setDefaultValue("gui", "column8width", "60");
		setDefaultValue("gui", "column9width", "38");
		setDefaultValue("gui", "column10width", "40");
		setDefaultValue("gui", "column11width", "70");
		setDefaultValue("gui", "column12width", "70");
		setDefaultValue("gui", "column13width", "70");
		setDefaultValue("gui", "column14width", "70");
		setDefaultValue("gui", "column15width", "70");
		setDefaultValue("gui", "column16width", "70");
		setDefaultValue("gui", "column17width", "70");
		setDefaultValue("gui", "column18width", "70");
		setDefaultValue("gui", "column19width", "44");
		setDefaultValue("gui", "column20width", "44");
		setDefaultBooleanValue("gui", "column1visible", true);
		setDefaultBooleanValue("gui", "column2visible", true);
		setDefaultBooleanValue("gui", "column3visible", true);
		setDefaultBooleanValue("gui", "column4visible", true);
		setDefaultBooleanValue("gui", "column5visible", true);
		setDefaultBooleanValue("gui", "column6visible", true);
		setDefaultBooleanValue("gui", "column7visible", true);
		setDefaultBooleanValue("gui", "column8visible", true);
		setDefaultBooleanValue("gui", "column9visible", true);
		setDefaultBooleanValue("gui", "column10visible", false);
		setDefaultBooleanValue("gui", "column11visible", false);
		setDefaultBooleanValue("gui", "column12visible", false);
		setDefaultBooleanValue("gui", "column13visible", false);
		setDefaultBooleanValue("gui", "column14visible", false);
		setDefaultBooleanValue("gui", "column15visible", false);
		setDefaultBooleanValue("gui", "column16visible", false);
		setDefaultBooleanValue("gui", "column17visible", false);
		setDefaultBooleanValue("gui", "column18visible", false);
		setDefaultBooleanValue("gui", "column19visible", false);
		setDefaultBooleanValue("gui", "column20visible", false);
		setDefaultValue("gui", "column2_1width", "300");
		setDefaultValue("gui", "column2_2width", "250");
		setDefaultValue("gui", "column2_3width", "50");
		setDefaultValue("gui", "column2_4width", "38");
		setDefaultValue("gui", "column3_1width", "500");
		setDefaultValue("gui", "column3_2width", "50");
		setDefaultValue("gui", "sortcolumn", "0 8");
		setDefaultValue("gui", "sortascending", "true true");
		setDefaultValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
		setDefaultValue("gui", "sashweights", "777 222");
		setDefaultBooleanValue("gui", "autosortonupdate", false);
		setDefaultValue("gui", "custom1", "Custom1");
		setDefaultValue("gui", "custom2", "Custom2");
		setDefaultValue("gui", "custom3", "Custom3");
		setDefaultValue("gui", "custom4", "Custom4");
		setDefaultValue("gui", "custom5", "Custom5");
		setDefaultValue("gui", "custom6", "Custom6");
		setDefaultValue("gui", "custom7", "Custom7");
		setDefaultValue("gui", "custom8", "Custom8");
		setDefaultValue("gui", "custom9", "Custom9");
		setDefaultValue("gui", "custom10","Custom10");
		
		createSection("profiledefaults");
		setDefaultIntValue("profiledefaults", "confpath", 0);
		setDefaultIntValue("profiledefaults", "conffile", 0);
		
		createSection("dosbox");
		setDefaultBooleanValue("dosbox", "hideconsole", false);
		
		createSection("communication");
		setDefaultBooleanValue("communication", "port_enabled", true);
  	setDefaultValue("communication", "port", "4740");
  	
  	createSection("profile");
  	setDefaultValue("profile", "priority_active", "lowest lower normal higher highest pause");
  	setDefaultValue("profile", "priority_inactive", "lowest lower normal higher highest pause");
  	setDefaultValue("profile", "output", "ddraw direct3d overlay opengl openglhq openglnb surface");
  	setDefaultValue("profile", "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
  	setDefaultValue("profile", "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x " +
  			"tv2x tv3x rgb2x rgb3x scan2x scan3x supereagle super2xsai 2xsai hq2x hq3x hardware2x hardware3x " +
  			"tv tvadvmame2x normal4x");
  	setDefaultValue("profile", "pixelshader", "none 2xsai.fx 2xsai_srgb.fx bilinear.fx cartoon.fx gs2x.fx " +
  			"gs4x.fx gs4xcolor.fx gs4xcolorfilter.fx gs4xcolorscale.fx gs4xfilter.fx gs4xscale.fx matrix.fx " +
  			"mcgreen.fx mcorange.fx point.fx scale2x.fx scale2x_ps14.fx sketch.fx");
  	setDefaultValue("profile", "fullresolution",
  			"original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
  	setDefaultValue("profile", "windowresolution",
  			"original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
  	setDefaultValue("profile", "svgachipset", "none et3000 et4000 et4000new pvga1a s3");
  	setDefaultValue("profile", "videoram", "256 512 1024 2048 3072 4096");
  	setDefaultValue("profile", "vsyncmode", "off on force");
  	setDefaultValue("profile", "machine", "cga hercules pcjr tandy vga");
  	setDefaultValue("profile", "core", "dynamic full normal simple auto");
  	setDefaultValue("profile", "cycles", "500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 " +
  			"25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max<space>50% max<space>80% max<space>90% max");
  	setDefaultValue("profile", "cycles_up", "20 50 100 500 1000 2000 5000 10000");
  	setDefaultValue("profile", "cycles_down", "20 50 100 500 1000 2000 5000 10000");
  	setDefaultValue("profile", "memsize", "0 1 2 4 8 16 32 63");
  	setDefaultValue("profile", "umb", "false true max");
  	setDefaultValue("profile", "loadfix_value", "1 63 127");
  	setDefaultValue("profile", "rate", "11025 22050 44100");
  	setDefaultValue("profile", "blocksize", "512 1024 2048 3072 4096 8192");
  	setDefaultValue("profile", "prebuffer", "10");
  	setDefaultValue("profile", "mpu401", "none intelligent uart");
  	setDefaultValue("profile", "device", "alsa default coreaudio mt32 none oss win32");
  	setDefaultValue("profile", "mt32rate", "11025 22050 44100");
  	setDefaultValue("profile", "sbtype", "none sb1 sb2 sbpro1 sbpro2 sb16");
  	setDefaultValue("profile", "oplrate", "11025 22050 44100");
  	setDefaultValue("profile", "oplmode", "auto cms opl2 dualopl2 opl3");
  	setDefaultValue("profile", "sbbase", "210 220 240 260 280");
  	setDefaultValue("profile", "irq", "3 5 7 10 11");
  	setDefaultValue("profile", "dma", "0 1 3");
  	setDefaultValue("profile", "hdma", "5 6 7");
  	setDefaultValue("profile", "gusrate", "11025 22050 44100");
  	setDefaultValue("profile", "gusbase", "210 220 240 260 280");
  	setDefaultValue("profile", "irq1", "3 5 7 10 11");
  	setDefaultValue("profile", "irq2", "3 5 7 10 11");
  	setDefaultValue("profile", "dma1", "0 1 3");
  	setDefaultValue("profile", "dma2", "0 1 3");
  	setDefaultValue("profile", "pcrate", "11025 22050 44100");
  	setDefaultValue("profile", "tandy", "auto off on");
  	setDefaultValue("profile", "tandyrate", "11025 22050 44100");
  	setDefaultValue("profile", "sensitivity", "10 20 30 40 50 60 70 80 90 100 125 150 175 200 250 300 350 400 " +
  			"450 500 550 600 700 800 900 1000");
  	setDefaultValue("profile", "joysticktype", "auto none 2axis 4axis ch fcs");
  	setDefaultValue("profile", "mount_type", "cdrom dir floppy");
  	setDefaultValue("profile", "zipmount_type", "cdrom dir floppy");
  	setDefaultValue("profile", "freesize", "1 10 100 200 500 1000");
	}
	
	public void setIntValues(String sectionTitle, String sectionItem, int[] values) {
		setValue(sectionTitle, sectionItem, StringUtils.intArrayToString(values));
	}
	
	public int[] getIntValues(String sectionTitle, String sectionItem) {
		return StringUtils.stringToIntArray(getValue(sectionTitle, sectionItem));
	}
	
	public void setBooleanValues(String sectionTitle, String sectionItem, boolean[] values) {
		setValue(sectionTitle, sectionItem, StringUtils.booleanArrayToString(values));
	}
	
	public boolean[] getBooleanValues(String sectionTitle, String sectionItem) {
		return StringUtils.stringToBooleanArray(getValue(sectionTitle, sectionItem));
	}
	
	public void updateWithValuesFrom(Configuration conf) {
		for (String sectionTitle: conf.sections.keySet())
			for (String sectionItem: conf.getItems(sectionTitle))
				this.setValue(sectionTitle, sectionItem, conf.getValue(sectionTitle, sectionItem));
	}
	
	public void save() throws IOException {
	  saveToFile(SETTINGS_CONF, true);
  }
}
