package com.gui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import com.model.Mount;


public final class GrabButton {

	private Button button;

	
	public GrabButton(Composite composite, int style) {
		button = new Button(composite, style);
		button.setText("Grab");
	}
	
	public void connect(final Text text, final List source) {
		button.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		int index = source.getSelectionIndex();
    		if (index != -1) {
    			Mount mount = new Mount(source.getItem(index));
    			text.setText(mount.getPathAsString());
    			text.selectAll();
    			text.setFocus();
    		}
    	}
    });
	}
}
