package com.swtdesigner;

import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import com.gui.MainWindow;


public final class SWTImageManager {

	private static final HashMap<String, Image> imageMap = new HashMap<String, Image>();

	
	public static void dispose() {
		for (Image image: imageMap.values())
			image.dispose();
		imageMap.clear();
	}

	public static Image getImage(String path) {
		Display display = Display.getCurrent();
		try {
			return new Image(display, path);
		} catch (Exception e) {
			Image image = new Image(display, MainWindow.THUMB_HEIGHT, MainWindow.THUMB_HEIGHT);
			GC gc = new GC(image);
			gc.setBackground(display.getSystemColor(SWT.COLOR_RED));
			gc.fillRectangle(0, 0, MainWindow.THUMB_HEIGHT, MainWindow.THUMB_HEIGHT);
			gc.dispose();
			return image;
		}
	}
	
	public static Image getResizedImage(int height, String path) {
		Image image = imageMap.get(path);
		if (image == null) {
			Display display = Display.getCurrent();
			Image orgImage = getImage(path);
			int w = orgImage.getBounds().width;
      int h = orgImage.getBounds().height;
      double factor = (double)height / (double)h;
      int wf = (int)(w * factor);
      int hf = (int)(h * factor);
      image = new Image(display, wf, hf);
      GC gc = new GC(image);
      gc.setAntialias(SWT.ON);
      gc.drawImage(orgImage, 0, 0, w, h, 0, 0, wf, hf);
      gc.dispose();
			imageMap.put(path, image);
		}
		return image;
	}
}