package com.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.KeyValuePair;


public final class DFendImportThread extends Thread {

	private String title;
	private int profileNumber;
	private StringBuffer messageLog;
	private boolean performCleanup;
	private DosboxVersion defaultDBVersion;
	private Configuration standardProfile;
	private Configuration profiles;
	private Display display;
	private Text log;
	private ProgressBar progressBar;
	private Label profileLabel;
	
	
	public DFendImportThread(File dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion,
			Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
		this.performCleanup = performCleanup;
		this.defaultDBVersion = defaultDBVersion;
		this.standardProfile = new Configuration(defaultDBVersion.getCanonicalConfFile());
		this.log = log;
		this.progressBar = progressBar;
		this.profileLabel = profileLabel;
		this.display = log.getShell().getDisplay();
		this.profiles = new Configuration(dfendProfilesFile, false);
    this.progressBar.setMaximum(profiles.getSectionKeys().size());
    this.profileNumber = 0;
	}
	
	public void run() {
		Database db = Database.getInstance();
    
		try {
	    Iterator it = profiles.getSectionKeys().iterator();
	    while (it.hasNext()) {
	    	messageLog = new StringBuffer();
	    	
	    	title = (String)it.next();
	    	String profFile = profiles.getValue(title, "prof");
	      String confFile = profiles.getValue(title, "conf");
	      boolean favorite = profiles.getValue(title, "fav").equals("1");
	      try {
	      	Configuration dfendExtra = new Configuration(new File(profFile), false);
		      String setup = dfendExtra.getValue("Extra", "Setup");
		      String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
		      String notes = dfendExtra.getValue("ExtraInfo", "Notes");
		      String dev = dfendExtra.getValue("ExtraInfo", "Developer");
		      String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
		      String gen = dfendExtra.getValue("ExtraInfo", "Genre");
		      String yr = dfendExtra.getValue("ExtraInfo", "Year");
		      String st = "Unknown";
		      String cap = dfendExtra.getValue("dosbox", "captures");
		      int devId = KeyValuePair.findIdByValue(db.readDevelopersList(), dev);
		      int publId = KeyValuePair.findIdByValue(db.readPublishersList(), pub);
		      int genId = KeyValuePair.findIdByValue(db.readGenresList(), gen);
		      int yrId = KeyValuePair.findIdByValue(db.readYearsList(), yr);
		      int statId = KeyValuePair.findIdByValue(db.readStatusList(), st);
		      
		      try {
			      int profileId = db.addOrEditProfile(title, dev, pub, gen, yr, st, setup, setupParams, notes,
			      		favorite, devId, publId, genId, yrId, statId, defaultDBVersion.getId(),
			      		new String[] {"", "", "", ""}, new String[] {"", "", "", "", "", "", "", ""},
			      		new int[] {0, 0}, new int[] {0, 0, 0, 0}, -1);
			      final Configuration dfendProfile = new Configuration(new File(confFile));
			      Autoexec autoexec = new Autoexec(dfendProfile.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
			      dfendProfile.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(false));
			      
			      String dstCap = FileUtils.constructCapturesDir(profileId);
			      String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
			      File dstCapAbsolute = FileUtils.canonicalToData(dstCap);
			      FileUtils.createDir(dstCapAbsolute);
			      FileUtils.copyFiles(new File(cap), dstCapAbsolute);
			      dfendProfile.setValue("dosbox", "captures", dstCapRelative);
			      
			      // clean up profile configuration
			      if (performCleanup) {
				      dfendProfile.removeSection("directserial");
				      dfendProfile.removeSection("modem");
				      dfendProfile.removeSection("ipx");
				      dfendProfile.removeSection("sdl");
			      }
			      dfendProfile.removeValue("gus", "base");
			      dfendProfile.removeValue("gus", "rate");
			      dfendProfile.removeValue("sblaster", "base");
			      dfendProfile.removeValue("sblaster", "type");
			      if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
			        if (dfendProfile.getValue("midi", "intelligent").equals("true"))
			          dfendProfile.setValue("midi", "mpu401", "intelligent");
			        else if (dfendProfile.getValue("midi", "intelligent").equals("false"))
			          dfendProfile.setValue("midi", "mpu401", "uart");
			      } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
			        dfendProfile.setValue("midi", "mpu401", "none");
			      }
			      dfendProfile.removeValue("midi", "intelligent");
			      if (defaultDBVersion.isMultiConfig())
			    	  dfendProfile.substract(standardProfile);
			      
			      String newConfFile = FileUtils.constructUniqueConfigFileString(profileId, title, dfendProfile);
			      dfendProfile.saveToFile(FileUtils.canonicalToData(newConfFile));
			      
			      db.updateProfileConf(newConfFile, dstCap, profileId);
			      
			      messageLog.append(dfendExtra.getParsingProblems());
			      messageLog.append(dfendProfile.getParsingProblems());
		      } catch (SQLException se) {
		      	messageLog.append(se.getMessage() + "\n");
		      }
	      } catch (IOException e) {
	      	messageLog.append(e.getMessage() + "\n");
	      }
	      
	      if (display.isDisposed() || log.isDisposed() || progressBar.isDisposed()) break;
				display.asyncExec(new Runnable() {
					public void run() {
						profileLabel.setText("Importing " + title + "...");
						profileLabel.pack();
						log.append(messageLog.toString());
						progressBar.setSelection(profileNumber++);
					}
				});
	    }
		} catch (SQLException se) {
			messageLog.append(se.getMessage());
			display.asyncExec(new Runnable() {
				public void run() {
					log.append(messageLog.toString());
				}
			});
		}
	}
}
