package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.gui.BrowseButton.BrowseType;
import com.gui.BrowseButton.CanonicalType;
import com.model.Mount;
import com.model.Settings;
import com.util.StringUtils;
import swing2swt.layout.BorderLayout;


public class EditMountDialog extends Dialog {

	private Combo freesize;
	private char defaultDriveletter = 'C';
	private Combo driveletter;
  private Button mountZipButton;
  private Button mountImageButton;
  private Button mountDirectoryButton;
  private Text mount_dir;
  private Text mount_label;
  private Combo mount_type;
  private Text imgmount_image;
  private Text zipmount_write;
  private Text zipmount_zip;
  private Text zipmount_label;
  private Combo zipmount_type;
  private Settings settings;
  protected Object result;
  protected Shell shell;

  /**
   * Create the dialog
   * @param parent
   */
  public EditMountDialog(Shell parent) {
    super(parent, SWT.NONE);
  }

  public void setMount(String mount) {
    this.result = mount;
  }
  
  public void setDefaultDriveletter(char driveletter) {
    this.defaultDriveletter = driveletter;
  }
  
  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
  	settings = Settings.getInstance();
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
    shell.setLayout(new BorderLayout(0, 0));
    shell.setSize(520, 460);
    if (result != null) {
      // meaning we are essentially editing an existing mount point
      shell.setText("Edit Mount Point");
    } else {
      shell.setText("Add Mount Point");
    }

    final Composite composite = new Composite(shell, SWT.NONE);
    final GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 5;
    composite.setLayout(gridLayout);

    final Label driveLetterLabel = new Label(composite, SWT.NONE);
    driveLetterLabel.setText("Drive Letter");

    driveletter = new Combo(composite, SWT.READ_ONLY);
    driveletter.setItems(new String[] {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
    		"N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"});
    driveletter.setLayoutData(new GridData());
    driveletter.select(defaultDriveletter - 'A');
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    mountDirectoryButton = new Button(composite, SWT.RADIO);
    mountDirectoryButton.setText("Mount Directory");

    mount_dir = new Text(composite, SWT.BORDER);
    mount_dir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
    
    mount_dir.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(true);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(false);
      }
    });

    final BrowseButton browseButton = new BrowseButton(composite, SWT.NONE);
		browseButton.connect(shell, mount_dir, null, BrowseType.DIR, CanonicalType.DOSROOT, null);
		
    new Label(composite, SWT.NONE);

    final Label asLabel = new Label(composite, SWT.NONE);
    asLabel.setLayoutData(new GridData());
    asLabel.setText("As");

    mount_type = new Combo(composite, SWT.READ_ONLY);
    mount_type.setItems(settings.getValues("profile", "mount_type"));
    mount_type.add("", 0);
    mount_type.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 3, 1));
    new Label(composite, SWT.NONE);

    final Label label = new Label(composite, SWT.NONE);
    label.setLayoutData(new GridData());
    label.setText("Label");

    mount_label = new Text(composite, SWT.BORDER);
    mount_label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    final Label lowlevelCdLabel = new Label(composite, SWT.NONE);
    lowlevelCdLabel.setLayoutData(new GridData());
    lowlevelCdLabel.setText("Force ioctl");

    final Button ioctlButton = new Button(composite, SWT.CHECK);
    ioctlButton.setLayoutData(new GridData());
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    final Label freesizeLabel = new Label(composite, SWT.NONE);
    freesizeLabel.setText("Freesize");

    freesize = new Combo(composite, SWT.NONE);
    freesize.setItems(settings.getValues("profile", "freesize"));
    freesize.setVisibleItemCount(10);
    freesize.add("", 0);
    freesize.setLayoutData(new GridData());

    final Label mbLabel = new Label(composite, SWT.NONE);
    mbLabel.setText("MB");
    new Label(composite, SWT.NONE);

    final Label label_1 = new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

    mountImageButton = new Button(composite, SWT.RADIO);
    mountImageButton.setText("Mount CD-Image(s)");

    imgmount_image = new Text(composite, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL);
    imgmount_image.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
    imgmount_image.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(true);
        mountZipButton.setSelection(false);
      }
    });

    final BrowseButton imgBrowseButton = new BrowseButton(composite, SWT.NONE);
    imgBrowseButton.connect(shell, imgmount_image, null, BrowseType.FILE, CanonicalType.CDIMAGE, null);

    final Label label_2 = new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

    mountZipButton = new Button(composite, SWT.RADIO);
    mountZipButton.setText("Mount Zip");

    final Label zipLabel = new Label(composite, SWT.NONE);
    zipLabel.setLayoutData(new GridData());
    zipLabel.setText("Zip");

    zipmount_zip = new Text(composite, SWT.BORDER);
    zipmount_zip.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    zipmount_zip.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(true);
      }
    });
    
    final BrowseButton zipBrowseButton = new BrowseButton(composite, SWT.NONE);
    zipBrowseButton.connect(shell, zipmount_zip, null, BrowseType.FILE, CanonicalType.ZIP, null);
    
    new Label(composite, SWT.NONE);

    final Label writeLabel = new Label(composite, SWT.NONE);
    writeLabel.setLayoutData(new GridData());
    writeLabel.setText("Write");

    zipmount_write = new Text(composite, SWT.BORDER);
    zipmount_write.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

    final BrowseButton writeBrowseButton = new BrowseButton(composite, SWT.NONE);
    writeBrowseButton.connect(shell, zipmount_write, null, BrowseType.FILE, CanonicalType.ZIP, null);
    
    new Label(composite, SWT.NONE);

    final Label asLabel_1 = new Label(composite, SWT.NONE);
    asLabel_1.setLayoutData(new GridData());
    asLabel_1.setText("As");

    zipmount_type = new Combo(composite, SWT.READ_ONLY);
    zipmount_type.setItems(settings.getValues("profile", "zipmount_type"));
    zipmount_type.add("", 0);
    zipmount_type.setLayoutData(new GridData());
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);
    new Label(composite, SWT.NONE);

    final Label label_3 = new Label(composite, SWT.NONE);
    label_3.setLayoutData(new GridData());
    label_3.setText("Label");

    zipmount_label = new Text(composite, SWT.BORDER);
    zipmount_label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    new Label(composite, SWT.NONE);

    final Composite composite_1 = new Composite(shell, SWT.NONE);
    composite_1.setLayout(new RowLayout());
    composite_1.setLayoutData(BorderLayout.SOUTH);

    final Button okButton = new Button(composite_1, SWT.NONE);
    final RowData rowData = new RowData();
    rowData.width = 80;
    okButton.setLayoutData(rowData);
    shell.setDefaultButton(okButton);
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
        Mount mount = null;
        if (mountDirectoryButton.getSelection())
          mount = new Mount(Mount.MountingType.DIR, mount_type.getText(), driveletter.getText(),
                  new String[] {mount_dir.getText()}, mount_label.getText(), ioctlButton.getSelection(), "", freesize.getText());
        else if (mountImageButton.getSelection())
          mount = new Mount(Mount.MountingType.IMAGE, "iso", driveletter.getText(),
          				StringUtils.textAreaToStringArray(imgmount_image.getText(), imgmount_image.getLineDelimiter()), "", false, "", "");
        else if (mountZipButton.getSelection())
          mount = new Mount(Mount.MountingType.PHYSFS, zipmount_type.getText(), driveletter.getText(),
          		new String[] {zipmount_zip.getText()}, zipmount_label.getText(), false, zipmount_write.getText(), "");
        result = mount.toString();
        shell.close();
      }
    });
    okButton.setText("OK");

    final Button cancelButton = new Button(composite_1, SWT.NONE);
    final RowData rowData_1 = new RowData();
    rowData_1.width = 80;
    cancelButton.setLayoutData(rowData_1);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    mount_dir.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(true);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(false);
      }
    });
    imgmount_image.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(true);
        mountZipButton.setSelection(false);
      }
    });
    zipmount_zip.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountDirectoryButton.setSelection(false);
        mountImageButton.setSelection(false);
        mountZipButton.setSelection(true);
      }
    });
    
    if (result != null) {
      // meaning we are essentially editing an existing mount point
      // so we need to set previous values
      Mount mount = new Mount((String)result);
      driveletter.setText(mount.getDriveletterString());
      switch (mount.getMountingType()) {
        case DIR:
          mountDirectoryButton.setSelection(true);
          mount_dir.setText(mount.getPathAsString());
          if (!mount.getMountAs().equals(""))
            mount_type.setText(mount.getMountAs());
          mount_label.setText(mount.getLabel());
          ioctlButton.setSelection(mount.isIoctl());
          if (!mount.getFreesize().equals(""))
            freesize.setText(mount.getFreesize());
          mount_dir.selectAll();
          mount_dir.setFocus();
          break;
        case PHYSFS:
          mountZipButton.setSelection(true);
          zipmount_zip.setText(mount.getPathAsString());
          zipmount_write.setText(mount.getWriteAsString());
          if (!mount.getMountAs().equals(""))
            zipmount_type.setText(mount.getMountAs());
          zipmount_label.setText(mount.getLabel());
          zipmount_zip.selectAll();
          zipmount_zip.setFocus();
          break;
        case IMAGE:
          mountImageButton.setSelection(true);
          imgmount_image.setText(mount.getImgMountAsString());
          imgmount_image.selectAll();
          imgmount_image.setFocus();
      }
    } else {
      // new mount point, set default values
      mountDirectoryButton.setSelection(true);
      mount_dir.setText(".");
      mount_dir.selectAll();
      mount_dir.setFocus();
    }
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (mountDirectoryButton.getSelection() && mount_dir.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a path to mount", mount_dir);
    else if (mountImageButton.getSelection() && imgmount_image.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter at least one image to mount", imgmount_image);
    else if (mountZipButton.getSelection() && zipmount_zip.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter an zip to mount", zipmount_zip);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
