package com.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import com.util.FileUtils;
import com.util.PlatformUtils;


public class Autoexec {

  private List<Mount> mountingpoints;
  private boolean loadfix;
  private int loadfixValue;
  private String main;
  private String setup;
  private String img1;
  private String img2;
  private boolean exit;
  private boolean isBooter;
  private String mainParams;
  private String setupParams;


  public Autoexec(String[] mountingpoints, boolean loadfix, String loadfixValue,
          String main, String setup, String mainParams, String setupParams,
          String img1, String img2, boolean exit) {
    this.mountingpoints = new ArrayList<Mount>();
    for (String mount: mountingpoints)
      this.mountingpoints.add(new Mount(mount));
    this.loadfix = loadfix;
    try {
      this.loadfixValue = Integer.parseInt(loadfixValue);
    } catch (NumberFormatException e) {
      this.loadfixValue = 0;
    }
    this.main = main;
    this.setup = setup;
    this.img1 = img1;
    this.img2 = img2;
    this.exit = exit;
    this.mainParams = mainParams;
    this.setupParams = setupParams;
  }

  public Autoexec(String autoexec) {
    init();
    
    if (autoexec.equals(""))
      return;
    
    String[] orgLines = autoexec.split("\n");
    char driveletter = '\0';
    char imgdriveletter1 = '\0';
    char imgdriveletter2 = '\0';
    String remainder = "";
    String executable = "";
    String image1 = "";
    String image2 = "";
    int exeIndex = -1;
    
    for (String orgLine: orgLines) {
      String line = orgLine.toLowerCase();
      if (line.startsWith("mount") || line.startsWith("imgmount")) {
      	mountingpoints.add(new Mount(orgLine));
      } else if (line.endsWith(":") && line.length() == 2) {
        driveletter = line.charAt(0);
      } else if (line.startsWith("cd\\")) {
      	remainder = PlatformUtils.toNativePath(orgLine).substring(2);
      } else if (line.startsWith("cd ")) {
      	remainder = PlatformUtils.toNativePath(orgLine).substring(3);
      } else if ((exeIndex = line.indexOf(FileUtils.EXECUTABLES[0])) != -1 || 
                 (exeIndex = line.indexOf(FileUtils.EXECUTABLES[1])) != -1 ||
                 (exeIndex = line.indexOf(FileUtils.EXECUTABLES[2])) != -1) {
      	executable = orgLine;
        // If there is a space BEFORE executable name, strip everything before it
        int spaceBeforeIndex = executable.lastIndexOf(" ", exeIndex);
        if (spaceBeforeIndex != -1) {
          executable = executable.substring(spaceBeforeIndex + 1);
        }
        // If there is a space AFTER executable name, define it as being parameters
        int spaceAfterIndex = executable.indexOf(" ");
        if (spaceAfterIndex != -1) {
          mainParams = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
          executable = executable.substring(0, spaceAfterIndex);
        }
      } else if (line.startsWith("boot ")) {
        isBooter = true;
        int spaceIndex = line.indexOf(' ', 5);
        if (spaceIndex != -1) {
          imgdriveletter2 = line.charAt(spaceIndex + 1);
          image2 = PlatformUtils.toNativePath(orgLine).substring(spaceIndex + 3);
        } else {
          spaceIndex = line.length();
        }
        imgdriveletter1 = line.charAt(5);
        image1 = PlatformUtils.toNativePath(orgLine).substring(7, spaceIndex);
      } else if (line.startsWith("exit")) {
        exit = true;
      }
      
      if (line.startsWith("loadfix -") && !line.startsWith("loadfix -f")) {
        loadfix = true;
        int endIndex = line.indexOf(' ', 9);
        if (endIndex == -1)
          endIndex = line.length();
        try {
          this.loadfixValue = Integer.parseInt(line.substring(9, endIndex));
        } catch (NumberFormatException e) {
          this.loadfixValue = 0;
        }
      }
    }
    
    for (Mount mount: mountingpoints) {
      char mount_drive = mount.getDriveletter();
      String mountPath = mount.getHostPathAsString();
      if (Character.toUpperCase(driveletter) == mount_drive) {
      	main = FileUtils.sanitizeToDosroot(mountPath + remainder + File.separatorChar + executable);
      } else {
        if (Character.toUpperCase(imgdriveletter1) == mount_drive)
          img1 = FileUtils.sanitizeToDosroot(mountPath + image1);
        if (Character.toUpperCase(imgdriveletter2) == mount_drive)
          img2 = FileUtils.sanitizeToDosroot(mountPath + image2);
      } 
    }
  }

  private void init() {
    mountingpoints = new ArrayList<Mount>();
    loadfix = false;
    loadfixValue = 0;
    main = "";
    setup = "";
    img1 = "";
    img2 = "";
    exit = false;
    isBooter = false;
    mainParams = "";
    setupParams = "";
  }
  
  public String toString(boolean isSetup) {
    StringBuffer result = new StringBuffer();
    
    for (Mount mount: mountingpoints)
      result.append(mount.toString() + "\n");
    
    if (!main.equals("")) {
      
      String[] dosboxLocation = convertToDosboxPath(isSetup? setup: main);
      result.append(dosboxLocation[0] + "\n"); // move to drive
      result.append("cd \\" + dosboxLocation[1] + "\n"); // move to dir
      if (loadfix)
        result.append("loadfix -" + loadfixValue + "\n");
      if (dosboxLocation[2].toLowerCase().endsWith(FileUtils.EXECUTABLES[2]))
        result.append("call ");
      result.append(dosboxLocation[2]);
      
      if (isSetup && !setupParams.equals(""))
        result.append(" " + setupParams);
      else if (!isSetup && !mainParams.equals(""))
        result.append(" " + mainParams);
       
      if (loadfix)
        result.append("\nloadfix -f");
      if (exit)
        result.append("\nexit");

    } else if (!img1.equals("")) {

      if (loadfix)
        result.append("loadfix -" + loadfixValue + "\n");
      String[] dosboxLocation = convertToDosboxPath(img1);
      result.append("boot " + dosboxLocation[0] + "\\" + dosboxLocation[1]);
      if (!dosboxLocation[1].equals(""))
      	result.append("\\");
      result.append(dosboxLocation[2]);
      if (!img2.equals("")) {
        dosboxLocation = convertToDosboxPath(img2);
        result.append(" " + dosboxLocation[0] + "\\" + dosboxLocation[1]);
        if (!dosboxLocation[1].equals(""))
        	result.append("\\");
        result.append(dosboxLocation[2]);
      }
      if (loadfix)
        result.append("\nloadfix -f");
      if (exit)
        result.append("\nexit");

    } else {
    	
    	// a template
    	if (exit)
    		result.append("exit");

    }
    
    return result.toString();
  }
  
  private String[] convertToDosboxPath(String hostFileLocation) {
  	File hostFile = new File(hostFileLocation);
	  
  	String[] result = new String[3];
	  result[0] = "";
	  result[1] = "";
	  result[2] = hostFile.getName();

	  int maxLengthMount = 0;
	  for (Mount mount: mountingpoints) {
		  File dosboxDir = mount.canBeUsedFor(hostFile);
		  if (dosboxDir != null && (mount.getPathAsString().length() > maxLengthMount)) {
		  	result[0] = mount.getDriveletter() + ":";
		  	result[1] = (dosboxDir.getParent() != null)? dosboxDir.getParent(): "";
		  	maxLengthMount = mount.getPathAsString().length();
		  }
	  }
	  // translate *nix paths to dosbox paths
	  result[1] = PlatformUtils.toDosboxPath(result[1]);
	  return result;
  }

  public boolean isExit() {
    return exit;
  }

  public String getImg1() {
    return img1;
  }

  public String getImg2() {
    return img2;
  }

  public boolean isLoadfix() {
    return loadfix;
  }

  public String getLoadfixValue() {
    return loadfixValue > 0? String.valueOf(loadfixValue): "";
  }

  public String getMain() {
    return main;
  }

  public String[] getMountingpoints() {
    String[] result = new String[mountingpoints.size()];
    int i = 0;
    for (Mount mount: mountingpoints)
      result[i++] = mount.toString();
    return result;
  }

  public String getSetup() {
    return setup;
  }
  
  public void setSetup(String setup) {
    this.setup = setup;
  }
  
  public void setSetupParameters(String setupParams) {
    this.setupParams = setupParams;
  }
  
  public boolean isBooter() {
    return isBooter;
  }
  
  public String getMainParameters() {
    return mainParams;
  }

  public String getSetupParameters() {
    return setupParams;
  }
  
  public void makeRelative(File basePath) {
  	for (Mount mount: mountingpoints)
  		mount.makeRelative(basePath);
  	if (isBooter) {
  		img1 = FileUtils.makeRelativeTo(new File(img1), basePath).getPath();
  		img2 = FileUtils.makeRelativeTo(new File(img2), basePath).getPath();
  	} else {
  		main = FileUtils.makeRelativeTo(new File(main), basePath).getPath();
  		setup = FileUtils.makeRelativeTo(new File(setup), basePath).getPath();
  	}
  }
}
