package com.model;

import java.io.File;
import com.util.FileUtils;


public class DosboxVersion extends KeyTitleDefault  {

  private String path;
  private boolean multiConfig;
  private String parameters;
  
  
  public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean version,
  		String parameters) {
  	super(id, title, version);
    this.path = path;
    this.multiConfig = multiConfig;
    this.parameters = parameters;
  }

  public boolean isMultiConfig() {
    return multiConfig;
  }

  public String isMultiConfigString() {
    return multiConfig ? "Yes": "No";
  }

  public String getPath() {
    return path;
  }
  
  public File getCanonicalExecutable() {
  	return FileUtils.constructCanonicalDBExeLocation(path);
  }
  
  public File getCanonicalConfFile() {
  	return FileUtils.constructCanonicalDBConfLocation(path);
  }

  public String getParameters() {
  	return parameters;
  }
}
