package com.model;

import java.util.List;


public class KeyTitleDefault extends KeyValuePair {

	private boolean isDefault;


	public KeyTitleDefault(int id, String value, boolean isDefault) {
		super(id, value);
		this.isDefault = isDefault;
	}
	
	public String getTitle() {
    return getValue();
  }
	
	public boolean isDefault() {
		return isDefault;
	}
	
	public String isDefaultString() {
    return isDefault? "Yes": "No";
  }
	
	public void toggleDefault() {
		isDefault = !isDefault;
  }
	
	public static <T extends KeyTitleDefault> int findDefault(List<T> list) {
    int result = 0;
    for (T element: list) {
      if (element.isDefault) return result;
      result++;
    }
    return -1; // no default found
  }
}
