package com.model;

import java.util.List;


public class KeyValuePair {

  private int id;
  private String value;
  
  
  public KeyValuePair(int id, String value) {
    this.id = id;
    this.value = value;
  }

  public int getId() {
    return id;
  }

  public String getValue() {
    return value;
  }
  
  public static  int findIdByValue(List<KeyValuePair> list, String value) {
    for (KeyValuePair element: list)
      if (element.value.equals(value)) return element.id;
    return -1; // value not found
  }
  
  public static <T extends KeyValuePair> int findById(List<T> list, int id) {
    int result = 0;
    for (T element: list) {
      if (element.id == id) return result;
      result++;
    }
    return -1; // id not found
  }
}
