package com.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Profile;


public final class MigrateThread extends Thread {

	private String title;
	private File from;
	private int profileNumber;
	private StringBuffer messageLog;
	private Display display;
	private Text log;
	private ProgressBar progressBar;
	private Label profileLabel;
	private List<Profile> profilesList;
	
	
	public MigrateThread(File from, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
		this.from = from;
		this.log = log;
		this.progressBar = progressBar;
		this.profileLabel = profileLabel;
		this.display = log.getShell().getDisplay();
		this.profileNumber = 0;
		
		try {
			Database db = Database.getInstance();
			profilesList = db.readProfilesList("GAM.TITLE");
			this.progressBar.setMaximum(profilesList.size());
		} catch (SQLException e) {
			profilesList = new ArrayList<Profile>();
			GeneralPurposeDialogs.warningMessage(log.getShell(), e.getMessage());
		}
	}
	
	public void run() {
		Database db = Database.getInstance();
    
		try {
	    Iterator<Profile> it = profilesList.iterator();
	    while (it.hasNext()) {
	    	messageLog = new StringBuffer();
	    	
	    	Profile prof = it.next();
	    	title = prof.getTitle();
	    	
	    	try {

	    		File file = prof.getCanonicalConfFile();
					Configuration profileConf = new Configuration(file);
					
					Autoexec autoexec = new Autoexec(profileConf.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
					autoexec.makeRelative(from);

					profileConf.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(false));
					profileConf.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(prof.getId()));
					profileConf.saveToFile(file);
					
					String newConfigPath = prof.getConfPathAndFile(); 
					if (new File(prof.getConfPathAndFile()).isAbsolute()) {
						File f = FileUtils.makeRelativeTo(file, from);
						if (!f.isAbsolute())
							newConfigPath = FileUtils.DOSROOT_DIR + f.getPath();
					}

					db.updateProfileConf(newConfigPath, prof.getCaptures(), prof.getId());
					
					String setup = prof.getSetup();
					String[] links = prof.getLinks();
					if (!setup.equals(""))
						setup = FileUtils.makeRelativeTo(new File(setup), from).getPath();
					for (int i = 0; i < links.length; i++) {
						if (links[i].toLowerCase().startsWith("file://"))
							links[i] = links[i].substring(7);
						if (!links[i].equals("") && !links[i].contains("://")) {
							File f = FileUtils.makeRelativeTo(new File(links[i]), from);
							if (!f.isAbsolute())
								links[i] = FileUtils.DOSROOT_DIR + f.getPath();
						}
					}
					db.updateProfileSetupAndLinks(setup, links, prof.getId());
					
				} catch (IOException e) {
					messageLog.append(e.getMessage() + "\n");
				}
	    	
	      if (display.isDisposed() || log.isDisposed() || progressBar.isDisposed()) break;
				display.asyncExec(new Runnable() {
					public void run() {
						profileLabel.setText("Migrating " + title + "...");
						profileLabel.pack();
						log.append(messageLog.toString());
						progressBar.setSelection(profileNumber++);
					}
				});
	    }
		} catch (Exception se) { //catch (SQLException se) {
			messageLog.append(se.getMessage());
			display.asyncExec(new Runnable() {
				public void run() {
					log.append(messageLog.toString());
				}
			});
		}
	}
}
