package com.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.jimmc.jshortcut.JShellLink;
import org.eclipse.swt.program.Program;
import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Settings;


public final class PlatformUtils {

	public static final String OS_NAME = System.getProperty("os.name");
	public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
	public static final boolean IS_LINUX = OS_NAME.startsWith("Linux");
	public static final boolean IS_OSX = OS_NAME.startsWith("Mac OS");
	public static final String DB_EXECUTABLE = IS_WINDOWS? "DOSBox.exe": "dosbox";
	
	
	public static String toNativePath(String dosboxFileLocation) {
			return dosboxFileLocation.replace('\\', File.separatorChar);
  }
	
	public static String toDosboxPath(String hostFileLocation) {
			return hostFileLocation.replace(File.separatorChar, '\\');
  }
	
	public static String archiveToNativePath(String archiveEntry) {
			// 7zip uses / as file seperator but to be safe in the future
			// both \\ and / are converted to the host seperator
			return archiveEntry.replace('/', File.separatorChar).replace('\\', File.separatorChar);
	}
	
	public static void openForEditing(File file) {
		Program        p = Program.findProgram(".conf");
		if (p == null) p = Program.findProgram(".txt");
		if (p == null) p = Program.findProgram(".inf");
		if (p == null) p = Program.findProgram(".ini");
		if (p == null) p = Program.findProgram(".cfg");
		if (p == null) p = Program.findProgram(".java");
    if (p == null) p = Program.findProgram(".doc");
    if (p != null)
    	p.execute(file.getPath());
    else
    	System.err.println("Cannot open \"" + file + "\"");
	}
	
	public static void openForBrowsing(String url) {
		Program p = Program.findProgram(".html");
    if (p != null)
    	p.execute (url);
    else
    	System.err.println("Cannot open \"" + url + "\"");
	}
	
	public static void openDirForViewing(File file) {
  	try {
  		if (IS_WINDOWS) {
  			Runtime.getRuntime().exec(new String[]{"explorer", file.getPath()}, null, null);
  		} else if (IS_LINUX) {
  			try {
  				Runtime.getRuntime().exec(new String[]{"nautilus", file.getPath()}, null, null);
  			} catch (IOException e) {
  				Runtime.getRuntime().exec(new String[]{"kfmclient", file.getPath()}, null, null);
  			}
  		} else if (IS_OSX) {
  			Runtime.getRuntime().exec(new String[]{"open", file.getPath()}, null, null);
		}
		} catch (IOException e) {
			System.err.println("Cannot open \"" + file + "\"");
		}
	}
	
	public static void createShortcut(Profile profile, List<DosboxVersion> dbversionsList) {
		int dbversionIndex = DosboxVersion.findById(dbversionsList, profile.getDbversionId());
    DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
    String params = "";
    if (dbversion.isMultiConfig())
    	params += "-conf \"" + dbversion.getCanonicalConfFile() + "\" "; 
    params += "-conf \"" + profile.getCanonicalConfFile() + "\"";
    if (Settings.getInstance().getBooleanValue("dosbox", "hideconsole")) {
  		params += " -noconsole";
  	}
    JShellLink link = new JShellLink();
    link.setFolder(JShellLink.getDirectory("desktop"));
    link.setName(profile.getTitle().replaceAll("[:?*]", " "));
    link.setPath(dbversion.getCanonicalExecutable().getPath());
    link.setArguments(params);
    link.setDescription("Run " + profile.getTitle() + " in DOSBox");
    link.setWorkingDirectory(FileUtils.getDosRoot());
    link.save();
	}
}
