package com.util;


public final class StringUtils {

  public static String[] textAreaToStringArray(String contents, String del) {
  	while (contents.startsWith(del))
  		contents = contents.substring(del.length());
  	while (contents.endsWith(del))
  		contents = contents.substring(0, contents.length() - del.length());
  	if (contents.length() <= 0)
  		return new String[0];
  	return contents.split(del);
  }
  
  public static String[] mountToStringArray(String paths) {
  	if (paths.length() <= 0)
  		return new String[0];
  	return paths.split("\" \"");
  }
  
  public static String intArrayToString(int[] list) {
	  StringBuffer result = new StringBuffer();
	  for (int value: list)
		  result.append(value + " ");
	  return result.toString();
  }
  
  public static String booleanArrayToString(boolean[] list) {
	  StringBuffer result = new StringBuffer();
	  for (boolean value: list)
		  result.append(value + " ");
	  return result.toString();
  }
  
  public static String StringArrayToString(String[] list) {
	  StringBuffer result = new StringBuffer();
	  for (String value: list)
		  result.append(value + "\n");
	  return result.toString();
  }
  
  public static int[] stringToIntArray(String input) {
  	if (input.length() <= 0)
  		return new int[0];
	  String[] values = input.split(" ");
	  int[] result = new int[values.length];
	  for (int i = 0; i < values.length; i++)
		  try {
			  result[i] = Integer.parseInt(values[i]);
		  } catch (NumberFormatException e) {
			  result[i] = -1;
		  }
	  return result;
  }
  
  public static boolean[] stringToBooleanArray(String input) {
  	if (input.length() <= 0)
  		return new boolean[0];
	  String[] values = input.split(" ");
	  boolean[] result = new boolean[values.length];
	  for (int i = 0; i < values.length; i++)
	  	result[i] = Boolean.parseBoolean(values[i]);
	  return result;
  }
  
  public static int countCharacters(String s, char c) {
  	int result = 0;
  	for (int i = 0; i < s.length(); i++)
  		if (s.charAt(i) == c) result++;
  	return result;
  }
}
