package com.gui;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.util.FileUtils;
import com.util.StringUtils;


public final class BrowseButton {

	public static final String DFEND_PATH = "C:\\Program Files\\D-Fend\\";
	public static final String DFEND_PROFILES = "Profiles.dat";
	
	public enum BrowseType { DIR, FILE };
	public enum CanonicalType { DOSROOT, DFEND, CDIMAGE, ZIP, DOSBOX, DOC, BOOTER, EXE, NONE };
	
	private Button button;
	
	
	private class Sa extends SelectionAdapter {
		
		private Text field;
		private Text alt;
		private BrowseType browse;
		private CanonicalType canon;
		private Combo combo;
		private Shell shell;
		
		
		public Sa(Shell s, Text control, Text altControl, BrowseType bt, CanonicalType ct, Combo c) {
			shell = s;
			field = control;
			alt = altControl;
			browse = bt;
			canon = ct;
			combo = c;
		}
		
		private String filterPath() {
			String path = field.getText();
			CanonicalType fileType = canon;
			if (path.equals("") && (alt != null)) {
				path = alt.getText();
				fileType = CanonicalType.DOSROOT;
			}
			switch (fileType) {
			case DOC:			return FileUtils.canonicalToData(path).getPath();
			case EXE:	case ZIP:	case BOOTER: case DOSROOT:
										return FileUtils.canonicalToDosroot(path).getPath();
			case DOSBOX:	return FileUtils.canonicalToDosbox(path).getPath();
			case DFEND:		return DFEND_PATH;
			case CDIMAGE:	String[] fPaths = StringUtils.textAreaToStringArray(field.getText(), field.getLineDelimiter());
										if (fPaths.length > 0)
											return fPaths[0];
			default:			return "";
			}
		}
		
		private String getResult(String result, File fp, String[] filenames) {
			switch (canon) {
			case DOC:			return FileUtils.makeRelativeToData(new File(result)).getPath();
			case EXE:			if (FileUtils.isArchive(result)) {
							      	BrowseArchiveDialog dialog = new BrowseArchiveDialog(shell, SWT.OPEN);
							      	dialog.setArchive(result);
							      	return (String) dialog.open();
							      }
			case ZIP: case BOOTER: case DOSROOT:
										return FileUtils.makeRelativeToDosroot(new File(result)).getPath();
			case DOSBOX:	return FileUtils.makeRelativeToDosbox(new File(result)).getPath();
			case CDIMAGE: File path = FileUtils.makeRelativeToDosroot(fp);
										String images = "";
										for (String file: filenames)
											images += new File(path, file) + "\n";
										return images;
			default:			return result;
			}
		}
		
    public void widgetSelected(final SelectionEvent e) {
    	String result = null;
    	File fp = null;
    	String[] filenames = null;
    	
    	if (browse == BrowseType.DIR) {
    		DirectoryDialog dialog = new DirectoryDialog (shell);
    		dialog.setFilterPath(filterPath());
        result = dialog.open();
    	} else if (browse == BrowseType.FILE && (canon == CanonicalType.EXE) && FileUtils.isArchive(filterPath())) {
    		result = filterPath();
    	} else if (browse == BrowseType.FILE) {
    		int style = (canon == CanonicalType.CDIMAGE)? SWT.OPEN | SWT.MULTI: SWT.OPEN;
    		FileDialog dialog = new FileDialog (shell, style);
    		
    		String[] fn = null;
    		String[] fe = null;
    		switch (canon) {
    		case DOC: 		fn = new String [] {FileUtils.ALL_FILTER};
											fe = new String [] {FileUtils.ALL_FILTER};
											break;
    		case EXE:			String defaultFilterTitle = "Executables";
							  			String defaultFilter = FileUtils.EXE_FILTER;
							  			if (combo.isEnabled()) { // check to see if this dbversion support physfs (Gulikoza/Ykhwong)
							  				defaultFilterTitle += ", (7-)Zip files";
							  				defaultFilter += ";" + FileUtils.ARC_FILTER;
							  			}
							  			fn = new String [] {defaultFilterTitle, "CD Images", "(7-)Zip files"};
							  			fe = new String [] {defaultFilter, FileUtils.CDI_FILTER, FileUtils.ARC_FILTER};
											break;
				case ZIP: 		fn = new String [] {"(7-)Zip files", FileUtils.ALL_FILTER};
        							fe = new String [] {FileUtils.ARC_FILTER, FileUtils.ALL_FILTER};
        							break;
    		case BOOTER: 	fn = new String [] {"Booter Disk Images", FileUtils.ALL_FILTER};
    									fe = new String [] {FileUtils.BTR_FILTER, FileUtils.ALL_FILTER};
    									break;
    		case DFEND:		fn = new String [] {"D-Fend Profiles"};
											fe = new String [] {DFEND_PROFILES};
											break;
    		case CDIMAGE:	fn = new String [] {"CD Images", FileUtils.ALL_FILTER};
    									fe = new String [] {FileUtils.CDI_FILTER, FileUtils.ALL_FILTER};
    									break;
				default:
    		}
    		if (fn != null)	dialog.setFilterNames(fn);
    		if (fe != null)	dialog.setFilterExtensions(fe);

    		if (canon == CanonicalType.DFEND)
			    dialog.setFileName(DFEND_PROFILES);

    		dialog.setFilterPath(filterPath());
    		
        result = dialog.open();
        if (canon == CanonicalType.CDIMAGE) {
        	fp = new File(dialog.getFilterPath());
        	filenames = dialog.getFileNames();
        }
    	}
      if (result != null) {
      	result = getResult(result, fp, filenames);
        if (result != null) field.setText(result);
      }
    }
  }
	
	public BrowseButton(Composite composite, int style) {
		button = new Button(composite, style);
		button.setText("Browse..");
	}
	
	public void connect(final Shell shell, Text control, Text altControl, BrowseType bt, CanonicalType ct, Combo combo) {
		button.addSelectionListener(new Sa(shell, control, altControl, bt, ct, combo));
	}
	
	public void setLayoutData(Object arg0) {
		button.setLayoutData(arg0);
	}
	
	public void setEnabled(boolean enabled) {
		button.setEnabled(enabled);
	}
}
