package com.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import com.util.StringUtils;


public final class GeneralPurposeDialogs {

  private static List<String> errorMessages;
  private static Control wgt;
  private static TabItem tab;

  
  public static void fatalMessage(Shell shell, String theMessage) {
    MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_ERROR | SWT.OK);
    messageBox.setText("Fatal error");
    messageBox.setMessage(theMessage);
    messageBox.open();
  }

  public static void warningMessage(Shell shell, String theMessage) {
    MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_WARNING | SWT.OK);
    messageBox.setText("Warning");
    messageBox.setMessage(theMessage);
    messageBox.open();
  }
  
  public static void infoMessage(Shell shell, String theMessage) {
    MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_INFORMATION | SWT.OK);
    messageBox.setText("Information");
    messageBox.setMessage(theMessage);
    messageBox.open();
  }
  
  public static boolean confirmMessage(Shell shell, String theMessage) {
	  MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_WARNING | SWT.YES | SWT.NO);
	  messageBox.setText("Information");
	  messageBox.setMessage(theMessage);
	  return messageBox.open() == SWT.YES;
  }
  
  public static void initErrorDialog() {
    errorMessages = new ArrayList<String>();
    wgt = null;
    tab = null;
  }
  
  public static void addError(String msg, Control widget) {
    addError(msg, widget, null);
  }
  
  public static void addError(String msg, Control widget, TabItem tabItem) {
    if (errorMessages.isEmpty()) {
      wgt = widget;
      tab = tabItem;
    }
    errorMessages.add(msg);
  }
  
  public static boolean displayErrorDialog(Shell shell) {
    boolean errors = !errorMessages.isEmpty();
    if (errors) {
      if (tab != null) {
      	TabFolder folder = tab.getParent();
        folder.setSelection(tab);
      }
      infoMessage(shell, StringUtils.StringArrayToString(errorMessages.toArray(new String[0])));
      wgt.setFocus();
    }
    return errors;
  }
}
