package com.gui;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.gui.BrowseButton.BrowseType;
import com.gui.BrowseButton.CanonicalType;
import com.util.FileUtils;
import com.util.MigrateThread;


public final class MigrateDialog extends Dialog {

	private Text to;
	private Text from;
	private Text logText;
	private MigrateThread migrateThread;
	private Button cancelButton;
	private Label profileLabel;
	private String result = null;
	protected Shell shell;


	public MigrateDialog(Shell parent, int style) {
		super(parent, style);
	}

	public MigrateDialog(Shell parent) {
		this(parent, SWT.NONE);
	}

	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (migrateThread != null && !migrateThread.isAlive() && !cancelButton.getText().equals("Close")) {
				GeneralPurposeDialogs.infoMessage(shell, "Migration completed successfully.");
				profileLabel.setText("Please review the log below for possible problems");
				profileLabel.pack();
				cancelButton.setText("Close");
			}	
			if (!display.readAndDispatch())
				display.sleep();
		}
		return result;
	}

	protected void createContents() {
		shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setLayout(new GridLayout());
		shell.setSize(500, 375);
		shell.setText("Migrate Profiles");

		final Group optionsGroup = new Group(shell, SWT.NONE);
		optionsGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		optionsGroup.setText("Options");
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		optionsGroup.setLayout(gridLayout);

		final Label fromLocationLabel = new Label(optionsGroup, SWT.NONE);
		fromLocationLabel.setText("From");

		from = new Text(optionsGroup, SWT.BORDER);
		from.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		
		final BrowseButton fromBrowseButton = new BrowseButton(optionsGroup, SWT.NONE);
    fromBrowseButton.connect(shell, from, null, BrowseType.DIR, CanonicalType.NONE, null);

		final Label toLabel = new Label(optionsGroup, SWT.NONE);
		toLabel.setText("To");

		to = new Text(optionsGroup, SWT.READ_ONLY | SWT.BORDER);
		to.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		to.setText(FileUtils.getDosRoot());
		new Label(optionsGroup, SWT.NONE);

		final Button startMigrateButton = new Button(optionsGroup, SWT.NONE);
		shell.setDefaultButton(startMigrateButton);
		startMigrateButton.setLayoutData(new GridData(110, SWT.DEFAULT));
		startMigrateButton.setText("Start Migration");

		cancelButton = new Button(optionsGroup, SWT.NONE);
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				shell.close();
			}
		});
		cancelButton.setLayoutData(new GridData(80, SWT.DEFAULT));
		cancelButton.setText("Cancel");
		new Label(optionsGroup, SWT.NONE);

		final Group progressGroup = new Group(shell, SWT.NONE);
		progressGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		progressGroup.setText("Progress");
		progressGroup.setLayout(new GridLayout());

		final ProgressBar progressBar = new ProgressBar(progressGroup, SWT.NONE);
		progressBar.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

		profileLabel = new Label(progressGroup, SWT.NONE);

		logText = new Text(progressGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.H_SCROLL);
		logText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		startMigrateButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				if (!isValid())
          return;
				try {
					migrateThread = new MigrateThread(new File(from.getText()), logText, progressBar, profileLabel);
					from.setEnabled(false);
					result = from.getText();
					fromBrowseButton.setEnabled(false);
					startMigrateButton.setEnabled(false);
					migrateThread.start();
				} catch (IOException ex) {
					GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
					migrateThread = null;
				}
			}
		});
	}

	private boolean isValid() {
		GeneralPurposeDialogs.initErrorDialog();
    if (from.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a from location", from);
		return !GeneralPurposeDialogs.displayErrorDialog(shell);
	}
}
