package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import com.model.Configuration;
import com.model.Settings;
import swing2swt.layout.BorderLayout;


public class SettingsDialog extends Dialog {

	private Table visible_columns;

	private static final int EDITABLE_COLUMN = 0;
	
	public final static String[] confLocations = {"In DBGL profiles subdirectory", "In game directory"};
	public final static String[] confFilenames = {"Filename by unique ID", "Filename by profile title"};

	boolean changedVisColumns = false;
	private TableItem[] visibleColumns;
	private TabItem columnsTabItem;
	private Combo confFilename;
	private Combo confLocation;
	private Text port;
    private Label heightValue;
    private Label heightLabel;
    private Scale screenshotsHeight;
    private Group screenshots;
    private Composite composite1;
	private int previousSelection = -1;
	private Text values;
	private Configuration conf;
	private List options;
	protected Object result;

	protected Shell shell;

	/**
	 * Create the dialog
	 * @param parent
	 * @param style
	 */
	public SettingsDialog(Shell parent, int style) {
		super(parent, style);
	}

	/**
	 * Create the dialog
	 * @param parent
	 */
	public SettingsDialog(Shell parent) {
		this(parent, SWT.NONE);
	}

	/**
	 * Open the dialog
	 * @return the result
	 */
	public Object open() {
		conf = new Configuration(Settings.getInstance());
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		result = new Boolean(changedVisColumns);
		return result;
	}

	/**
	 * Create contents of the dialog
	 */
	protected void createContents() {
		shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
		shell.setLayout(new BorderLayout(0, 0));
		shell.setSize(600, 375);
		shell.setText("Settings");

		final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

		final TabItem generalTabItem = new TabItem(tabFolder, SWT.NONE);
		generalTabItem.setText("General");

		final Composite composite = new Composite(tabFolder, SWT.NONE);
		composite.setLayout(new GridLayout());
		generalTabItem.setControl(composite);

		final Group dosboxGroup = new Group(composite, SWT.NONE);
		dosboxGroup.setText("DOSBox");
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		dosboxGroup.setLayout(gridLayout);

		final Label showConsoleLabel = new Label(dosboxGroup, SWT.NONE);
		showConsoleLabel.setText("Hide DOSBox Status Window");

		final Button console = new Button(dosboxGroup, SWT.CHECK);
		console.setSelection(conf.getBooleanValue("dosbox", "hideconsole"));

		final Group sendToGroup = new Group(composite, SWT.NONE);
		sendToGroup.setText("Send To (Requires restart)");
		final GridLayout gridLayout_2 = new GridLayout();
		gridLayout_2.numColumns = 2;
		sendToGroup.setLayout(gridLayout_2);

		final Label enableCommunicationLabel = new Label(sendToGroup, SWT.NONE);
		enableCommunicationLabel.setText("Enable communication port");

		final Button portEnabled = new Button(sendToGroup, SWT.CHECK);
		portEnabled.setSelection(conf.getBooleanValue("communication", "port_enabled"));
		portEnabled.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				port.setEnabled(portEnabled.getSelection());
			}
		});

		final Label portnumberLabel = new Label(sendToGroup, SWT.NONE);
		portnumberLabel.setText("Port");

		port = new Text(sendToGroup, SWT.BORDER);
		port.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		port.setText(conf.getValue("communication", "port"));
		port.setEnabled(portEnabled.getSelection());

		final Group profileDefaultsGroup = new Group(composite, SWT.NONE);
		profileDefaultsGroup.setText("Profile defaults");
		final GridLayout gridLayout_3 = new GridLayout();
		gridLayout_3.numColumns = 3;
		profileDefaultsGroup.setLayout(gridLayout_3);

		final Label configurationFileLabel = new Label(profileDefaultsGroup, SWT.NONE);
		configurationFileLabel.setText("Configuration file");

		confLocation = new Combo(profileDefaultsGroup, SWT.READ_ONLY);
		confLocation.setItems(confLocations);
		confLocation.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		confLocation.select(conf.getIntValue("profiledefaults", "confpath"));

		confFilename = new Combo(profileDefaultsGroup, SWT.READ_ONLY);
		confFilename.setItems(confFilenames);
		confFilename.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		confFilename.select(conf.getIntValue("profiledefaults", "conffile"));

		columnsTabItem = new TabItem(tabFolder, SWT.NONE);
		columnsTabItem.setText("Profile Table");

		final Composite composite2 = new Composite(tabFolder, SWT.NONE);
		composite2.setLayout(new BorderLayout(0, 0));
		columnsTabItem.setControl(composite2);
		
		final Group visibleColumnsGroup = new Group(composite2, SWT.NONE);
		visibleColumnsGroup.setLayout(new FillLayout());
		visibleColumnsGroup.setText("Visible columns");

		visible_columns = new Table(visibleColumnsGroup, SWT.FULL_SELECTION | SWT.BORDER | SWT.CHECK);
		visible_columns.setLinesVisible(true);
		
		TableColumn column1 = new TableColumn(visible_columns, SWT.NONE);
		column1.setWidth(350);
		
		visibleColumns = new TableItem[MainWindow.COLUMNNAMES.length];
		
		for (int i = 0; i < MainWindow.COLUMNNAMES.length; i++) {
			visibleColumns[i] = new TableItem(visible_columns, SWT.BORDER);
			visibleColumns[i].setText(MainWindow.COLUMNNAMES[i]);
			visibleColumns[i].setChecked(conf.getBooleanValue("gui", "column" + (i + 1) + "visible"));
		}
		
		final TableEditor editor = new TableEditor(visible_columns);
		editor.horizontalAlignment = SWT.LEFT;
		editor.grabHorizontal = true;
		editor.minimumWidth = 50;
		
		
		visible_columns.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				// Clean up any previous editor control
				Control oldEditor = editor.getEditor();
				if (oldEditor != null) oldEditor.dispose();
		
				// Identify the selected row
				TableItem item = (TableItem)e.item;
				if (item == null) return;
				if (item.getParent().getSelectionIndex() < MainWindow.NON_EDITABLE_COLUMN_NAMES) return;
		
				// The control that will be the editor must be a child of the Table
				Text newEditor = new Text(visible_columns, SWT.NONE);
				newEditor.setText(item.getText(EDITABLE_COLUMN));
				newEditor.addModifyListener(new ModifyListener() {
					public void modifyText(ModifyEvent me) {
						Text text = (Text)editor.getEditor();
						editor.getItem().setText(EDITABLE_COLUMN, text.getText());
					}
				});
				newEditor.selectAll();
				newEditor.setFocus();
				editor.setEditor(newEditor, item, EDITABLE_COLUMN);
			}
		});
		
		
		final Group addeditduplicateProfileGroup = new Group(composite2, SWT.NONE);
		final GridLayout gridLayout_4 = new GridLayout();
		gridLayout_4.numColumns = 2;
		addeditduplicateProfileGroup.setLayout(gridLayout_4);
		addeditduplicateProfileGroup.setText("Add/Edit/Duplicate Profile");
		addeditduplicateProfileGroup.setLayoutData(BorderLayout.SOUTH);

		final Label autoSortAfterwardsLabel = new Label(addeditduplicateProfileGroup, SWT.NONE);
		autoSortAfterwardsLabel.setText("Auto Sort after change");

		final Button autosort = new Button(addeditduplicateProfileGroup, SWT.CHECK);
		autosort.setSelection(conf.getBooleanValue("gui", "autosortonupdate"));

		final TabItem dynamicOptionsTabItem = new TabItem(tabFolder, SWT.NONE);
		dynamicOptionsTabItem.setText("Dynamic options");

		final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
		composite_1.setLayout(new FillLayout());
		dynamicOptionsTabItem.setControl(composite_1);

		final Group dynamicOptionsGroup = new Group(composite_1, SWT.NONE);
		final GridLayout gridLayout_1 = new GridLayout();
		gridLayout_1.numColumns = 2;
		dynamicOptionsGroup.setLayout(gridLayout_1);
		dynamicOptionsGroup.setText("Dynamic options");

		final Label optionsLabel = new Label(dynamicOptionsGroup, SWT.NONE);
		optionsLabel.setText("Options");

		final Label valuesLabel = new Label(dynamicOptionsGroup, SWT.NONE);
		valuesLabel.setText("Values");

		options = new List(dynamicOptionsGroup, SWT.V_SCROLL | SWT.BORDER);
		options.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				storeValues();
				previousSelection = options.getSelectionIndex();
				values.setText(conf.getMultilineValues("profile", options.getItem(previousSelection)));
			}
		});
		options.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		for (String s: conf.getItems("profile"))
			options.add(s);

		values = new Text(dynamicOptionsGroup, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL);
		values.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		final Composite composite_7 = new Composite(shell, SWT.NONE);
		composite_7.setLayout(new RowLayout());
		composite_7.setLayoutData(BorderLayout.SOUTH);

		final TabItem guiTabItem = new TabItem(tabFolder, SWT.NONE);
        guiTabItem.setText("GUI options");
        {
            composite1 = new Composite(tabFolder, SWT.NONE);
            GridLayout composite1Layout = new GridLayout();
            composite1Layout.makeColumnsEqualWidth = true;
            composite1.setLayout(composite1Layout);
            guiTabItem.setControl(composite1);
            {
                screenshots = new Group(composite1, SWT.NONE);
                GridLayout screenshotsLayout = new GridLayout();
                screenshotsLayout.numColumns = 3;
                screenshots.setLayout(screenshotsLayout);
                GridData screenshotsLData = new GridData();
                screenshotsLData.grabExcessHorizontalSpace = true;
                screenshotsLData.horizontalAlignment = GridData.FILL;
                screenshots.setLayoutData(screenshotsLData);
                screenshots.setText("Screenshots (Requires restart)");
                {
                    heightLabel = new Label(screenshots, SWT.NONE);
                    heightLabel.setText("Height");
                }
                {
                    screenshotsHeight = new Scale(screenshots, SWT.NONE);
                    screenshotsHeight.setMaximum(750);
                    screenshotsHeight.setMinimum(50);
                    GridData screenshotsHeightLData = new GridData();
                    screenshotsHeightLData.grabExcessHorizontalSpace = true;
                    screenshotsHeightLData.horizontalAlignment = GridData.FILL;
                    screenshotsHeight.setLayoutData(screenshotsHeightLData);
                    screenshotsHeight.setIncrement(25);
                    screenshotsHeight.setPageIncrement(100);
                    screenshotsHeight.setSelection(conf.getIntValue("gui", "screenshotsheight"));
                    screenshotsHeight.addSelectionListener(new SelectionAdapter() {
                        public void widgetSelected(SelectionEvent evt) {
                            heightValue.setText(String.valueOf(screenshotsHeight.getSelection()) + "px");
                            heightValue.pack();
                        }
                    });
                }
                {
                    heightValue = new Label(screenshots, SWT.NONE);
                    heightValue.setText(String.valueOf(screenshotsHeight.getSelection()) + "px");
                }
            }
        }

		final Button okButton = new Button(composite_7, SWT.NONE);
		okButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				if (!isValid())
				    return;
				
				for (int i = 0; i < MainWindow.COLUMNNAMES.length; i++)
					if (conf.getBooleanValue("gui", "column" + (i + 1) + "visible") != visibleColumns[i].getChecked())
						changedVisColumns = true;
				for (int i = 0; i < MainWindow.EDITABLE_COLUMN_NAMES; i++)
					if (!MainWindow.COLUMNNAMES[i + MainWindow.NON_EDITABLE_COLUMN_NAMES].equals(
							visibleColumns[i + MainWindow.NON_EDITABLE_COLUMN_NAMES].getText()))
						changedVisColumns = true;
				if (changedVisColumns)
					resetColumnSettings();
				
				conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
				conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
				conf.setValue("communication", "port", port.getText());
				conf.setIntValue("profiledefaults", "confpath", confLocation.getSelectionIndex());
				conf.setIntValue("profiledefaults", "conffile", confFilename.getSelectionIndex());
				for (int i = 0; i < MainWindow.COLUMNNAMES.length; i++)
					conf.setBooleanValue("gui", "column" + (i + 1) + "visible", visibleColumns[i].getChecked());
				conf.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
				for (int i = 0; i < MainWindow.EDITABLE_COLUMN_NAMES; i++)
					conf.setValue("gui", "custom" + (i + 1), visibleColumns[i + MainWindow.NON_EDITABLE_COLUMN_NAMES].getText());
				conf.setIntValue("gui", "screenshotsheight", screenshotsHeight.getSelection());
				
				storeValues();
				Settings settings = Settings.getInstance();
				settings.updateWithValuesFrom(conf);
				shell.close();
			}
		});
		shell.setDefaultButton(okButton);
		final RowData rowData = new RowData();
		rowData.width = 80;
		okButton.setLayoutData(rowData);
		okButton.setText("OK");

		final Button cancelButton = new Button(composite_7, SWT.NONE);
		final RowData rowData_1 = new RowData();
		rowData_1.width = 80;
		cancelButton.setLayoutData(rowData_1);
		cancelButton.setText("Cancel");
		cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        shell.close();
      }
    });
	}
	
	private void storeValues() {
		if (previousSelection != -1)
			conf.setMultilineValues("profile", options.getItem(previousSelection), values.getText(), values.getLineDelimiter());
	}
	
	private int countVisibleColumns() {
		int result = 0;
		for (int i = 0; i < MainWindow.COLUMNNAMES.length; i++)
			if (visibleColumns[i].getChecked()) result++;
		return result;
	}
	
	private int getFirstVisibleColumn() {
		for (int i = 0; i < MainWindow.COLUMNNAMES.length; i++)
			if (visibleColumns[i].getChecked()) return i;
		return -1;
	}
	
	private void resetColumnSettings() {
		conf.setIntValue("gui", "sortcolumn", getFirstVisibleColumn());
		conf.setBooleanValue("gui", "sortascending", true);
		StringBuffer s = new StringBuffer();
		for (int i = 0; i < countVisibleColumns(); i++)
			s.append(i + " ");
		conf.setValue("gui", "columnorder", s.toString().trim());
	}
	
	private boolean isValid() {
		GeneralPurposeDialogs.initErrorDialog();
		if (countVisibleColumns() == 0) {
			GeneralPurposeDialogs.addError("You must select at least 1 column to be visible",
					visible_columns, columnsTabItem);
		}
		return !GeneralPurposeDialogs.displayErrorDialog(shell);
	}
}
