package com.model;

import java.io.File;
import java.util.List;
import com.util.FileUtils;


public class DosboxVersion extends KeyTitleDefault implements Comparable<DosboxVersion> {

    public final static String[] SUPPORTED_RELEASES = { "0.63", "0.65", "0.70", "0.71", "0.72" }; 

    private String path;
    private boolean multiConfig;
    private String parameters;
    private String version;


    public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean isDefault, String parameters,
            String version) {
        super(id, title, isDefault);
        this.path = path;
        this.multiConfig = multiConfig;
        this.parameters = parameters;
        this.version = version;
    }

    public boolean isMultiConfig() {
        return multiConfig;
    }

    public String isMultiConfigString() {
        return multiConfig ? "Yes" : "No";
    }

    public String getPath() {
        return path;
    }

    public File getCanonicalExecutable() {
        return FileUtils.constructCanonicalDBExeLocation(path);
    }

    public File getCanonicalConfFile() {
        return FileUtils.constructCanonicalDBConfLocation(path);
    }

    public String getParameters() {
        return parameters;
    }

    public String getVersion() {
        return version;
    }

    public int findBestMatchId(List<DosboxVersion> dbversionsList) {
        for (DosboxVersion dbv: dbversionsList)
            if (distance(dbv) == 0 && getTitle().equals(dbv.getTitle()))
                return dbv.getId();

        DosboxVersion theDefault = dbversionsList.get(DosboxVersion.findDefault(dbversionsList));
        if (distance(theDefault) == 0) return theDefault.getId();

        int result = dbversionsList.get(1).getId();
        int distance = distance(dbversionsList.get(1));
        for (DosboxVersion dbv: dbversionsList) {
            if (distance(dbv) < distance) {
                result = dbv.getId();
                distance = distance(dbv);
            }
        }
        return result;
    }

    private int getVersionInt() {
        return Integer.valueOf(version.substring(2));
    }

    private int distance(DosboxVersion ver) {
        return Math.abs(ver.getVersionInt() - getVersionInt());
    }

    public int compareTo(DosboxVersion arg0) {
        DosboxVersion comp = (DosboxVersion) arg0;
        int v1 = this.getVersionInt();
        int v2 = comp.getVersionInt();
        if (v1 != v2) return (v1 - v2);
        return this.getTitle().compareTo(comp.getTitle());
    }
}
