package com.swtdesigner;

import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;


public final class SWTImageManager {

    private static final HashMap<String, Image> imageMap = new HashMap<String, Image>();


    public static void dispose() {
        for (Image image: imageMap.values())
            image.dispose();
        imageMap.clear();
    }

    public static Image getImage(Display display, String path) {
        try {
            return new Image(display, path);
        } catch (Exception e) {
            Image image = new Image(display, 10, 10);
            GC gc = new GC(image);
            gc.setBackground(display.getSystemColor(SWT.COLOR_RED));
            gc.fillRectangle(0, 0, 10, 10);
            gc.dispose();
            return image;
        }
    }

    public static Image getResizedImage(Display display, int height, String path) {
        Image image = imageMap.get(path);
        if (image == null) {
            Image orgImage = getImage(display, path);
            int w = orgImage.getBounds().width;
            int h = orgImage.getBounds().height;
            double factor = (double) height / (double) h;
            int wf = (int) (w * factor);
            image = new Image(display, wf, height);
            GC gc = new GC(image);
            gc.setAntialias(SWT.ON);
            gc.drawImage(orgImage, 0, 0, w, h, 0, 0, wf, height);
            gc.dispose();
            imageMap.put(path, image);
        }
        return image;
    }
}