package com.connect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import com.gui.MainWindow;


public final class Messaging extends Thread {

	private transient final int port;
	private transient final Object obj;
	private transient ServerSocket server = null;
	private transient boolean cont = true;
	
	
	public Messaging(final int port, final Object obj) {
		this.port = port;
		this.obj = obj;
	}
	
	public void close() {
		cont = false;
		try {
			server.close();
		} catch (IOException e) {
			System.err.println("Could not close socket");
		}
	}
	
	public void run() {
		try {
			server = new ServerSocket(port);
			System.out.println("Accepting messages on port " + port);
		} catch (IOException e) {
			System.err.println("Could not create socket on port " + port);
		}
		
		while (cont) {
			try {
				
				Socket client = server.accept();
				BufferedReader bufferedIStream = new BufferedReader(new InputStreamReader(client.getInputStream()));
				System.out.print("Receiving message... ");
				String line = bufferedIStream.readLine();
				System.out.println(line);
				client.close();
				if (line.startsWith("sendtoprofile ")) {
					((MainWindow)obj).addProfile(line.substring(14));
				}
			} catch (IOException e) {
				if (cont) {
					System.err.println("Socket communication failure");
				}
			}
		}
	}
}
