package com.gui;

import java.io.File;
import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import swing2swt.layout.BorderLayout;
import com.db.Database;
import com.gui.BrowseButton.BrowseType;
import com.gui.BrowseButton.CanonicalType;
import com.model.DosboxVersion;
import com.model.KeyValuePair;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.model.conf.CompositeConfiguration;
import com.model.conf.Configuration;
import com.util.FileUtils;


public class EditProfileDialog extends EditTemplateDialog {

    private boolean focusOnTitle = false;
    
    private java.util.List<KeyValuePair> developersList;
    private java.util.List<KeyValuePair> publishersList;
    private java.util.List<KeyValuePair> genresList;
    private java.util.List<KeyValuePair> yearsList;
    private java.util.List<Template> templatesList;
    private java.util.List<KeyValuePair> statusList;
    private java.util.List<KeyValuePair> custom1List;
    private java.util.List<KeyValuePair> custom2List;
    private java.util.List<KeyValuePair> custom3List;
    private java.util.List<KeyValuePair> custom4List;

    private AutoSelectCombo developer;
    private AutoSelectCombo publisher;
    private AutoSelectCombo genre;
    private AutoSelectCombo year;
    private AutoSelectCombo status;
    private Text link1;
    private Text link2;
    private Text link3;
    private Text link4;
    private BrowseButton link3BrowseButton;
    private BrowseButton link4BrowseButton;
    private Button favorite;
    private Text notes;
    
    private AutoSelectCombo custom1;
    private AutoSelectCombo custom2;
    private AutoSelectCombo custom3;
    private AutoSelectCombo custom4;
    private Text custom5;
    private Text custom6;
    private Text custom7;
    private Text custom8;
    private Scale custom9;
    private Spinner custom10;
    
    private Combo template;
    
    private Button loadfix;
    private Combo loadfix_value;
    
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text img1;
    private Text img2;
    
    private int templateIndex = -1;

    
    public EditProfileDialog(final Shell parent) {
        super(parent);
    }

    public void setProfile(final Profile prof) {
        this.result = prof;
    }

    public void sendToProfile(final String file) {
        this.result = FileUtils.makeRelativeToDosroot(new File(file)).getPath();
    }

    public void focusTitle() {
        this.focusOnTitle = true;
    }
    
    protected boolean init() {
        try {
            dbversionsList = dbase.readDosboxVersionsList();
            developersList = dbase.readDevelopersList();
            publishersList = dbase.readPublishersList();
            genresList = dbase.readGenresList();
            yearsList = dbase.readYearsList();
            templatesList = dbase.readTemplatesList();
            statusList = dbase.readStatusList();
            custom1List = dbase.readCustomList(0);
            custom2List = dbase.readCustomList(1);
            custom3List = dbase.readCustomList(2);
            custom4List = dbase.readCustomList(3);
        } catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(getParent(), e.getMessage());
            return false;
        }
        if (result instanceof Profile) {
            dbversionIndex = DosboxVersion.findById(dbversionsList, ((Profile) result).getDbversionId());
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            compConf = new CompositeConfiguration(dbversion, (Profile)result, true, getParent());
            if ((compConf.getCompositeConf().isIncomplete()) &&
                (!GeneralPurposeDialogs.confirmMessage(getParent(), "This profile appears to be incomplete. " +
                		"Continue editing the profile?\n\n " +
                        "This problem may be the result of changes to the mountings in the associated " +
                        FileUtils.DOSBOX_CONF + ", rendering the executable/booter location invalid.\n\n" +
                        "Press 'Yes' to continue editing the profile and fix the information in the mounting tab.\n" +
                        "Select 'No' if you'd like to restore the mounting information in '" + 
                        dbversion.getCanonicalConfFile() + "' to the original settings so that the paths are correct again."))) {
                    return false;
            }
        } else {
            dbversionIndex = DosboxVersion.findDefault(dbversionsList);
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            templateIndex = Template.findDefault(templatesList);
            if ((result instanceof String) && FileUtils.isConfFile((String) result)) {
                compConf = new CompositeConfiguration(dbversion, FileUtils.canonicalToDosroot((String) result), true, getParent());
            } else if (templateIndex != -1) {
                compConf = new CompositeConfiguration(dbversion, templatesList.get(templateIndex), true, getParent());
            } else {
                compConf = new CompositeConfiguration(dbversion, true, getParent());
            }
        }
        return true;
    }

    protected void createContents() {
        shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
        shell.setLayout(new BorderLayout(0, 0));
        shell.setSize(610, 475);

        if (result instanceof Profile) {
            // meaning we are essentially editing an existing profile
            shell.setText("Edit Profile " + ((Profile) result).getTitle() + " (" + ((Profile) result).getId() + ")");
        } else if (result instanceof String) {
            // meaning we are adding a new Profile with 'Send to...'
            shell.setText("Send " + (String) result + " to profile");
        } else {
            shell.setText("Add Profile");
        }

        final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);
        createInfoTab(tabFolder);
        createCustomTab(tabFolder);
        createGeneralTab(tabFolder);
        createDisplayTab(tabFolder);
        createMachineTab(tabFolder);
        createAudioTab(tabFolder);
        createIOTab(tabFolder);
        createMountingTab(tabFolder);

        final Button okButton = createOkCancelButtons();
        okButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (!isValid()) {
                    return;
                }
                try {
                    if (setButton.isEnabled()) {
                        doLoadTemplateConf(setButton, true, false); // set correct dbversion
                    }
                    int profileId = dbase.addOrEditProfile(title.getText(), developer.getText(), publisher.getText(), genre.getText(),
                            year.getText(), status.getText(), setup.getText(), setup_params.getText(), notes.getText(), 
                            favorite.getSelection(), developer.getKey(), publisher.getKey(), genre.getKey(), year.getKey(),
                            status.getKey(), compConf.getDbversionId(),
                            new String[] { link1.getText(), link2.getText(), link3.getText(), link4.getText() },
                            new String[] { custom1.getText(), custom2.getText(), custom3.getText(), custom4.getText(),
                                custom5.getText(), custom6.getText(), custom7.getText(), custom8.getText() },
                            new int[] { custom9.getSelection(), custom10.getSelection() },
                            new int[] { custom1.getKey(), custom2.getKey(), custom3.getKey(), custom4.getKey() },
                            result instanceof Profile ? ((Profile) result).getId() : -1);
                    compConf.setCompositeConf(getConfigurationBySettings());

                    String confString;
                    if (result instanceof Profile) {
                        confString = ((Profile) result).getConfPathAndFile();
                    } else {
                        confString = FileUtils.constructUniqueConfigFileString(profileId, title.getText(), compConf.getCompositeConf());
                    }

                    String capturesString;
                    if (result instanceof Profile) {
                        capturesString = ((Profile) result).getCaptures();
                    } else {
                        capturesString = FileUtils.constructCapturesDir(profileId);
                        FileUtils.createDir(FileUtils.canonicalToData(capturesString));
                    }

                    if (!(result instanceof Profile)) {
                        dbase.updateProfileConf(confString, capturesString, profileId);
                    }

                    result = new Profile(profileId, title.getText(), developer.getText(), publisher.getText(),
                            genre.getText(), year.getText(), compConf.getDbversionId(), setup.getText(), setup_params.getText(),
                            notes.getText(), link1.getText(), link2.getText(), favorite.getSelection(),
                            status.getText(), confString, capturesString, link3.getText(), link4.getText(),
                            custom1.getText(), custom2.getText(), custom3.getText(), custom4.getText(),
                            custom5.getText(), custom6.getText(), custom7.getText(), custom8.getText(),
                            custom9.getSelection(), custom10.getSelection());
                    
                    compConf.save((Profile)result, shell);
                } catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
                }
                shell.close();
            }
        });
        
        // init values
        for (DosboxVersion dbv : dbversionsList) {
            dbversion.add(dbv.getTitle());
        }
        for (Template templ : templatesList) {
            template.add(templ.getTitle());
        }
        dbversion.select(dbversionIndex);
        
        if (result instanceof Profile) {
            // meaning we are essentially editing an existing profile
            // so we need to set previous values
            title.setText(((Profile) result).getTitle());
            developer.setText(((Profile) result).getDeveloperName());
            publisher.setText(((Profile) result).getPublisherName());
            genre.setText(((Profile) result).getGenre());
            year.setText(((Profile) result).getYear());
            link1.setText(((Profile) result).getLink(0));
            link2.setText(((Profile) result).getLink(1));
            link3.setText(((Profile) result).getLink(2));
            link4.setText(((Profile) result).getLink(3));
            status.setText(((Profile) result).getStatus());
            favorite.setSelection(((Profile) result).isDefault());
            notes.setText(((Profile) result).getNotes());
            setup.setText(((Profile) result).getSetup());
            setup_params.setText(((Profile) result).getSetupParameters());
            custom1.setText(((Profile) result).getCustomString(0));
            custom2.setText(((Profile) result).getCustomString(1));
            custom3.setText(((Profile) result).getCustomString(2));
            custom4.setText(((Profile) result).getCustomString(3));
            custom5.setText(((Profile) result).getCustomString(4));
            custom6.setText(((Profile) result).getCustomString(5));
            custom7.setText(((Profile) result).getCustomString(6));
            custom8.setText(((Profile) result).getCustomString(7));
            custom9.setSelection(((Profile) result).getCustomInt(0));
            custom10.setSelection(((Profile) result).getCustomInt(1));

            if (focusOnTitle) {
                title.selectAll();
                title.setFocus();
            }
            
        } else {
            // set default values for new profile
            title.setFocus();
            if (templateIndex != -1) {
                template.select(templateIndex);
            }

            if (result instanceof String) {
                // send to profile
                if (FileUtils.isExecutable((String) result)) {
                    main.setText((String) result);
                } else if (FileUtils.isBooterImage((String) result)) {
                    img1.setText((String) result);
                }
            }
        }

        enableSettingsByConfiguration();
        selectSettingsByConfiguration();
        
        startListeners();
    }
    
    protected void createMachineTab(final TabFolder tabFolder) {
        super.createMachineTab(tabFolder);
        
        final Label loadfixLabel = new Label(memoryGroup, SWT.NONE);
        loadfixLabel.setText("Loadfix");
        loadfix = new Button(memoryGroup, SWT.CHECK);
        loadfix.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                loadfix_value.setEnabled(loadfix.getSelection());
            }
        });
        loadfix_value = new Combo(memoryGroup, SWT.NONE);
        loadfix_value.setItems(settings.getValues("profile", "loadfix_value"));
        loadfix_value.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        final Label kbLabel = new Label(memoryGroup, SWT.NONE);
        kbLabel.setText("KB");
    }

    protected void createInfoTab(final TabFolder tabFolder) {
        infoTabItem = new TabItem(tabFolder, SWT.NONE);
        infoTabItem.setText("Info");

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite.setLayout(gridLayout);
        infoTabItem.setControl(composite);

        final Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText("Title");
        title = new Text(composite, SWT.BORDER);
        title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

        final Label developerLabel = new Label(composite, SWT.NONE);
        developerLabel.setText("Developer");
        developer = new AutoSelectCombo(composite, SWT.NONE, developersList);
        developer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        developer.setVisibleItemCount(15);

        final Label publisherLabel = new Label(composite, SWT.NONE);
        publisherLabel.setLayoutData(new GridData());
        publisherLabel.setText("Publisher");
        publisher = new AutoSelectCombo(composite, SWT.NONE, publishersList);
        publisher.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        publisher.setVisibleItemCount(15);

        final Label genreLabel = new Label(composite, SWT.NONE);
        genreLabel.setText("Genre");
        genre = new AutoSelectCombo(composite, SWT.NONE, genresList);
        genre.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        genre.setVisibleItemCount(15);

        final Label yearLabel = new Label(composite, SWT.NONE);
        yearLabel.setLayoutData(new GridData());
        yearLabel.setText("Year");
        year = new AutoSelectCombo(composite, SWT.NONE, yearsList);
        year.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        year.setVisibleItemCount(15);

        final Label link1Label = new Label(composite, SWT.NONE);
        link1Label.setText("Link 1");
        link1 = new Text(composite, SWT.BORDER);
        link1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final Label link2Label = new Label(composite, SWT.NONE);
        link2Label.setLayoutData(new GridData());
        link2Label.setText("Link 2");
        link2 = new Text(composite, SWT.BORDER);
        link2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final Label link3Label = new Label(composite, SWT.NONE);
        link3Label.setText("Link 3");
        link3 = new Text(composite, SWT.BORDER);
        link3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        link3BrowseButton = new BrowseButton(composite, SWT.NONE);

        final Label link4Label = new Label(composite, SWT.NONE);
        link4Label.setText("Link 4");
        link4 = new Text(composite, SWT.BORDER);
        link4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        link4BrowseButton = new BrowseButton(composite, SWT.NONE);

        final Label statusLabel = new Label(composite, SWT.NONE);
        statusLabel.setText("Status");
        status = new AutoSelectCombo(composite, SWT.NONE, statusList);
        status.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        status.setVisibleItemCount(10);
        new Label(composite, SWT.NONE);

        final Label favoriteLabel = new Label(composite, SWT.NONE);
        favoriteLabel.setText("Favorite");
        favorite = new Button(composite, SWT.CHECK);
        new Label(composite, SWT.NONE);

        final Label notesLabel = new Label(composite, SWT.NONE);
        notesLabel.setText("Notes");
        notes = new Text(composite, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.WRAP);
        final GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1);
        notes.setLayoutData(gridData);
    }
    
    private void createCustomTab(final TabFolder tabFolder) {
        final TabItem customTabItem = new TabItem(tabFolder, SWT.NONE);
        customTabItem.setText("Custom Info");

        final Composite composite_8 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_21 = new GridLayout();
        gridLayout_21.numColumns = 2;
        composite_8.setLayout(gridLayout_21);
        customTabItem.setControl(composite_8);

        final Label custom1Label = new Label(composite_8, SWT.NONE);
        custom1Label.setText(settings.getValue(Settings.GUI, "custom1"));
        custom1 = new AutoSelectCombo(composite_8, SWT.NONE, custom1List);
        custom1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom2Label = new Label(composite_8, SWT.NONE);
        custom2Label.setText(settings.getValue(Settings.GUI, "custom2"));
        custom2 = new AutoSelectCombo(composite_8, SWT.NONE, custom2List);
        custom2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom3Label = new Label(composite_8, SWT.NONE);
        custom3Label.setText(settings.getValue(Settings.GUI, "custom3"));
        custom3 = new AutoSelectCombo(composite_8, SWT.NONE, custom3List);
        custom3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom4Label = new Label(composite_8, SWT.NONE);
        custom4Label.setText(settings.getValue(Settings.GUI, "custom4"));
        custom4 = new AutoSelectCombo(composite_8, SWT.NONE, custom4List);
        custom4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom5Label = new Label(composite_8, SWT.NONE);
        custom5Label.setText(settings.getValue(Settings.GUI, "custom5"));
        custom5 = new Text(composite_8, SWT.BORDER);
        custom5.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom6Label = new Label(composite_8, SWT.NONE);
        custom6Label.setText(settings.getValue(Settings.GUI, "custom6"));
        custom6 = new Text(composite_8, SWT.BORDER);
        custom6.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom7Label = new Label(composite_8, SWT.NONE);
        custom7Label.setText(settings.getValue(Settings.GUI, "custom7"));
        custom7 = new Text(composite_8, SWT.BORDER);
        custom7.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom8Label = new Label(composite_8, SWT.NONE);
        custom8Label.setText(settings.getValue(Settings.GUI, "custom8"));
        custom8 = new Text(composite_8, SWT.BORDER);
        custom8.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom9Label = new Label(composite_8, SWT.NONE);
        custom9Label.setText(settings.getValue(Settings.GUI, "custom9"));
        custom9 = new Scale(composite_8, SWT.NONE);
        custom9.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom10Label = new Label(composite_8, SWT.NONE);
        custom10Label.setText(settings.getValue(Settings.GUI, "custom10"));
        custom10 = new Spinner(composite_8, SWT.BORDER);
        custom10.setLayoutData(new GridData(100, SWT.DEFAULT));
        custom10.setMinimum(Integer.MIN_VALUE);
        custom10.setMaximum(Integer.MAX_VALUE);
    }

    protected void createGeneralTab(final TabFolder tabFolder) {
        super.createGeneralTab(tabFolder);
        
        final Label templateLabel = new Label(associationGroup, SWT.NONE);
        templateLabel.setText("Template");
        template = new Combo(associationGroup, SWT.READ_ONLY);
        final GridData gridData_6 = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
        template.setLayoutData(gridData_6);
        final Button reloadButton2 = new Button(associationGroup, SWT.NONE);
        reloadButton2.setText("Reload Settings");
        reloadButton2.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (template.getSelectionIndex() != -1) {
                    doLoadTemplateConf(setButton, false, true);
                }
            }
        });

        final Label configFileLabel = new Label(miscGroup, SWT.NONE);
        configFileLabel.setText("Config File");
        Text config_file = new Text(miscGroup, SWT.BORDER);
        config_file.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
        config_file.setEditable(false);
        config_file.setText(result instanceof Profile ? ((Profile) result).getConfPathAndFile() : 
            SettingsDialog.confLocations[settings.getIntValue("profiledefaults", "confpath")] + ", " + 
            SettingsDialog.confFilenames[settings.getIntValue("profiledefaults", "conffile")]);
    }
    
    protected void createExecuteGroup(final Composite composite) {
        final Group executeGroup = new Group(composite, SWT.NONE);
        executeGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        executeGroup.setText("Execute");
        final GridLayout gridLayout_18 = new GridLayout();
        gridLayout_18.numColumns = 6;
        executeGroup.setLayout(gridLayout_18);

        dosButton = new Button(executeGroup, SWT.RADIO);
        dosButton.setText("DOS");
        final Label mainExeLabel = new Label(executeGroup, SWT.NONE);
        mainExeLabel.setText("Main");
        main = new Text(executeGroup, SWT.BORDER);
        final GridData gridData_1 = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
        main.setLayoutData(gridData_1);

        link3BrowseButton.connect(shell, link3, main, BrowseType.FILE, CanonicalType.DOC, null);
        link4BrowseButton.connect(shell, link4, main, BrowseType.FILE, CanonicalType.DOC, null);

        final BrowseButton mainBrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        mainBrowseButton.connect(shell, main, null, BrowseType.FILE, CanonicalType.EXE, pixelshader);

        final GrabButton grab1 = new GrabButton(executeGroup, SWT.NONE);
        grab1.connect(main, mountingpoints);

        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);
        final Label parametersLabel = new Label(executeGroup, SWT.NONE);
        parametersLabel.setLayoutData(new GridData());
        parametersLabel.setText("Parameters");
        main_params = new Text(executeGroup, SWT.BORDER);
        main_params.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);
        
        new Label(executeGroup, SWT.NONE);
        final Label setupLabel = new Label(executeGroup, SWT.NONE);
        setupLabel.setLayoutData(new GridData());
        setupLabel.setText("Setup");
        setup = new Text(executeGroup, SWT.BORDER);
        setup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final BrowseButton setupBrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        setupBrowseButton.connect(shell, setup, main, BrowseType.FILE, CanonicalType.EXE, pixelshader);

        final GrabButton grab2 = new GrabButton(executeGroup, SWT.NONE);
        grab2.connect(setup, mountingpoints);

        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);
        final Label parametersLabel_1 = new Label(executeGroup, SWT.NONE);
        parametersLabel_1.setLayoutData(new GridData());
        parametersLabel_1.setText("Parameters");
        setup_params = new Text(executeGroup, SWT.BORDER);
        setup_params.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);

        final Label label_1 = new Label(executeGroup, SWT.SEPARATOR | SWT.HORIZONTAL);
        label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 6, 1));

        booterButton = new Button(executeGroup, SWT.RADIO);
        booterButton.setText("Booter");
        final Label image1Label = new Label(executeGroup, SWT.NONE);
        image1Label.setText("Image 1");
        img1 = new Text(executeGroup, SWT.BORDER);
        img1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final BrowseButton img1BrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        img1BrowseButton.connect(shell, img1, null, BrowseType.FILE, CanonicalType.BOOTER, null);

        final GrabButton grab3 = new GrabButton(executeGroup, SWT.NONE);
        grab3.connect(img1, mountingpoints);

        new Label(executeGroup, SWT.NONE);
        final Label image2Label = new Label(executeGroup, SWT.NONE);
        image2Label.setText("Image 2");
        img2 = new Text(executeGroup, SWT.BORDER);
        img2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final BrowseButton img2BrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        img2BrowseButton.connect(shell, img2, img1, BrowseType.FILE, CanonicalType.BOOTER, null);

        final GrabButton grab4 = new GrabButton(executeGroup, SWT.NONE);
        grab4.connect(img2, mountingpoints);
    }
    
    private void startListeners() {
        VerifyListener addMountListener = new VerifyListener() {
            public void verifyText(final VerifyEvent event) {
                if (event.text.length() > 1) {
                    boolean booter = event.widget == img1 || event.widget == img2;
                    addMountIfNoMounts(event.text, booter);
                }
            }
        };
        
        ModifyListener exeListener = new ModifyListener() {
            public void modifyText(final ModifyEvent event) {
                boolean booter = event.widget == img1 || event.widget == img2;
                dosButton.setSelection(!booter);
                booterButton.setSelection(booter);
            }
        };

        main.addVerifyListener(addMountListener);
        setup.addVerifyListener(addMountListener);
        img1.addVerifyListener(addMountListener);
        img2.addVerifyListener(addMountListener);
        main.addModifyListener(exeListener);
        main_params.addModifyListener(exeListener);
        setup.addModifyListener(exeListener);
        setup_params.addModifyListener(exeListener);
        img1.addModifyListener(exeListener);
        img2.addModifyListener(exeListener);
    }
    
    private void addMountIfNoMounts(final String hostFileLocation, final boolean booter) {
        if (mountingpoints.getItemCount() == 0) {
            try{
                mountingpoints.setItems(compConf.addRequiredMount(booter, hostFileLocation));
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            } catch (Exception e) {
                // since the mounting point could not be instantiated, just forget about it
            }
        }
    }
    
    public static Profile duplicateProfile(final Profile prof, final Database dbase, final Shell shell) {
        try {
            CompositeConfiguration newCompositeConf = new CompositeConfiguration(prof, true, shell);
            int newProfileId = dbase.duplicateProfile(prof.getId());
            String newCapturesString = FileUtils.constructCapturesDir(newProfileId);
            File newCaptures = FileUtils.canonicalToData(newCapturesString);
            FileUtils.createDir(newCaptures);
            String newConfFile = FileUtils.constructUniqueConfigFileString(newProfileId, prof.getTitle(), newCompositeConf.getCompositeConf());
            
            Profile newProfile = new Profile(newProfileId, newConfFile, newCapturesString, prof);
            
            newCompositeConf.save(newProfile, shell);

            dbase.updateProfileConf(newConfFile, newCapturesString, newProfileId);
            if (GeneralPurposeDialogs.confirmMessage(shell, "Would you like to duplicate the captures too?")) {
                FileUtils.copyFiles(prof.getCanonicalCaptures(), newCaptures);
            }
            return newProfile;
        } catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
            return null;
        }
    }
    
    protected CompositeConfiguration obtainNewConf(final boolean keepValues, final boolean isTemplate) {
        if (isTemplate) {
            return new CompositeConfiguration(compConf, dbversionsList.get(dbversion.getSelectionIndex()), 
                    templatesList.get(template.getSelectionIndex()), false, shell);
        } else {
            return new CompositeConfiguration(compConf, dbversionsList.get(dbversion.getSelectionIndex()), 
                    keepValues, isTemplate, shell);
        }
    }
    
    protected void selectSettingsByConfiguration() {
        super.selectSettingsByConfiguration();
        Configuration conf = compConf.getCompositeConf();
        captures.setText(result instanceof Profile ? ((Profile) result).getCaptures(): "<automatic>");
        loadfix.setSelection(conf.isLoadfix());
        loadfix_value.setText(conf.getLoadfixValue());
        loadfix_value.setEnabled(conf.isLoadfix());
        if (conf.isBooter()) {
            img1.setText(conf.getImg1());
            img2.setText(conf.getImg2());
        } else {
            main.setText(conf.getMain());
            main_params.setText(conf.getMainParameters());
        }
    }
    
    protected Configuration getConfigurationBySettings() {
        Configuration conf = super.getConfigurationBySettings();
        conf.setAutoexecSettings(loadfix.getSelection(), loadfix_value.getText(), main.getText(), main_params.getText(), img1.getText(), img2.getText());
        return conf;
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String requiredMount = null;
        if (title.getText().length() == 0) {
            GeneralPurposeDialogs.addError("You must enter a profile title", title, infoTabItem);
        }
        if (dosButton.getSelection()) {
            if (FileUtils.isExecutable(main.getText())) {
                requiredMount = dealWithField(false, main.getText());
            } else {
                GeneralPurposeDialogs.addError("You must enter a valid profile executable", main, mountingTabItem);
            }
            if (FileUtils.isExecutable(setup.getText())) {
                requiredMount = dealWithField(false, setup.getText());
            }
        } else if (booterButton.getSelection()) {
            if (img1.getText().length() == 0) {
                GeneralPurposeDialogs.addError("You must enter a profile booter image", img1, mountingTabItem);
            } else {
                requiredMount = dealWithField(true, img1.getText());
            }
            if (img2.getText().length() > 0) {
                requiredMount = dealWithField(true, img2.getText());
            }
        }
        if (requiredMount != null) {
            GeneralPurposeDialogs.addError("You must enter a valid mount location", mountingpoints, mountingTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(shell);
    }
    
    private String dealWithField(final boolean booter, final String loc) {
        String requiredMount = compConf.getRequiredMount(booter, loc);
        if (requiredMount != null && GeneralPurposeDialogs.confirmMessage(shell, "Would you like to add the mount location \"" + requiredMount + "\"?")) {
            mountingpoints.setItems(compConf.addRequiredMount(booter, loc));
        }
        return compConf.getRequiredMount(booter, loc);
    }
}
