package com.gui;

import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import com.db.Database;
import com.model.DosboxVersion;
import com.model.Mount;
import com.model.Settings;
import com.model.Template;
import com.model.conf.CompositeConfiguration;
import com.model.conf.Configuration;
import swing2swt.layout.BorderLayout;


public class EditTemplateDialog extends Dialog {

    private static final String IPX = "ipx";
    private static final String SERIAL = "serial";
    private static final String SPEAKER = "speaker";
    private static final String MIDI = "midi";
    private static final String MIXER = "mixer";
    private static final String DOS = "dos";
    private static final String GLIDE = "glide";
    private static final String VSYNC = "vsync";
    private static final String VGA = "vga";
    private static final String RENDER = "render";
    private static final String SDL = "sdl";
    private static final String ENABLE = "Enable";
    private static final String SAMPLE_RATE = "Sample Rate";
    
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button reloadButton;
    protected Combo priority_active, priority_inactive;
    protected Button waitonerror, exit;
    protected Text language, captures;
    protected Combo output, frameskip;
    protected Combo scaler, pixelshader;
    protected Button fulldouble, fullscreen;
    protected Combo fullresolution, windowresolution;
    protected Button aspect;
    protected Text overscan;
    protected Combo svgachipset, videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Button glide;
    protected Text glideport;
    protected Combo machine, cpu_type, core;
    protected Combo cycles, cycles_up, cycles_down;
    protected Button timesynched;
    protected Combo memsize;
    protected Button xms, ems;
    protected Combo umb;
    protected Button nosound;
    protected Combo rate, blocksize, prebuffer, mpu401, device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo mt32rate;
    protected Combo sbtype, oplrate, oplmode, sbbase, irq, dma, hdma;
    protected Button mixer;
    protected Button gus;
    protected Combo gusrate, gusbase, dma1, dma2, irq1, irq2;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy, tandyrate;
    protected Button disney;
    protected Button usescancodes;
    protected Text mapperfile;
    protected Text keyboard_layout;
    protected Text keyb;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed, autofire, swap34, buttonwrap;
    protected Text serial1, serial2, serial3, serial4;
    protected Button ipx;
    protected List mountingpoints;
    protected Button booterButton, dosButton;
    protected Group memoryGroup, associationGroup, miscGroup, executeGroup;
    protected TabItem infoTabItem, mountingTabItem;
    
    protected int dbversionIndex = -1;
    
    protected Shell shell;
    protected java.util.List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected CompositeConfiguration compConf;
    protected Settings settings;
    protected Object result;


    public EditTemplateDialog(final Shell parent) {
        super(parent, SWT.NONE);
    }

    public void setTemplate(final Template template) {
        this.result = template;
    }

    public Object open() {
        settings = Settings.getInstance();
        dbase = Database.getInstance();
        if (init()) { 
            createContents();
            shell.open();
            shell.layout();
            Display display = getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
            }
        }
        return result;
    }

    protected boolean init() {
        try {
            dbversionsList = dbase.readDosboxVersionsList();
        } catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(getParent(), e.getMessage());
            return false;
        }
        if (result == null) {
            dbversionIndex = DosboxVersion.findDefault(dbversionsList);
            compConf = new CompositeConfiguration(dbversionsList.get(dbversionIndex), true, getParent());
        } else {
            dbversionIndex = DosboxVersion.findById(dbversionsList, ((Template)result).getdbversionId());
            compConf = new CompositeConfiguration(dbversionsList.get(dbversionIndex), (Template)result, true, getParent());
        }
        return true;
    }
    
    protected void createContents() {
        shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
        shell.setLayout(new BorderLayout(0, 0));
        shell.setSize(610, 475);
        if (result == null) {
            shell.setText("Add Template");
        } else {
            // meaning we are essentially editing an existing template
            shell.setText("Edit Template " + ((Template)result).getTitle() + " (" + ((Template) result).getId() + ")");
        }

        final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);
        createInfoTab(tabFolder);
        createGeneralTab(tabFolder);
        createDisplayTab(tabFolder);
        createMachineTab(tabFolder);
        createAudioTab(tabFolder);
        createIOTab(tabFolder);
        createMountingTab(tabFolder);

        final Button okButton = createOkCancelButtons();
        okButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (!isValid()) {
                    return;
                }
                try {
                    if (setButton.isEnabled()) {
                        doLoadTemplateConf(setButton, true, false); // set correct dbversion
                    }
                    int templateId = dbase.addOrEditTemplate(title.getText(), compConf.getDbversionId(),
                            defaultButton.getSelection(), result == null ? -1: ((Template)result).getId());
                    compConf.setCompositeConf(getConfigurationBySettings());
                    result = new Template(templateId, title.getText(), compConf.getDbversionId(), defaultButton.getSelection());
                    compConf.save((Template)result, shell);
                } catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
                }
                shell.close();
            }
        });

        // init values
        for (DosboxVersion dbv : dbversionsList) {
            dbversion.add(dbv.getTitle());
        }
        dbversion.select(dbversionIndex);
        
        if (result == null) {
            title.setFocus();
        } else {
            // meaning we are essentially editing an existing template
            // so we need to set previous values
            title.setText(((Template)result).getTitle());
            defaultButton.setSelection(((Template)result).isDefault());
        }

        enableSettingsByConfiguration();
        selectSettingsByConfiguration();
    }
    
    protected Button createOkCancelButtons() {
        final Composite composite_7 = new Composite(shell, SWT.NONE);
        composite_7.setLayout(new RowLayout());
        composite_7.setLayoutData(BorderLayout.SOUTH);

        final Button okButton = new Button(composite_7, SWT.NONE);
        shell.setDefaultButton(okButton);
        final RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        okButton.setText("OK");
        
        final Button cancelButton = new Button(composite_7, SWT.NONE);
        final RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                result = null;
                shell.close();
            }
        });
        return okButton;
    }

    protected void createMountingTab(final TabFolder tabFolder) {
        mountingTabItem = new TabItem(tabFolder, SWT.NONE);
        mountingTabItem.setText("Mounting");

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        composite.setLayout(new GridLayout());
        mountingTabItem.setControl(composite);

        createMountingGroup(composite);
        createExecuteGroup(composite);
    }

    protected void createExecuteGroup(final Composite composite) {
        executeGroup = new Group(composite, SWT.NONE);
        executeGroup.setLayoutData(new GridData());
        executeGroup.setText("Execute");
        final GridLayout gridLayout_18 = new GridLayout();
        executeGroup.setLayout(gridLayout_18);

        dosButton = new Button(executeGroup, SWT.RADIO);
        dosButton.setText("DOS");

        final Label label_1 = new Label(executeGroup, SWT.SEPARATOR | SWT.HORIZONTAL);
        label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));

        booterButton = new Button(executeGroup, SWT.RADIO);
        booterButton.setText("Booter");
    }

    protected void createMountingGroup(final Composite composite) {
        final Group mountGroup = new Group(composite, SWT.NONE);
        mountGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        mountGroup.setText("Mounting Overview");
        final GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout(gridLayout_19);

        mountingpoints = new List(mountGroup, SWT.V_SCROLL | SWT.BORDER);
        final GridData gridData_2 = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 3);
        mountingpoints.setLayoutData(gridData_2);
        mountingpoints.addMouseListener(new MouseAdapter() {
            public void mouseDoubleClick(final MouseEvent event) {
                if (mountingpoints.getSelectionIndex() == -1) {
                    doAddMount();
                } else {
                    doEditMount();
                }
            }
        });

        final Button addButton = new Button(mountGroup, SWT.NONE);
        addButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doAddMount();
            }
        });

        final Button editButton = new Button(mountGroup, SWT.NONE);
        editButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        editButton.setText("Edit");
        editButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doEditMount();
            }
        });

        final Button removeButton = new Button(mountGroup, SWT.NONE);
        removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        removeButton.setText("Remove");
        removeButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doRemoveMount();
            }
        });
    }

    protected void createIOTab(final TabFolder tabFolder) {
        final TabItem inputTabItem = new TabItem(tabFolder, SWT.NONE);
        inputTabItem.setText("I/O");

        final Composite composite_5 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout(gridLayout_17);
        inputTabItem.setControl(composite_5);

        final Group mouseGroup = new Group(composite_5, SWT.NONE);
        mouseGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        mouseGroup.setText("Mouse");
        final GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout(gridLayout_13);

        final Label autolockLabel = new Label(mouseGroup, SWT.NONE);
        autolockLabel.setText("Autolock");
        autolock = new Button(mouseGroup, SWT.CHECK);

        final Label sensitivityLabel = new Label(mouseGroup, SWT.NONE);
        sensitivityLabel.setText("Sensitivity");
        sensitivity = new Combo(mouseGroup, SWT.READ_ONLY);
        sensitivity.setItems(settings.getValues(Settings.PROFILE, "sensitivity"));
        sensitivity.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        sensitivity.setVisibleItemCount(20);

        final Group keyboardGroup = new Group(composite_5, SWT.NONE);
        keyboardGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        keyboardGroup.setText("Keyboard");
        final GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout(gridLayout_14);

        final Label useScancodesLabel = new Label(keyboardGroup, SWT.NONE);
        useScancodesLabel.setText("Use Scancodes");
        usescancodes = new Button(keyboardGroup, SWT.CHECK);

        final Label mapperFileLabel = new Label(keyboardGroup, SWT.NONE);
        mapperFileLabel.setText("Mapper File");
        mapperfile = new Text(keyboardGroup, SWT.BORDER);
        mapperfile.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label layoutLabel = new Label(keyboardGroup, SWT.NONE);
        layoutLabel.setText("Layout");
        keyboard_layout = new Text(keyboardGroup, SWT.BORDER);
        keyboard_layout.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        
        final Label keybLabel = new Label(keyboardGroup, SWT.NONE);
        keybLabel.setText("Keyb command");
        keyb = new Text(keyboardGroup, SWT.BORDER);
        keyb.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Group joystickGroup = new Group(composite_5, SWT.NONE);
        joystickGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        joystickGroup.setText(Configuration.JOYSTICK);
        final GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout(gridLayout_15);

        final Label typeLabel_1 = new Label(joystickGroup, SWT.NONE);
        typeLabel_1.setText("Type");
        joysticktype = new Combo(joystickGroup, SWT.READ_ONLY);
        joysticktype.setItems(settings.getValues(Settings.PROFILE, Settings.JOYSTICKTYPE));
        joysticktype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label timedLabel = new Label(joystickGroup, SWT.NONE);
        timedLabel.setText("Timed emulation");
        timed = new Button(joystickGroup, SWT.CHECK);

        final Label autofireLabel = new Label(joystickGroup, SWT.NONE);
        autofireLabel.setText("Autofire");
        autofire = new Button(joystickGroup, SWT.CHECK);

        final Label swapAxes3Label = new Label(joystickGroup, SWT.NONE);
        swapAxes3Label.setText("Swap axes 3&&4");
        swap34 = new Button(joystickGroup, SWT.CHECK);

        final Label buttonWrapLabel = new Label(joystickGroup, SWT.NONE);
        buttonWrapLabel.setText("Button wrapping");
        buttonwrap = new Button(joystickGroup, SWT.CHECK);

        final Group modemGroup = new Group(composite_5, SWT.NONE);
        modemGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        modemGroup.setText("Modem");
        final GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout(gridLayout_16);

        final Label serial1Label = new Label(modemGroup, SWT.NONE);
        serial1Label.setText("Serial 1");
        serial1 = new Text(modemGroup, SWT.BORDER);
        serial1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label serial2Label = new Label(modemGroup, SWT.NONE);
        serial2Label.setText("Serial 2");
        serial2 = new Text(modemGroup, SWT.BORDER);
        serial2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label serial3Label = new Label(modemGroup, SWT.NONE);
        serial3Label.setText("Serial 3");
        serial3 = new Text(modemGroup, SWT.BORDER);
        serial3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label serial4Label = new Label(modemGroup, SWT.NONE);
        serial4Label.setText("Serial 4");
        serial4 = new Text(modemGroup, SWT.BORDER);
        serial4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Group networkGroup = new Group(composite_5, SWT.NONE);
        networkGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        networkGroup.setText("Network");
        final GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout(gridLayout_20);

        final Label ipxLabel = new Label(networkGroup, SWT.NONE);
        ipxLabel.setText("Enable IPX");
        ipx = new Button(networkGroup, SWT.CHECK);
        new Label(composite_5, SWT.NONE);
    }

    protected void createAudioTab(final TabFolder tabFolder) {
        final TabItem audioTabItem = new TabItem(tabFolder, SWT.NONE);
        audioTabItem.setText("Audio");

        final Composite composite_4 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout(gridLayout_9);
        audioTabItem.setControl(composite_4);

        final Group generalGroup = new Group(composite_4, SWT.NONE);
        generalGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        final GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout(gridLayout_6);
        generalGroup.setText("General");

        final Label silentModeLabel = new Label(generalGroup, SWT.NONE);
        silentModeLabel.setText("Silent Mode");
        nosound = new Button(generalGroup, SWT.CHECK);

        final Label sampleRateLabel = new Label(generalGroup, SWT.NONE);
        sampleRateLabel.setText(SAMPLE_RATE);
        rate = new Combo(generalGroup, SWT.READ_ONLY);
        rate.setItems(settings.getValues(Settings.PROFILE, Settings.RATE));
        rate.setLayoutData(new GridData());

        final Label blockSizeLabel = new Label(generalGroup, SWT.NONE);
        blockSizeLabel.setText("Block Size");
        blocksize = new Combo(generalGroup, SWT.READ_ONLY);
        blocksize.setItems(settings.getValues(Settings.PROFILE, "blocksize"));
        blocksize.setLayoutData(new GridData());

        final Label prebufferLabel = new Label(generalGroup, SWT.NONE);
        prebufferLabel.setText("Prebuffer");
        prebuffer = new Combo(generalGroup, SWT.NONE);
        prebuffer.setItems(settings.getValues(Settings.PROFILE, "prebuffer"));
        prebuffer.setLayoutData(new GridData(70, SWT.DEFAULT));

        final Label mpu401Label = new Label(generalGroup, SWT.NONE);
        mpu401Label.setText("MPU-401");
        mpu401 = new Combo(generalGroup, SWT.READ_ONLY);
        mpu401.setItems(settings.getValues(Settings.PROFILE, "mpu401"));
        mpu401.setLayoutData(new GridData());

        final Label midiDeviceLabel = new Label(generalGroup, SWT.NONE);
        midiDeviceLabel.setText("Midi Device");
        device = new Combo(generalGroup, SWT.READ_ONLY);
        device.setItems(settings.getValues(Settings.PROFILE, "device"));
        device.setLayoutData(new GridData());

        final Label configLabel = new Label(generalGroup, SWT.NONE);
        configLabel.setText("Config");
        midi_config = new Text(generalGroup, SWT.BORDER);
        midi_config.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label mixerConfigLabel = new Label(generalGroup, SWT.NONE);
        mixerConfigLabel.setText("Mixer command");
        mixer_config = new Text(generalGroup, SWT.BORDER);
        mixer_config.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Group soundblasterGroup = new Group(composite_4, SWT.NONE);
        soundblasterGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        soundblasterGroup.setText("Soundblaster");
        final GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout(gridLayout_7);

        final Label typeLabel = new Label(soundblasterGroup, SWT.NONE);
        typeLabel.setText("Type");
        sbtype = new Combo(soundblasterGroup, SWT.READ_ONLY);
        sbtype.setItems(settings.getValues(Settings.PROFILE, Configuration.SBTYPE));
        sbtype.setLayoutData(new GridData());

        final Label oplRateLabel = new Label(soundblasterGroup, SWT.NONE);
        oplRateLabel.setText("OPL Rate");
        oplrate = new Combo(soundblasterGroup, SWT.READ_ONLY);
        oplrate.setItems(settings.getValues(Settings.PROFILE, "oplrate"));
        oplrate.setLayoutData(new GridData());

        final Label oplModeLabel = new Label(soundblasterGroup, SWT.NONE);
        oplModeLabel.setLayoutData(new GridData());
        oplModeLabel.setText("OPL Mode");
        oplmode = new Combo(soundblasterGroup, SWT.READ_ONLY);
        oplmode.setItems(settings.getValues(Settings.PROFILE, "oplmode"));
        oplmode.setLayoutData(new GridData());

        final Label addressLabel = new Label(soundblasterGroup, SWT.NONE);
        addressLabel.setText("Address");
        sbbase = new Combo(soundblasterGroup, SWT.READ_ONLY);
        sbbase.setItems(settings.getValues(Settings.PROFILE, Configuration.SBBASE));
        sbbase.setLayoutData(new GridData());

        final Label irqLabel = new Label(soundblasterGroup, SWT.NONE);
        irqLabel.setText("IRQ");
        irq = new Combo(soundblasterGroup, SWT.READ_ONLY);
        irq.setItems(settings.getValues(Settings.PROFILE, "irq"));
        irq.setLayoutData(new GridData());

        final Label dmaLabel = new Label(soundblasterGroup, SWT.NONE);
        dmaLabel.setText("DMA");
        dma = new Combo(soundblasterGroup, SWT.READ_ONLY);
        dma.setItems(settings.getValues(Settings.PROFILE, "dma"));
        dma.setLayoutData(new GridData());

        final Label hdmaLabel = new Label(soundblasterGroup, SWT.NONE);
        hdmaLabel.setLayoutData(new GridData());
        hdmaLabel.setText("HDMA");
        hdma = new Combo(soundblasterGroup, SWT.READ_ONLY);
        hdma.setItems(settings.getValues(Settings.PROFILE, "hdma"));
        hdma.setLayoutData(new GridData());

        final Label mixerLabel = new Label(soundblasterGroup, SWT.NONE);
        mixerLabel.setText("Mixer");
        mixer = new Button(soundblasterGroup, SWT.CHECK);

        final Group gusGroup = new Group(composite_4, SWT.NONE);
        gusGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        gusGroup.setText("Gravis Ultrasound");
        final GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout(gridLayout_8);

        final Label enableLabel_1 = new Label(gusGroup, SWT.NONE);
        enableLabel_1.setLayoutData(new GridData());
        enableLabel_1.setText(ENABLE);
        gus = new Button(gusGroup, SWT.CHECK);
        gus.setLayoutData(new GridData());

        final Label sampleRateLabel_2 = new Label(gusGroup, SWT.NONE);
        sampleRateLabel_2.setText(SAMPLE_RATE);
        gusrate = new Combo(gusGroup, SWT.READ_ONLY);
        gusrate.setItems(settings.getValues(Settings.PROFILE, Configuration.GUSRATE));
        gusrate.setLayoutData(new GridData());

        final Label addressLabel_1 = new Label(gusGroup, SWT.NONE);
        addressLabel_1.setText("Address");
        gusbase = new Combo(gusGroup, SWT.READ_ONLY);
        gusbase.setItems(settings.getValues(Settings.PROFILE, Configuration.GUSBASE));
        gusbase.setLayoutData(new GridData());

        final Label irqLabel_1 = new Label(gusGroup, SWT.NONE);
        irqLabel_1.setText("IRQ1");
        irq1 = new Combo(gusGroup, SWT.READ_ONLY);
        irq1.setItems(settings.getValues(Settings.PROFILE, "irq1"));
        irq1.setLayoutData(new GridData());

        final Label irq2Label = new Label(gusGroup, SWT.NONE);
        irq2Label.setText("IRQ2");
        irq2 = new Combo(gusGroup, SWT.READ_ONLY);
        irq2.setItems(settings.getValues(Settings.PROFILE, "irq2"));
        irq2.setLayoutData(new GridData());

        final Label dmaLabel_1 = new Label(gusGroup, SWT.NONE);
        dmaLabel_1.setText("DMA1");
        dma1 = new Combo(gusGroup, SWT.READ_ONLY);
        dma1.setItems(settings.getValues(Settings.PROFILE, "dma1"));
        dma1.setLayoutData(new GridData());

        final Label hdmaLabel_1 = new Label(gusGroup, SWT.NONE);
        hdmaLabel_1.setLayoutData(new GridData());
        hdmaLabel_1.setText("DMA2");
        dma2 = new Combo(gusGroup, SWT.READ_ONLY);
        dma2.setItems(settings.getValues(Settings.PROFILE, "dma2"));
        dma2.setLayoutData(new GridData());

        final Label ultradirLabel = new Label(gusGroup, SWT.NONE);
        ultradirLabel.setText("Ultradir");
        ultradir = new Text(gusGroup, SWT.BORDER);
        ultradir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Group speakerGroup = new Group(composite_4, SWT.NONE);
        speakerGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        speakerGroup.setText("PC Speaker");
        final GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout(gridLayout_10);

        final Label enableLabel = new Label(speakerGroup, SWT.NONE);
        enableLabel.setText(ENABLE);
        pcspeaker = new Button(speakerGroup, SWT.CHECK);

        final Label sampleRateLabel_1 = new Label(speakerGroup, SWT.NONE);
        sampleRateLabel_1.setText(SAMPLE_RATE);
        pcrate = new Combo(speakerGroup, SWT.READ_ONLY);
        pcrate.setItems(settings.getValues(Settings.PROFILE, "pcrate"));
        pcrate.setLayoutData(new GridData());

        final Group tandyGroup = new Group(composite_4, SWT.NONE);
        tandyGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        tandyGroup.setText("Tandy");
        final GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout(gridLayout_11);

        final Label enableLabel_2 = new Label(tandyGroup, SWT.NONE);
        enableLabel_2.setText(ENABLE);
        tandy = new Combo(tandyGroup, SWT.READ_ONLY);
        tandy.setItems(settings.getValues(Settings.PROFILE, "tandy"));
        tandy.setLayoutData(new GridData());

        final Label sampleLabel2 = new Label(tandyGroup, SWT.NONE);
        sampleLabel2.setText(SAMPLE_RATE);
        tandyrate = new Combo(tandyGroup, SWT.READ_ONLY);
        tandyrate.setItems(settings.getValues(Settings.PROFILE, "tandyrate"));
        tandyrate.setLayoutData(new GridData());

        final Group disneyGroup = new Group(composite_4, SWT.NONE);
        disneyGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        disneyGroup.setText("Miscellaneous");
        final GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout(gridLayout_12);

        final Label enableLabel_3 = new Label(disneyGroup, SWT.NONE);
        enableLabel_3.setText("Enable Disney Sound Source");
        disney = new Button(disneyGroup, SWT.CHECK);
        
        final Label mt32RateLabel = new Label(disneyGroup, SWT.NONE);
        mt32RateLabel.setText("MT-32 Rate");
        mt32rate = new Combo(disneyGroup, SWT.READ_ONLY);
        mt32rate.setItems(settings.getValues(Settings.PROFILE, Settings.MT32RATE));
        mt32rate.setLayoutData(new GridData());
    }

    protected void createMachineTab(final TabFolder tabFolder) {
        final TabItem machineTabItem = new TabItem(tabFolder, SWT.NONE);
        machineTabItem.setText("Machine");

        final Composite composite_3 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout(gridLayout_2);
        machineTabItem.setControl(composite_3);

        final Group cpuGroup = new Group(composite_3, SWT.NONE);
        cpuGroup.setText(Configuration.CPU);
        final GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout(gridLayout_3);

        final Label machineLabel = new Label(cpuGroup, SWT.NONE);
        machineLabel.setText(Configuration.MACHINE);
        machine = new Combo(cpuGroup, SWT.READ_ONLY);
        machine.setItems(settings.getValues(Settings.PROFILE, Configuration.MACHINE));
        machine.setLayoutData(new GridData());
        machine.setVisibleItemCount(10);
        
        final Label cputypeLabel = new Label(cpuGroup, SWT.NONE);
        cputypeLabel.setText("CPU Type");
        cpu_type = new Combo(cpuGroup, SWT.READ_ONLY);
        cpu_type.setItems(settings.getValues(Settings.PROFILE, Configuration.CPUTYPE));
        cpu_type.setLayoutData(new GridData());
        cpu_type.setVisibleItemCount(10);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);

        final Label coreLabel = new Label(cpuGroup, SWT.NONE);
        coreLabel.setText("Core");
        core = new Combo(cpuGroup, SWT.READ_ONLY);
        core.setItems(settings.getValues(Settings.PROFILE, "core"));
        core.setLayoutData(new GridData());
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);

        final Label cyclesLabel = new Label(cpuGroup, SWT.NONE);
        cyclesLabel.setText("Cycles");
        cycles = new Combo(cpuGroup, SWT.NONE);
        cycles.setItems(settings.getValues(Settings.PROFILE, "cycles"));
        cycles.setLayoutData(new GridData(100, SWT.DEFAULT));
        cycles.setVisibleItemCount(15);

        final Label upLabel = new Label(cpuGroup, SWT.NONE);
        upLabel.setLayoutData(new GridData());
        upLabel.setText("Up");
        cycles_up = new Combo(cpuGroup, SWT.NONE);
        cycles_up.setItems(settings.getValues(Settings.PROFILE, "cycles_up"));
        cycles_up.setLayoutData(new GridData(75, SWT.DEFAULT));

        final Label downLabel = new Label(cpuGroup, SWT.NONE);
        downLabel.setLayoutData(new GridData());
        downLabel.setText("Down");
        cycles_down = new Combo(cpuGroup, SWT.NONE);
        cycles_down.setItems(settings.getValues(Settings.PROFILE, "cycles_down"));
        cycles_down.setLayoutData(new GridData(75, SWT.DEFAULT));

        final Label timesynchedLabel = new Label(cpuGroup, SWT.NONE);
        timesynchedLabel.setText("Timesynched");
        timesynched = new Button(cpuGroup, SWT.CHECK);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);

        memoryGroup = new Group(composite_3, SWT.NONE);
        memoryGroup.setText("Memory");
        memoryGroup.setLayoutData(new GridData());
        final GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        memoryGroup.setLayout(gridLayout_4);

        final Label sizeLabel = new Label(memoryGroup, SWT.NONE);
        sizeLabel.setText("Size");
        memsize = new Combo(memoryGroup, SWT.READ_ONLY);
        memsize.setItems(settings.getValues(Settings.PROFILE, "memsize"));
        memsize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);

        final Label xmsLabel = new Label(memoryGroup, SWT.NONE);
        xmsLabel.setText("XMS");
        xms = new Button(memoryGroup, SWT.CHECK);
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);

        final Label emsLabel = new Label(memoryGroup, SWT.NONE);
        emsLabel.setText("EMS");
        ems = new Button(memoryGroup, SWT.CHECK);
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);

        final Label umbLabel = new Label(memoryGroup, SWT.NONE);
        umbLabel.setText("UMB");
        umb = new Combo(memoryGroup, SWT.READ_ONLY);
        umb.setItems(settings.getValues(Settings.PROFILE, "umb"));
        umb.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);
    }

    protected void createDisplayTab(final TabFolder tabFolder) {
        final TabItem displayTabItem = new TabItem(tabFolder, SWT.NONE);
        displayTabItem.setText("Display");

        final Composite composite_2 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout(gridLayout_5);
        displayTabItem.setControl(composite_2);

        final Label outputLabel = new Label(composite_2, SWT.NONE);
        outputLabel.setText("Output");
        output = new Combo(composite_2, SWT.READ_ONLY);
        output.setItems(settings.getValues(Settings.PROFILE, "output"));
        output.setVisibleItemCount(10);
        output.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label frameskipLabel = new Label(composite_2, SWT.NONE);
        frameskipLabel.setText("Frameskip");
        frameskip = new Combo(composite_2, SWT.READ_ONLY);
        frameskip.setItems(settings.getValues(Settings.PROFILE, "frameskip"));
        frameskip.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label scalerLabel = new Label(composite_2, SWT.NONE);
        scalerLabel.setText("Scaler");
        scaler = new Combo(composite_2, SWT.READ_ONLY);
        scaler.setItems(settings.getValues(Settings.PROFILE, "scaler"));
        scaler.setVisibleItemCount(15);
        scaler.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label pixelshaderLabel = new Label(composite_2, SWT.NONE);
        pixelshaderLabel.setLayoutData(new GridData());
        pixelshaderLabel.setText(Settings.PIXELSHADER);
        pixelshader = new Combo(composite_2, SWT.READ_ONLY);
        pixelshader.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        pixelshader.setVisibleItemCount(15);
        pixelshader.setItems(settings.getValues(Settings.PROFILE, Settings.PIXELSHADER));

        final Label fullscreenLabel = new Label(composite_2, SWT.NONE);
        fullscreenLabel.setText("Fullscreen");
        fullscreen = new Button(composite_2, SWT.CHECK);
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label doubleBuffLabel = new Label(composite_2, SWT.NONE);
        doubleBuffLabel.setText("Double Buffering");
        fulldouble = new Button(composite_2, SWT.CHECK);
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label resolutionLabel = new Label(composite_2, SWT.NONE);
        resolutionLabel.setText("Fullscreen Resolution");
        fullresolution = new Combo(composite_2, SWT.READ_ONLY);
        fullresolution.setItems(settings.getValues(Settings.PROFILE, "fullresolution"));
        fullresolution.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        fullresolution.setVisibleItemCount(10);

        final Label windowResLabel = new Label(composite_2, SWT.NONE);
        windowResLabel.setText("Window Resolution");
        windowresolution = new Combo(composite_2, SWT.READ_ONLY);
        windowresolution.setItems(settings.getValues(Settings.PROFILE, "windowresolution"));
        windowresolution.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        windowresolution.setVisibleItemCount(10);

        final Label aspectLabel = new Label(composite_2, SWT.NONE);
        aspectLabel.setText("Aspect Correction");
        aspect = new Button(composite_2, SWT.CHECK);
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);
        
        final Label overscanLabel = new Label(composite_2, SWT.NONE);
        overscanLabel.setText("Overscan");
        overscan = new Text(composite_2, SWT.BORDER);
        overscan.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label svgaChipsetLabel = new Label(composite_2, SWT.NONE);
        svgaChipsetLabel.setText("SVGA Chipset");
        svgachipset = new Combo(composite_2, SWT.READ_ONLY);
        svgachipset.setItems(settings.getValues(Settings.PROFILE, Settings.SVGACHIPSET));
        svgachipset.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label videoRamLabel = new Label(composite_2, SWT.NONE);
        videoRamLabel.setText("Video RAM in KB");
        videoram = new Combo(composite_2, SWT.READ_ONLY);
        videoram.setItems(settings.getValues(Settings.PROFILE, Settings.VIDEORAM));
        videoram.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label vsyncModeLabel = new Label(composite_2, SWT.NONE);
        vsyncModeLabel.setText("Vsync Mode");
        vsyncmode = new Combo(composite_2, SWT.READ_ONLY);
        vsyncmode.setItems(settings.getValues(Settings.PROFILE, Settings.VSYNCMODE));
        vsyncmode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label vsyncRateLabel = new Label(composite_2, SWT.NONE);
        vsyncRateLabel.setLayoutData(new GridData());
        vsyncRateLabel.setText("Vsync Rate");
        vsyncrate = new Text(composite_2, SWT.BORDER);
        vsyncrate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label glideLabel = new Label(composite_2, SWT.NONE);
        glideLabel.setText("Glide");
        glide = new Button(composite_2, SWT.CHECK);
        glide.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                glideport.setEnabled(glide.getSelection());
            }
        });

        final Label glidePortLabel = new Label(composite_2, SWT.NONE);
        glidePortLabel.setText("Glide port");
        glideport = new Text(composite_2, SWT.BORDER);
        glideport.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    }

    protected void createGeneralTab(final TabFolder tabFolder) {
        final TabItem generalTabItem = new TabItem(tabFolder, SWT.NONE);
        generalTabItem.setText("General");

        final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout(gridLayout_1);
        generalTabItem.setControl(composite_1);

        associationGroup = new Group(composite_1, SWT.NONE);
        associationGroup.setText("Association");
        associationGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        final GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        associationGroup.setLayout(gridLayout_4);
        
        final Label dbversionLabel = new Label(associationGroup, SWT.NONE);
        dbversionLabel.setText("Dosbox version");
        dbversion = new Combo(associationGroup, SWT.READ_ONLY);
        dbversion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        dbversion.setVisibleItemCount(10);

        setButton = new Button(associationGroup, SWT.NONE);
        setButton.setText("Set");
        setButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doLoadTemplateConf(setButton, true, false);
            }
        });
        setButton.setEnabled(false);

        dbversion.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                setButton.setEnabled(true);
            }
        });

        reloadButton = new Button(associationGroup, SWT.NONE);
        reloadButton.setText("Reload Settings");
        reloadButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doLoadTemplateConf(setButton, false, false);
            }
        });

        miscGroup = new Group(composite_1, SWT.NONE);
        miscGroup.setText("Miscellaneous");
        miscGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        final GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 3;
        miscGroup.setLayout(gridLayout_5);
        
        new Label(miscGroup, SWT.NONE);
        final Label activeLabel = new Label(miscGroup, SWT.NONE);
        activeLabel.setText("Active");
        final Label inactiveLabel = new Label(miscGroup, SWT.NONE);
        inactiveLabel.setText("Inactive");

        final Label priorityLabel = new Label(miscGroup, SWT.NONE);
        priorityLabel.setText("Priority");
        priority_active = new Combo(miscGroup, SWT.READ_ONLY);
        priority_active.setItems(settings.getValues(Settings.PROFILE, "priority_active"));
        priority_active.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
        priority_inactive = new Combo(miscGroup, SWT.READ_ONLY);
        priority_inactive.setItems(settings.getValues(Settings.PROFILE, "priority_inactive"));
        priority_inactive.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

        final Label waitOnErrorLabel = new Label(miscGroup, SWT.NONE);
        waitOnErrorLabel.setText("Wait On Error");
        waitonerror = new Button(miscGroup, SWT.CHECK);
        new Label(miscGroup, SWT.NONE);

        final Label exitLabel = new Label(miscGroup, SWT.NONE);
        exitLabel.setText("Exit afterwards");
        exit = new Button(miscGroup, SWT.CHECK);
        new Label(miscGroup, SWT.NONE);

        final Label languageFileLabel = new Label(miscGroup, SWT.NONE);
        languageFileLabel.setLayoutData(new GridData());
        languageFileLabel.setText("Language File");
        language = new Text(miscGroup, SWT.BORDER);
        language.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        
        final Label capturesLabel = new Label(miscGroup, SWT.NONE);
        capturesLabel.setLayoutData(new GridData());
        capturesLabel.setText("Captures");
        captures = new Text(miscGroup, SWT.BORDER);
        captures.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        captures.setEditable(false);
    }

    protected void createInfoTab(final TabFolder tabFolder) {
        infoTabItem = new TabItem(tabFolder, SWT.NONE);
        infoTabItem.setText("Info");

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        infoTabItem.setControl(composite);

        final Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText("Title");
        title = new Text(composite, SWT.BORDER);
        title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        
        final Label defaultLabel = new Label(composite, SWT.NONE);
        defaultLabel.setText("Default");
        defaultButton = new Button(composite, SWT.CHECK);
    }

    protected void selectSettingsByConfiguration() {
        Configuration conf = compConf.getCompositeConf();
        String priority = conf.getValue(SDL, "priority");
        String[] priorities = priority.split(",");
        if ((priorities != null) && (priorities.length >= 2)) {
            priority_active.setText(priorities[0]);
            priority_inactive.setText(priorities[1]);
        }
        setIfEnabled(conf, SDL, "waitonerror", waitonerror);
        setIfEnabled(conf, Configuration.DOSBOX, "language", language);
        setIfEnabled(conf, Configuration.DOSBOX, "captures", captures);
        setIfEnabled(conf, SDL, "output", output);
        setIfEnabled(conf, RENDER, "frameskip", frameskip);
        setIfEnabled(conf, RENDER, "scaler", scaler);
        setIfEnabled(conf, SDL, Settings.PIXELSHADER, pixelshader);
        setIfEnabled(conf, SDL, "fullscreen", fullscreen);
        setIfEnabled(conf, SDL, "fulldouble", fulldouble);
        setIfEnabled(conf, SDL, "fullresolution", fullresolution);
        setIfEnabled(conf, SDL, "windowresolution", windowresolution);
        setIfEnabled(conf, RENDER, "aspect", aspect);
        setIfEnabled(conf, SDL, "overscan", overscan);
        setIfEnabled(conf, VGA, Settings.SVGACHIPSET, svgachipset);
        setIfEnabled(conf, VGA, Settings.VIDEORAM, videoram);
        setIfEnabled(conf, VSYNC, Settings.VSYNCMODE, vsyncmode);
        setIfEnabled(conf, VSYNC, "vsyncrate", vsyncrate);
        setIfEnabled(conf, GLIDE, GLIDE, glide);
        setIfEnabled(conf, GLIDE, "port", glideport);
        setIfEnabled(conf, Configuration.DOSBOX, Configuration.MACHINE, machine);
        setIfEnabled(conf, Configuration.CPU, Configuration.CPUTYPE, cpu_type);
        setIfEnabled(conf, Configuration.CPU, "core", core);
        setIfEnabled(conf, Configuration.CPU, "cycles", cycles);
        setIfEnabled(conf, Configuration.CPU, "cycleup", cycles_up);
        setIfEnabled(conf, Configuration.CPU, "cycledown", cycles_down);
        setIfEnabled(conf, Configuration.CPU, "timesynched", timesynched);
        setIfEnabled(conf, Configuration.DOSBOX, "memsize", memsize);
        setIfEnabled(conf, DOS, "xms", xms);
        setIfEnabled(conf, DOS, "ems", ems);
        setIfEnabled(conf, DOS, "umb", umb);
        setIfEnabled(conf, MIXER, "nosound", nosound);
        setIfEnabled(conf, MIXER, Settings.RATE, rate);
        setIfEnabled(conf, MIDI, Settings.MT32RATE, mt32rate);
        setIfEnabled(conf, MIXER, "blocksize", blocksize);
        setIfEnabled(conf, MIXER, "prebuffer", prebuffer);
        setIfEnabled(conf, MIDI, "mpu401", mpu401);
        setIfEnabled(conf, MIDI, "device", device);
        setIfEnabled(conf, MIDI, "config", midi_config);
        if (conf.hasValue(Configuration.SBLASTER, Configuration.SBTYPE)) {
            setIfEnabled(conf, Configuration.SBLASTER, Configuration.SBTYPE, sbtype);
        } else {
            setIfEnabled(conf, Configuration.SBLASTER, "type", sbtype);
        }
        setIfEnabled(conf, Configuration.SBLASTER, "oplmode", oplmode);
        setIfEnabled(conf, Configuration.SBLASTER, "oplrate", oplrate);
        if (conf.hasValue(Configuration.SBLASTER, Configuration.SBBASE)) {
            setIfEnabled(conf, Configuration.SBLASTER, Configuration.SBBASE, sbbase);
        } else {
            setIfEnabled(conf, Configuration.SBLASTER, Configuration.BASE, sbbase);
        }
        setIfEnabled(conf, Configuration.SBLASTER, "irq", irq);
        setIfEnabled(conf, Configuration.SBLASTER, "dma", dma);
        setIfEnabled(conf, Configuration.SBLASTER, "hdma", hdma);
        setIfEnabled(conf, Configuration.SBLASTER, MIXER, mixer);
        setIfEnabled(conf, Configuration.GUS, Configuration.GUS, gus);
        if (conf.hasValue(Configuration.GUS, Configuration.GUSRATE)) {
            setIfEnabled(conf, Configuration.GUS, Configuration.GUSRATE, gusrate);
        } else {
            setIfEnabled(conf, Configuration.GUS, Settings.RATE, gusrate);
        }
        if (conf.hasValue(Configuration.GUS, Configuration.GUSBASE)) {
            setIfEnabled(conf, Configuration.GUS, Configuration.GUSBASE, gusbase);
        } else {
            setIfEnabled(conf, Configuration.GUS, Configuration.BASE, gusbase);
        }
        setIfEnabled(conf, Configuration.GUS, "irq1", irq1);
        setIfEnabled(conf, Configuration.GUS, "irq2", irq2);
        setIfEnabled(conf, Configuration.GUS, "dma1", dma1);
        setIfEnabled(conf, Configuration.GUS, "dma2", dma2);
        setIfEnabled(conf, Configuration.GUS, "ultradir", ultradir);
        setIfEnabled(conf, SPEAKER, "pcspeaker", pcspeaker);
        setIfEnabled(conf, SPEAKER, "pcrate", pcrate);
        setIfEnabled(conf, SPEAKER, "tandy", tandy);
        setIfEnabled(conf, SPEAKER, "tandyrate", tandyrate);
        setIfEnabled(conf, SPEAKER, "disney", disney);
        setIfEnabled(conf, SDL, "autolock", autolock);
        setIfEnabled(conf, SDL, "sensitivity", sensitivity);
        setIfEnabled(conf, SDL, "usescancodes", usescancodes);
        setIfEnabled(conf, SDL, "mapperfile", mapperfile);
        setIfEnabled(conf, DOS, "keyboardlayout", keyboard_layout);
        if (conf.hasValue(Configuration.JOYSTICK, Settings.JOYSTICKTYPE)) {
            setIfEnabled(conf, Configuration.JOYSTICK, Settings.JOYSTICKTYPE, joysticktype);
            setIfEnabled(conf, Configuration.JOYSTICK, "timed", timed);
            setIfEnabled(conf, Configuration.JOYSTICK, "autofire", autofire);
            setIfEnabled(conf, Configuration.JOYSTICK, "swap34", swap34);
            setIfEnabled(conf, Configuration.JOYSTICK, "buttonwrap", buttonwrap);
        } else {
            setIfEnabled(conf, "bios", Settings.JOYSTICKTYPE, joysticktype);
        }
        setIfEnabled(conf, SERIAL, "serial1", serial1);
        setIfEnabled(conf, SERIAL, "serial2", serial2);
        setIfEnabled(conf, SERIAL, "serial3", serial3);
        setIfEnabled(conf, SERIAL, "serial4", serial4);
        setIfEnabled(conf, IPX, IPX, ipx);
        exit.setSelection(conf.isExit());
        mixer_config.setText(conf.getMixer());
        keyb.setText(conf.getKeyb());
        mountingpoints.setItems(conf.getMountingpoints());
        dosButton.setSelection(!conf.isBooter());
        booterButton.setSelection(conf.isBooter());
    }

    protected Configuration getConfigurationBySettings() {
        Configuration base = compConf.getBaseConf();
        Configuration conf = new Configuration(compConf.getCompositeConf(), false, null, false);
        conf.updateValue(SDL, "priority", priority_active.getText() + "," + priority_inactive.getText());
        conf.updateValue(SDL, "waitonerror", String.valueOf(waitonerror.getSelection()));
        conf.updateValue(Configuration.DOSBOX, "language", language.getText());
        conf.updateValue(Configuration.DOSBOX, "captures", captures.getText());
        conf.updateValue(SDL, "output", output.getText());
        conf.updateValue(RENDER, "frameskip", frameskip.getText());
        conf.updateValue(RENDER, "scaler", scaler.getText());
        conf.updateValue(SDL, Settings.PIXELSHADER, pixelshader.getText());
        conf.updateValue(SDL, "fullscreen", String.valueOf(fullscreen.getSelection()));
        conf.updateValue(SDL, "fulldouble", String.valueOf(fulldouble.getSelection()));
        conf.updateValue(SDL, "fullresolution", fullresolution.getText());
        conf.updateValue(SDL, "windowresolution", windowresolution.getText());
        conf.updateValue(RENDER, "aspect", String.valueOf(aspect.getSelection()));
        conf.updateValue(SDL, "overscan", overscan.getText());
        conf.updateValue(VGA, Settings.SVGACHIPSET, svgachipset.getText());
        conf.updateValue(VGA, Settings.VIDEORAM, videoram.getText());
        conf.updateValue(VSYNC, Settings.VSYNCMODE, vsyncmode.getText());
        conf.updateValue(VSYNC, "vsyncrate", vsyncrate.getText());
        conf.updateValue(GLIDE, GLIDE, String.valueOf(glide.getSelection()));
        conf.updateValue(GLIDE, "port", glideport.getText());
        conf.updateValue(Configuration.DOSBOX, Configuration.MACHINE, machine.getText());
        conf.updateValue(Configuration.CPU, Configuration.CPUTYPE, cpu_type.getText());
        conf.updateValue(Configuration.CPU, "core", core.getText());
        conf.updateValue(Configuration.CPU, "cycles", cycles.getText());
        conf.updateValue(Configuration.CPU, "cycleup", cycles_up.getText());
        conf.updateValue(Configuration.CPU, "cycledown", cycles_down.getText());
        conf.updateValue(Configuration.CPU, "timesynched", String.valueOf(timesynched.getSelection()));
        conf.updateValue(Configuration.DOSBOX, "memsize", memsize.getText());
        conf.updateValue(DOS, "xms", String.valueOf(xms.getSelection()));
        conf.updateValue(DOS, "ems", String.valueOf(ems.getSelection()));
        conf.updateValue(DOS, "umb", umb.getText());
        conf.updateValue(MIXER, "nosound", String.valueOf(nosound.getSelection()));
        conf.updateValue(MIXER, Settings.RATE, rate.getText());
        conf.updateValue(MIDI, Settings.MT32RATE, mt32rate.getText());
        conf.updateValue(MIXER, "blocksize", blocksize.getText());
        conf.updateValue(MIXER, "prebuffer", prebuffer.getText());
        conf.updateValue(MIDI, "mpu401", mpu401.getText());
        conf.updateValue(MIDI, "device", device.getText());
        conf.updateValue(MIDI, "config", midi_config.getText());
        if (base.hasValue(Configuration.SBLASTER, Configuration.SBTYPE)) {
            conf.updateValue(Configuration.SBLASTER, Configuration.SBTYPE, sbtype.getText());
        } else {
            conf.updateValue(Configuration.SBLASTER, "type", sbtype.getText());
        }
        conf.updateValue(Configuration.SBLASTER, "oplmode", oplmode.getText());
        conf.updateValue(Configuration.SBLASTER, "oplrate", oplrate.getText());
        if (base.hasValue(Configuration.SBLASTER, Configuration.SBBASE)) {
            conf.updateValue(Configuration.SBLASTER, Configuration.SBBASE, sbbase.getText());
        } else {
            conf.updateValue(Configuration.SBLASTER, Configuration.BASE, sbbase.getText());
        }
        conf.updateValue(Configuration.SBLASTER, Configuration.SBBASE, sbbase.getText());
        conf.updateValue(Configuration.SBLASTER, "irq", irq.getText());
        conf.updateValue(Configuration.SBLASTER, "dma", dma.getText());
        conf.updateValue(Configuration.SBLASTER, "hdma", hdma.getText());
        conf.updateValue(Configuration.SBLASTER, MIXER, String.valueOf(mixer.getSelection()));
        conf.updateValue(Configuration.GUS, Configuration.GUS, String.valueOf(gus.getSelection()));
        if (base.hasValue(Configuration.GUS, Configuration.GUSRATE)) {
            conf.updateValue(Configuration.GUS, Configuration.GUSRATE, gusrate.getText());
        } else {
            conf.updateValue(Configuration.GUS, Settings.RATE, gusrate.getText());
        }
        if (base.hasValue(Configuration.GUS, Configuration.GUSBASE)) {
            conf.updateValue(Configuration.GUS, Configuration.GUSBASE, gusbase.getText());
        } else {
            conf.updateValue(Configuration.GUS, Configuration.BASE, gusbase.getText());
        }
        conf.updateValue(Configuration.GUS, "irq1", irq1.getText());
        conf.updateValue(Configuration.GUS, "irq2", irq2.getText());
        conf.updateValue(Configuration.GUS, "dma1", dma1.getText());
        conf.updateValue(Configuration.GUS, "dma2", dma2.getText());
        conf.updateValue(Configuration.GUS, "ultradir", ultradir.getText());
        conf.updateValue(SPEAKER, "pcspeaker", String.valueOf(pcspeaker.getSelection()));
        conf.updateValue(SPEAKER, "pcrate", pcrate.getText());
        conf.updateValue(SPEAKER, "tandy", tandy.getText());
        conf.updateValue(SPEAKER, "tandyrate", tandyrate.getText());
        conf.updateValue(SPEAKER, "disney", String.valueOf(disney.getSelection()));
        conf.updateValue(SDL, "autolock", String.valueOf(autolock.getSelection()));
        conf.updateValue(SDL, "sensitivity", sensitivity.getText());
        conf.updateValue(SDL, "usescancodes", String.valueOf(usescancodes.getSelection()));
        conf.updateValue(SDL, "mapperfile", mapperfile.getText());
        conf.updateValue(DOS, "keyboardlayout", keyboard_layout.getText());
        if (base.hasValue(Configuration.JOYSTICK, Settings.JOYSTICKTYPE)) {
            conf.updateValue(Configuration.JOYSTICK, Settings.JOYSTICKTYPE, joysticktype.getText());
            conf.updateValue(Configuration.JOYSTICK, "timed", String.valueOf(timed.getSelection()));
            conf.updateValue(Configuration.JOYSTICK, "autofire", String.valueOf(autofire.getSelection()));
            conf.updateValue(Configuration.JOYSTICK, "swap34", String.valueOf(swap34.getSelection()));
            conf.updateValue(Configuration.JOYSTICK, "buttonwrap", String.valueOf(buttonwrap.getSelection()));
        } else {
            conf.updateValue("bios", Settings.JOYSTICKTYPE, joysticktype.getText());
        }
        conf.updateValue(SERIAL, "serial1", serial1.getText());
        conf.updateValue(SERIAL, "serial2", serial2.getText());
        conf.updateValue(SERIAL, "serial3", serial3.getText());
        conf.updateValue(SERIAL, "serial4", serial4.getText());
        conf.updateValue(IPX, IPX, String.valueOf(ipx.getSelection()));
        conf.setAutoexecSettings(exit.getSelection(), mixer_config.getText(), keyb.getText(), booterButton.getSelection());
        return conf;
    }

    protected void doAddMount() {
        final EditMountDialog addMountDialog = new EditMountDialog(shell);
        try {
            addMountDialog.setDefaultDriveletter(
               Mount.getFreeDriveletter(booterButton.getSelection(), mountingpoints.getItems()));
        } catch (Exception e) {
            // nothing we can do, just take default 'C'
        }
        String mount = (String) addMountDialog.open();
        if (mount != null) {
            mountingpoints.setItems(compConf.addMount(mount));
            mountingpoints.select(mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel != -1) {
            final EditMountDialog editMountDialog = new EditMountDialog(shell);
            editMountDialog.setMount(mountingpoints.getItem(sel));
            String mount = (String) editMountDialog.open();
            if (mount != null) {
                mountingpoints.setItems(compConf.editMount(sel, mount));
                if (mountingpoints.getItemCount() == mounts) {
                    mountingpoints.select(sel);
                } else {
                    mountingpoints.select(mountingpoints.getItemCount() - 1);
                }
            }
        }
    }
    
    protected void doRemoveMount() {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) { sel = 0; mountingpoints.select(sel); }
        if (sel != -1) {
            mountingpoints.setItems(compConf.removeMount(sel));
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else {
                if (mountingpoints.getItemCount() > 0) {
                    mountingpoints.select(mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void enableSettingsByConfiguration() {
        Configuration conf = compConf.getBaseConf();
        
        if (conf.hasValue(Configuration.CPU, Configuration.CPUTYPE)) {
            machine.setItems(settings.getValues(Settings.PROFILE, "machine073"));
        } else {
            machine.setItems(settings.getValues(Settings.PROFILE, Configuration.MACHINE));
        }
        
        enableDisableControl(conf, Configuration.CPU, Configuration.CPUTYPE, cpu_type, true);
        enableDisableControl(conf, SDL, Settings.PIXELSHADER, pixelshader, true);
        enableDisableControl(conf, SDL, "overscan", overscan, true);
        enableDisableControl(conf, VGA, Settings.SVGACHIPSET, svgachipset, true);
        enableDisableControl(conf, VGA, Settings.VIDEORAM, videoram, true);
        enableDisableControl(conf, VSYNC, Settings.VSYNCMODE, vsyncmode, true);
        enableDisableControl(conf, VSYNC, "vsyncrate", vsyncrate, true);
        enableDisableControl(conf, GLIDE, GLIDE, glide, true);
        enableDisableControl(conf, GLIDE, "port", glideport, glide.getSelection());
        enableDisableControl(conf, Configuration.CPU, "timesynched", timesynched, true);
        enableDisableControl(conf, MIDI, Settings.MT32RATE, mt32rate, true);
        enableDisableControl(conf, Configuration.JOYSTICK, "timed", timed, true);
        enableDisableControl(conf, Configuration.JOYSTICK, "autofire", autofire, true);
        enableDisableControl(conf, Configuration.JOYSTICK, "swap34", swap34, true);
        enableDisableControl(conf, Configuration.JOYSTICK, "buttonwrap", buttonwrap, true);
        enableDisableControl(conf, DOS, "keyboardlayout", keyboard_layout, true);
    }

    protected void doLoadTemplateConf(final Button setButton, final boolean keepValues, final boolean isTemplate) {
        compConf.setCompositeConf(getConfigurationBySettings());
        CompositeConfiguration newCompConf = obtainNewConf(keepValues, isTemplate);
        
        if (newCompConf.getCompositeConf() == null) {
            GeneralPurposeDialogs.infoMessage(shell, "Could not load settings, so nothing was changed.");
        } else {
            compConf = newCompConf;
            enableSettingsByConfiguration();
            selectSettingsByConfiguration();
            setButton.setEnabled(false);
        }
    }
    
    protected CompositeConfiguration obtainNewConf(final boolean keepValues, final boolean isTemplate) {
        return new CompositeConfiguration(compConf,
                dbversionsList.get(dbversion.getSelectionIndex()), keepValues, true, shell);
    }
    
    protected static void enableDisableControl(final Configuration dbConf, final String section, final String item,
            final Control control, final boolean extraCondition) {
        control.setEnabled(dbConf.hasValue(section, item) && extraCondition);
    }
    
    protected static void setIfEnabled(final Configuration conf, final String section, final String item, final Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                ((Text)control).setText(conf.getValue(section, item));
            } else if (control instanceof Combo) {
                ((Combo)control).setText(conf.getValue(section, item));
            } else if (control instanceof Button) {
                ((Button)control).setSelection(conf.getBooleanValue(section, item));
            }
        }
    }
    
    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a template title", title, infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(shell);
    }
}
