package com.model;

import java.util.List;


public class KeyTitleDefault extends KeyValuePair {

    private boolean defaultChoice;


    public KeyTitleDefault(final int id, final String value, final boolean isDefault) {
        super(id, value);
        this.defaultChoice = isDefault;
    }

    public String getTitle() {
        return getValue();
    }

    public boolean isDefault() {
        return defaultChoice;
    }

    public String isDefaultString() {
        return defaultChoice ? "Yes": "No";
    }

    public void toggleDefault() {
        defaultChoice = !defaultChoice;
    }

    public static <T extends KeyTitleDefault> int findDefault(final List<T> list) {
        int result = 0;
        for (T element: list) {
            if (element.defaultChoice) {
                return result;
            }
            result++;
        }
        return -1; // no default found
    }
}
