package com.model;

import java.io.File;
import com.util.FileUtils;


public class Profile extends KeyTitleDefault {

    private String developerName;
    private String publisherName;
    private String genre;
    private String year;
    private int dbversionId;
    private String setup;
    private String setupParams;
    private String notes;
    private String[] link;
    private String status;
    private String confPathAndFile;
    private String captures;
    private String[] customString;
    private int[] customInt;


    public Profile(final int id, final String title, final String devName, final String publName, final String genre, final String year,
            final int dbversionId, final String setup, final String setupParams, final String notes, final String link1, final String link2,
            final boolean favorite, final String status, final String confPathAndFile, final String captures,
            final String link3, final String link4, final String cust1, final String cust2,
            final String cust3, final String cust4, final String cust5, final String cust6,
            final String cust7, final String cust8, final int cust9, final int cust10) {
        super(id, title, favorite);
        this.developerName = devName;
        this.publisherName = publName;
        this.genre = genre;
        this.year = year;
        this.dbversionId = dbversionId;
        this.setup = setup;
        this.setupParams = setupParams;
        this.notes = notes;
        this.status = status;
        this.confPathAndFile = confPathAndFile;
        this.captures = captures;
        this.link = new String[] { link1, link2, link3, link4 };
        this.customString = new String[] { cust1, cust2, cust3, cust4, cust5, cust6, cust7, cust8 };
        this.customInt = new int[] { cust9, cust10 };
    }

    public Profile(final int id, final String confFile, final String captures, final Profile prof) {
        this(id, prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(),
                prof.getDbversionId(), prof.getSetup(), prof.getSetupParameters(), prof.getNotes(), prof.getLink(0),
                prof.getLink(1), prof.isDefault(), prof.getStatus(), confFile, captures, prof.getLink(2),
                prof.getLink(3), prof.getCustomString(0), prof.getCustomString(1), prof.getCustomString(2),
                prof.getCustomString(3), prof.getCustomString(4), prof.getCustomString(5), prof.getCustomString(6),
                prof.getCustomString(7), prof.getCustomInt(0), prof.getCustomInt(1));
    }

    public String getDeveloperName() {
        return developerName;
    }

    public String getGenre() {
        return genre;
    }

    public String getPublisherName() {
        return publisherName;
    }

    public String getYear() {
        return year;
    }

    public int getDbversionId() {
        return dbversionId;
    }

    public boolean hasSetup() {
        return !"".equals(setup);
    }

    public String hasSetupString() {
        return hasSetup() ? "Yes": "No";
    }

    public String[] getLinks() {
        return link.clone();
    }

    public String getLink(final int index) {
        return link[index];
    }

    public String getNotes() {
        return notes;
    }

    public String getSetup() {
        return setup;
    }

    public String getSetupParameters() {
        return setupParams;
    }

    public String getStatus() {
        return status;
    }

    public String getConfPathAndFile() {
        return confPathAndFile;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToData(confPathAndFile);
    }

    public String getCaptures() {
        return captures;
    }

    public File getCanonicalCaptures() {
        return FileUtils.canonicalToData(captures);
    }

    public String getCustomString(final int index) {
        return customString[index];
    }

    public int getCustomInt(final int index) {
        return customInt[index];
    }
}
