package com.model.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import com.exception.InvalidMountstringException;
import com.model.Mount;
import com.util.FileUtils;
import com.util.PlatformUtils;


final class Autoexec {

    List<Mount> mountingpoints;
    boolean loadfix;
    int loadfixValue;
    String main;
    String img1;
    String img2;
    boolean exit;
    String params;
    String mixer;
    String keyb;


    Autoexec(final Autoexec other) {
        mountingpoints = new ArrayList<Mount>(other.mountingpoints);
        loadfix = other.loadfix;
        loadfixValue = other.loadfixValue;
        main = other.main;
        img1 = other.img1;
        img2 = other.img2;
        exit = other.exit;
        params = other.params;
        mixer = other.mixer;
        keyb = other.keyb;
    }
    
    Autoexec(final String[] orgLines) {
        parseLines(orgLines, true);
    }

    void init() {
        mountingpoints = new ArrayList<Mount>();
        loadfix = false;
        loadfixValue = 0;
        main = "";
        img1 = "";
        img2 = "";
        exit = false;
        params = "";
        mixer = "";
        keyb = "";
    }

    Autoexec(final List<Mount> mountingpoints, final Autoexec baseMounts, final boolean switchDbversion) {
        init();
        exit = true;
        if (switchDbversion) {
            int start = baseMounts == null? 0: baseMounts.mountingpoints.size();
            for (int i = start; i < mountingpoints.size(); i++) {
                this.mountingpoints.add(new Mount(mountingpoints.get(i)));
            }
        } else {
            int max = baseMounts == null? 0: baseMounts.mountingpoints.size();
            for (int i = 0; i < mountingpoints.size(); i++) {
                if (i >= max || !mountingpoints.get(i).equals(baseMounts.mountingpoints.get(i))) {
                    this.mountingpoints.add(new Mount(mountingpoints.get(i)));
                }
            }
        }
    }

    void parseLines(final String[] orgLines, final boolean init) {
        if (init) {
            init();
        }
        if (orgLines.length == 0) {
            return;
        }

        char driveletter = '\0';
        char imgdriveletter1 = '\0';
        char imgdriveletter2 = '\0';
        String remainder = "";
        String executable = "";
        String image1 = "";
        String image2 = "";
        int exeIndex = -1;

        for (String orgLine: orgLines) {
            String line = orgLine.toLowerCase();
            if (line.startsWith("mount") || line.startsWith("imgmount")) {
                addMount(orgLine);
            } else if (line.endsWith(":") && line.length() == 2) {
                driveletter = line.charAt(0);
            } else if (line.startsWith("cd\\")) {
                remainder = PlatformUtils.toNativePath(orgLine).substring(2);
            } else if (line.startsWith("cd ")) {
                remainder = PlatformUtils.toNativePath(orgLine).substring(3);
            } else if (line.startsWith("keyb ") || line.startsWith("keyb.com ")) {
                keyb = orgLine.substring(line.indexOf(' ') + 1);
            } else if (line.startsWith("mixer ") || line.startsWith("mixer.com ")) {
                mixer = orgLine.substring(line.indexOf(' ') + 1);
            } else if ((exeIndex = line.indexOf(FileUtils.EXECUTABLES[0])) != -1
                    || (exeIndex = line.indexOf(FileUtils.EXECUTABLES[1])) != -1
                    || (exeIndex = line.indexOf(FileUtils.EXECUTABLES[2])) != -1) {
                executable = orgLine;
                // If there is a space BEFORE executable name, strip everything before it
                int spaceBeforeIndex = executable.lastIndexOf(' ', exeIndex);
                if (spaceBeforeIndex != -1) {
                    executable = executable.substring(spaceBeforeIndex + 1);
                }
                // If there is a space AFTER executable name, define it as being parameters
                int spaceAfterIndex = executable.indexOf(' ');
                if (spaceAfterIndex != -1) {
                    params = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
                    executable = executable.substring(0, spaceAfterIndex);
                }
            } else if (line.startsWith("boot ")) {
                int spaceIndex = line.indexOf(' ', 5);
                if (spaceIndex == -1) {
                    spaceIndex = line.length();
                } else {
                    imgdriveletter2 = line.charAt(spaceIndex + 1);
                    image2 = PlatformUtils.toNativePath(orgLine).substring(spaceIndex + 3);
                }
                imgdriveletter1 = line.charAt(5);
                image1 = PlatformUtils.toNativePath(orgLine).substring(7, spaceIndex);
                if (imgdriveletter1 == '\\' && "ile".equals(image1)) {
                    img1 = "file"; // for template if . was unavailable
                }
            } else if (line.startsWith("exit")) {
                exit = true;
            }

            if (line.startsWith("loadfix -") && !line.startsWith("loadfix -f")) {
                loadfix = true;
                int endIndex = line.indexOf(' ', 9);
                if (endIndex == -1) {
                    endIndex = line.length();
                }
                try {
                    this.loadfixValue = Integer.parseInt(line.substring(9, endIndex));
                } catch (NumberFormatException e) {
                    this.loadfixValue = 0;
                }
            }
        }

        for (Mount mount: mountingpoints) {
            char mount_drive = mount.getDriveletter();
            String mountPath = mount.getHostPathAsString();
            if (Character.toUpperCase(driveletter) == mount_drive) {
                main = FileUtils.sanitizeToDosroot(mountPath + remainder + File.separatorChar + executable);
            } else {
                if (Character.toUpperCase(imgdriveletter1) == mount_drive) {
                    img1 = FileUtils.sanitizeToDosroot(mountPath + image1);
                }
                if (Character.toUpperCase(imgdriveletter2) == mount_drive) {
                    img2 = FileUtils.sanitizeToDosroot(mountPath + image2);
                }
            }
        }
    }

    String getString(final List<Mount> baseMounts) {
        StringBuffer result = new StringBuffer();
        
        if (!"".equals(keyb)) {
            result.append("keyb.com ").append(keyb).append(PlatformUtils.EOLN);
        }
        if (!"".equals(mixer)) {
            result.append("mixer.com ").append(mixer).append(PlatformUtils.EOLN);
        }
        
        List<Mount> shortList;
        if (baseMounts == null) {
            shortList = mountingpoints;
        } else {
            shortList = new ArrayList<Mount>();
            for (int i = 0; i < mountingpoints.size(); i++) {
                if (i >= baseMounts.size() || !mountingpoints.get(i).equals(baseMounts.get(i))) {
                    shortList.add(mountingpoints.get(i));
                }
            }
        }
        for (Mount mount: shortList) {
            result.append(mount.toString()).append(PlatformUtils.EOLN);
        }
        if (!"".equals(main)) {

            String[] dosboxLocation = convertToDosboxPath(main);
            result.append(dosboxLocation[0] + PlatformUtils.EOLN); // move to drive
            result.append("cd \\" + dosboxLocation[1] + PlatformUtils.EOLN); // move to dir
            if (loadfix) {
                result.append("loadfix -").append(loadfixValue).append(PlatformUtils.EOLN);
            }
            if (dosboxLocation[2].toLowerCase().endsWith(FileUtils.EXECUTABLES[2])) {
                result.append("call ");
            }
            result.append(dosboxLocation[2]);

            if (!"".equals(params)) {
                result.append(' ').append(params);
            }

            if (loadfix) {
                result.append(PlatformUtils.EOLN).append("loadfix -f");
            }
            if (exit) {
                result.append(PlatformUtils.EOLN).append("exit");
            }

        } else if (!"".equals(img1)) {

            if (loadfix) { 
                result.append("loadfix -").append(loadfixValue).append(PlatformUtils.EOLN);
            }
            String[] dosboxLocation = convertToDosboxPath(img1);
            result.append("boot ").append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
            if (!dosboxLocation[1].equals("")) {
                result.append('\\');
            }
            result.append(dosboxLocation[2]);
            if (!"".equals(img2)) {
                dosboxLocation = convertToDosboxPath(img2);
                result.append(' ').append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                if (!dosboxLocation[1].equals("")) {
                    result.append('\\');
                }
                result.append(dosboxLocation[2]);
            }
            if (loadfix) {
                result.append(PlatformUtils.EOLN).append("loadfix -f");
            }

        } else {

            // a template
            if (exit) {
                result.append("exit");
            }

        }

        return result.toString();
    }
    
    String[] convertToDosboxPath(final String hostFileLocation) {
        File hostFile = new File(hostFileLocation);
        String[] result = { "", "", hostFile.getName() };
        int maxLengthMount = 0;
        for (Mount mount: mountingpoints) {
            File dosboxDir = mount.canBeUsedFor(hostFile);
            if (dosboxDir != null && (mount.getPathAsString().length() > maxLengthMount)) {
                result[0] = mount.getDriveletter() + ":";
                result[1] = (dosboxDir.getParent() == null) ? "": dosboxDir.getParent();
                maxLengthMount = mount.getPathAsString().length();
            }
        }
        // translate *nix paths to dosbox paths
        result[1] = PlatformUtils.toDosboxPath(result[1]);
        return result;
    }

    void addMount(final String mount) {
        try {
            Mount mnt = new Mount(mount);
            if (mnt.isUnmounted()) {
                for (Mount m: mountingpoints) {
                    if (m.getDriveletter() == mnt.getDriveletter()) {
                        m.toggleMount();
                        break;
                    }
                }
            } else {
                mountingpoints.add(mnt);
            }
        } catch (InvalidMountstringException e) {
            // nothing we can do
        }
    }
}
