package com.model.conf;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import com.util.PlatformUtils;


final class Section {
    
    final Map<String, String> items;


    Section() {
        items = new LinkedHashMap<String, String>();
    }

    Section(final Section sec) {
        this();
        for (String key: sec.items.keySet()) {
            items.put(new String(key), new String(sec.items.get(key)));
        }
    }
    
    void substract(final Section sec) {
        for (String key: sec.items.keySet()) {
            if (items.containsKey(key)) {
                String value = sec.items.get(key);
                String thisvalue = items.get(key);
                if (thisvalue.equals(value)) {
                    items.remove(key);
                }
            }
        }
    }

    String toString(final boolean ordered) {
        StringBuffer result = new StringBuffer();
        Set<String> keys = ordered ? new TreeMap<String, String>(items).keySet(): items.keySet();
        for (String key: keys) {
            result.append(key).append('=');
            result.append(items.get(key)).append(PlatformUtils.EOLN);
        }
        return result.toString();
    }
}
