package com.gui;

import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import com.model.KeyValuePair;


public final class AutoSelectCombo {

	private final Combo combo;
	private final List<KeyValuePair> possibleValues;
    private int currentLength;
    private boolean mutex;
    
	
	public AutoSelectCombo(final Composite composite, final int style, final List<KeyValuePair> possibleValues) {
		combo = new Combo(composite, style);
		this.possibleValues = possibleValues;
        for (KeyValuePair val: this.possibleValues) {
            this.add(val.getValue());
        }
        currentLength = 0;
        mutex = false;
		
		combo.addModifyListener(new ModifyListener() {
			public void modifyText(final ModifyEvent event) {
				if (!mutex) {
					int index = indexOfClosestMatch(combo.getText());
					int newLength = combo.getText().length();
					if ((newLength > currentLength) && (index != -1)) {
						mutex = true;
						combo.setText(combo.getText() + combo.getItem(index).substring(newLength));
						combo.setSelection(new Point(newLength, combo.getText().length()));
						mutex = false;
					}
					currentLength = newLength;
				}
			}
		});
	}

	public void setLayoutData(final Object arg0) {
		combo.setLayoutData(arg0);
	}

	public void setVisibleItemCount(final int arg0) {
		combo.setVisibleItemCount(arg0);
	}

	public void add(final String arg0) {
		combo.add(arg0);
	}

	public String getText() {
		return combo.getText();
	}

	public void select(final int arg0) {
		combo.select(arg0);
	}

	public void setText(final String arg0) {
		combo.setText(arg0);
		currentLength = combo.getText().length();
	}

	public int getKey() {
		int index = combo.indexOf(combo.getText());
		return (index == -1)? index: possibleValues.get(index).getId();
	}
	
	public int getSelectionIndex() {
		return combo.getSelectionIndex();
	}

	public int indexOf(final String arg0) {
		return combo.indexOf(arg0);
	}

	public int indexOfClosestMatch(final String text) {
		for (int i = 0; i < combo.getItemCount(); i++) {
			if (combo.getItem(i).toLowerCase().startsWith(text.toLowerCase())) {
				return i;
			}
		}
		return -1;
	}
}