package com.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import com.model.Settings;
import com.util.StringUtils;


public final class GeneralPurposeDialogs {

    private static List<String> errorMessages;
    private static Control wgt;
    private static TabItem tab;


    public static void fatalMessage(final Shell shell, final String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_ERROR | SWT.OK);
            messageBox.setText(Settings.getInstance().msg("general.fatalerror"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        } else {
            System.out.println(Settings.getInstance().msg("general.fatalerror") + ": " + theMessage);
        }
    }

    public static void warningMessage(final Shell shell, final String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_WARNING | SWT.OK);
            messageBox.setText(Settings.getInstance().msg("general.warning"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        } else {
            System.out.println(Settings.getInstance().msg("general.warning") + ": " + theMessage);
        }
    }

    public static void infoMessage(final Shell shell, final String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_INFORMATION | SWT.OK);
            messageBox.setText(Settings.getInstance().msg("general.information"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        } else {
            System.out.println(Settings.getInstance().msg("general.information") + ": " + theMessage);
        }
    }

    public static boolean confirmMessage(final Shell shell, final String theMessage) {
        MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_WARNING | SWT.YES | SWT.NO);
        messageBox.setText(Settings.getInstance().msg("general.confirmation"));
        messageBox.setMessage(theMessage);
        return messageBox.open() == SWT.YES;
    }

    public static void initErrorDialog() {
        errorMessages = new ArrayList<String>();
        wgt = null;
        tab = null;
    }

    public static void addError(final String msg, final Control widget) {
        addError(msg, widget, null);
    }

    public static void addError(final String msg, final Control widget, final TabItem tabItem) {
        if (errorMessages.isEmpty()) {
            wgt = widget;
            tab = tabItem;
        }
        errorMessages.add(msg);
    }

    public static boolean displayErrorDialog(final Shell shell) {
        boolean errors = !errorMessages.isEmpty();
        if (errors) {
            if (tab != null) {
                TabFolder folder = tab.getParent();
                folder.setSelection(tab);
            }
            infoMessage(shell, StringUtils.stringArrayToString(errorMessages.toArray(new String[errorMessages.size()]), "\n"));
            wgt.setFocus();
        }
        return errors;
    }
}
