package com.gui;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import com.exception.InvalidMountstringException;
import com.model.Mount;
import com.model.Settings;


public final class GrabButton {

	private final Button button;

	
	public GrabButton(final Composite composite, final int style) {
		button = new Button(composite, style);
		button.setText(Settings.getInstance().msg("button.grab"));
	}
	
	public void connect(final Text text, final List source) {
		button.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent event) {
    		int index = source.getSelectionIndex();
    		if (index != -1) {
                try {
                    text.setText(new Mount(source.getItem(index)).getPathAsString() + File.separatorChar);
                    text.selectAll();
                    text.setFocus();
                } catch (InvalidMountstringException e1) {
                    // nothing we can do
                }
    		}
    	}
    });
	}
}
