package com.gui;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.eclipse.swt.widgets.Shell;
import com.db.Database;
import com.model.DosboxVersion;
import com.model.Settings;


public final class SendToProfile extends Shell {

    private static final String LOCALHOST = "localhost";


    public static void main(final String args[]) {
        if (args.length < 1) {
            System.out.println(Settings.getInstance().msg("external.notice.addcmdusage"));
            System.exit(1);
        }

        try {

            Settings settings = Settings.getInstance();
            Socket socket = new Socket(LOCALHOST, settings.getIntValue("communication", "port"));
            new PrintWriter(socket.getOutputStream(), true).println("sendtoprofile " + args[0]);
            socket.close();

        } catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(1);
        } catch (IOException e) {
            openDialogMyself(args[0]);
        }
    }

    private static void openDialogMyself(final String file) {
        Database dbase = Database.getInstance();

        Shell shell = new Shell();
        shell.setMinimized(true);
        shell.open();

        try {
            java.util.List<DosboxVersion> dbversionsList = dbase.readDosboxVersionsList();
            if (DosboxVersion.findDefault(dbversionsList) == -1) {
                GeneralPurposeDialogs.infoMessage(shell, Settings.getInstance().msg("dialog.main.required.defaultdosboxversion"));
                try {
                    dbase.shutdown();
                } catch (SQLException e) {
                    // nothing we can do
                }
                return;
            }

            EditProfileDialog editProfDialog = new EditProfileDialog(shell);
            editProfDialog.sendToProfile(file);
            editProfDialog.open();
        } catch (SQLException e1) {
            GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
        }

        try {
            dbase.shutdown();
        } catch (SQLException e) {
            // nothing we can do
        }
    }
}
