package com.gui;

import java.util.Arrays;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import com.model.Settings;
import com.model.conf.Configuration;
import swing2swt.layout.BorderLayout;


public class SettingsDialog extends Dialog {

    private static final java.util.List<String> SUPPORTED_LANGUAGES =
        Arrays.asList("en", "es", "nl", "zh", "zh_TW");
    
    private static final int EDITABLE_COLUMN = 0;

    public final static String[] confLocations = {
        Settings.getInstance().msg("dialog.settings.confindbgldir"), 
        Settings.getInstance().msg("dialog.settings.confingamedir") };
    public final static String[] confFilenames = {
        Settings.getInstance().msg("dialog.settings.conffilebyid"),
        Settings.getInstance().msg("dialog.settings.conffilebytitle") };

    private Table visible_columns;
    private boolean changedVisColumns = false;
    private TableItem[] visibleColumns;
    private TabItem columnsTabItem;
    private Combo confFilename;
    private Combo confLocation;
    private Combo localeCombo;
    private Text port;
    private Label heightValue;
    private Scale screenshotsHeight;
    private int previousSelection = -1;
    private Text values;
    private Configuration conf;
    private List options;
    protected Object result;
    protected Shell shell;
    private Settings settings;


    public SettingsDialog(final Shell parent, final int style) {
        super(parent, style);
    }

    public SettingsDialog(final Shell parent) {
        this(parent, SWT.NONE);
    }

    public Object open() {
        settings = Settings.getInstance();
        conf = new Configuration(settings, false, null, false);
        createContents();
        shell.open();
        shell.layout();
        Display display = getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
        result = changedVisColumns;
        return result;
    }

    protected void createContents() {
        shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
        shell.setLayout(new BorderLayout(0, 0));
        shell.setSize(600, 375);
        shell.setText(settings.msg("dialog.settings.title"));

        final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

        final TabItem generalTabItem = new TabItem(tabFolder, SWT.NONE);
        generalTabItem.setText(settings.msg("dialog.settings.tab.general"));

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        composite.setLayout(new GridLayout());
        generalTabItem.setControl(composite);

        final Group dosboxGroup = new Group(composite, SWT.NONE);
        dosboxGroup.setText(settings.msg("dialog.settings.dosbox"));
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dosboxGroup.setLayout(gridLayout);

        final Label showConsoleLabel = new Label(dosboxGroup, SWT.NONE);
        showConsoleLabel.setText(settings.msg("dialog.settings.hidestatuswindow"));

        final Button console = new Button(dosboxGroup, SWT.CHECK);
        console.setSelection(conf.getBooleanValue("dosbox", "hideconsole"));

        final Group sendToGroup = new Group(composite, SWT.NONE);
        sendToGroup.setText(settings.msg("dialog.settings.sendto"));
        final GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        sendToGroup.setLayout(gridLayout_2);

        final Label enableCommLabel = new Label(sendToGroup, SWT.NONE);
        enableCommLabel.setText(settings.msg("dialog.settings.enableport"));

        final Button portEnabled = new Button(sendToGroup, SWT.CHECK);
        portEnabled.setSelection(conf.getBooleanValue("communication", "port_enabled"));
        portEnabled.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                port.setEnabled(portEnabled.getSelection());
            }
        });

        final Label portnumberLabel = new Label(sendToGroup, SWT.NONE);
        portnumberLabel.setText(settings.msg("dialog.settings.port"));

        port = new Text(sendToGroup, SWT.BORDER);
        port.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        port.setText(conf.getValue("communication", "port"));
        port.setEnabled(portEnabled.getSelection());

        final Group profileDefGroup = new Group(composite, SWT.NONE);
        profileDefGroup.setText(settings.msg("dialog.settings.profiledefaults"));
        final GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        profileDefGroup.setLayout(gridLayout_3);

        final Label configFileLabel = new Label(profileDefGroup, SWT.NONE);
        configFileLabel.setText(settings.msg("dialog.settings.configfile"));

        confLocation = new Combo(profileDefGroup, SWT.READ_ONLY);
        confLocation.setItems(confLocations);
        confLocation.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        confLocation.select(conf.getIntValue("profiledefaults", "confpath"));

        confFilename = new Combo(profileDefGroup, SWT.READ_ONLY);
        confFilename.setItems(confFilenames);
        confFilename.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        confFilename.select(conf.getIntValue("profiledefaults", "conffile"));

        final Group i18nGroup = new Group(composite, SWT.NONE);
        i18nGroup.setText(settings.msg("dialog.settings.i18n"));
        final GridLayout gridLayout_30 = new GridLayout();
        gridLayout_30.numColumns = 2;
        i18nGroup.setLayout(gridLayout_30);

        final Label languageLabel = new Label(i18nGroup, SWT.NONE);
        languageLabel.setText(settings.msg("dialog.settings.languagecountry"));

        localeCombo = new Combo(i18nGroup, SWT.READ_ONLY);
        Locale locale = new Locale(settings.getValue("locale", "language"), settings.getValue("locale", "country"));
        final SortedMap<String, Locale> locales = new TreeMap<String, Locale>();
        String locString = "";
        for (Locale loc: Locale.getAvailableLocales()) {
            if (SUPPORTED_LANGUAGES.isEmpty() || SUPPORTED_LANGUAGES.contains(loc.toString())) {
                StringBuffer s = new StringBuffer(loc.getDisplayLanguage(Locale.getDefault()));
                if (loc.getCountry().length() > 0)
                    s.append(" - ").append(loc.getDisplayCountry(Locale.getDefault()));
                locales.put(s.toString(), loc);
                if (loc.equals(locale)) {
                    locString = s.toString();
                }
            }
        }
        for (String sloc: locales.keySet()) {
            localeCombo.add(sloc);
        }
        localeCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        localeCombo.setText(locString);
        
        columnsTabItem = new TabItem(tabFolder, SWT.NONE);
        columnsTabItem.setText(settings.msg("dialog.settings.tab.profiletable"));

        final Composite composite2 = new Composite(tabFolder, SWT.NONE);
        composite2.setLayout(new BorderLayout(0, 0));
        columnsTabItem.setControl(composite2);

        final Group visColumnsGroup = new Group(composite2, SWT.NONE);
        visColumnsGroup.setLayout(new FillLayout());
        visColumnsGroup.setText(settings.msg("dialog.settings.visiblecolunms"));

        visible_columns = new Table(visColumnsGroup, SWT.FULL_SELECTION | SWT.BORDER | SWT.CHECK);
        visible_columns.setLinesVisible(true);

        TableColumn column1 = new TableColumn(visible_columns, SWT.NONE);
        column1.setWidth(350);

        visibleColumns = new TableItem[MainWindow.columnNames.length];

        for (int i = 0; i < MainWindow.columnNames.length; i++) {
            visibleColumns[i] = new TableItem(visible_columns, SWT.BORDER);
            visibleColumns[i].setText(MainWindow.columnNames[i]);
            visibleColumns[i].setChecked(conf.getBooleanValue("gui", "column" + (i + 1) + "visible"));
        }

        final TableEditor editor = new TableEditor(visible_columns);
        editor.horizontalAlignment = SWT.LEFT;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;

        visible_columns.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                // Clean up any previous editor control
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }

                // Identify the selected row
                TableItem item = (TableItem) event.item;
                if (item == null) {
                    return;
                }
                if (item.getParent().getSelectionIndex() < MainWindow.RO_COLUMN_NAMES) {
                    return;
                }

                // The control that will be the editor must be a child of the table
                Text newEditor = new Text(visible_columns, SWT.NONE);
                newEditor.setText(item.getText(EDITABLE_COLUMN));
                newEditor.addModifyListener(new ModifyListener() {
                    public void modifyText(final ModifyEvent mEvent) {
                        Text text = (Text) editor.getEditor();
                        editor.getItem().setText(EDITABLE_COLUMN, text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor(newEditor, item, EDITABLE_COLUMN);
            }
        });

        final Group addProfGroup = new Group(composite2, SWT.NONE);
        final GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 2;
        addProfGroup.setLayout(gridLayout_4);
        addProfGroup.setText(settings.msg("dialog.settings.addeditduplicateprofile"));
        addProfGroup.setLayoutData(BorderLayout.SOUTH);

        final Label autoSortLabel = new Label(addProfGroup, SWT.NONE);
        autoSortLabel.setText(settings.msg("dialog.settings.autosort"));

        final Button autosort = new Button(addProfGroup, SWT.CHECK);
        autosort.setSelection(conf.getBooleanValue("gui", "autosortonupdate"));

        final TabItem dynTabItem = new TabItem(tabFolder, SWT.NONE);
        dynTabItem.setText(settings.msg("dialog.settings.tab.dynamicoptions"));

        final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
        composite_1.setLayout(new FillLayout());
        dynTabItem.setControl(composite_1);

        final Group dynOptionsGroup = new Group(composite_1, SWT.NONE);
        final GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        dynOptionsGroup.setLayout(gridLayout_1);
        dynOptionsGroup.setText(settings.msg("dialog.settings.dynamicoptions"));

        final Label optionsLabel = new Label(dynOptionsGroup, SWT.NONE);
        optionsLabel.setText(settings.msg("dialog.settings.options"));

        final Label valuesLabel = new Label(dynOptionsGroup, SWT.NONE);
        valuesLabel.setText(settings.msg("dialog.settings.values"));

        options = new List(dynOptionsGroup, SWT.V_SCROLL | SWT.BORDER);
        options.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                storeValues();
                previousSelection = options.getSelectionIndex();
                values.setText(conf.getMultilineValues("profile", options.getItem(previousSelection), values.getLineDelimiter()));
            }
        });
        options.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        for (String s: conf.getItems("profile")) {
            options.add(s);
        }

        values = new Text(dynOptionsGroup, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL);
        values.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

        final Composite composite_7 = new Composite(shell, SWT.NONE);
        composite_7.setLayout(new RowLayout());
        composite_7.setLayoutData(BorderLayout.SOUTH);

        final TabItem guiTabItem = new TabItem(tabFolder, SWT.NONE);
        guiTabItem.setText(settings.msg("dialog.settings.tab.gui"));
        Composite composite1 = new Composite(tabFolder, SWT.NONE);
        GridLayout composite1Layout = new GridLayout();
        composite1Layout.makeColumnsEqualWidth = true;
        composite1.setLayout(composite1Layout);
        guiTabItem.setControl(composite1);
        Group screenshots = new Group(composite1, SWT.NONE);
        GridLayout screenshotsLayout = new GridLayout();
        screenshotsLayout.numColumns = 3;
        screenshots.setLayout(screenshotsLayout);
        GridData screenshotsLData = new GridData();
        screenshotsLData.grabExcessHorizontalSpace = true;
        screenshotsLData.horizontalAlignment = GridData.FILL;
        screenshots.setLayoutData(screenshotsLData);
        screenshots.setText(settings.msg("dialog.settings.screenshots"));
        Label heightLabel = new Label(screenshots, SWT.NONE);
        heightLabel.setText(settings.msg("dialog.settings.height"));
        screenshotsHeight = new Scale(screenshots, SWT.NONE);
        screenshotsHeight.setMaximum(750);
        screenshotsHeight.setMinimum(50);
        GridData sshotsHeightData = new GridData();
        sshotsHeightData.grabExcessHorizontalSpace = true;
        sshotsHeightData.horizontalAlignment = GridData.FILL;
        screenshotsHeight.setLayoutData(sshotsHeightData);
        screenshotsHeight.setIncrement(25);
        screenshotsHeight.setPageIncrement(100);
        screenshotsHeight.setSelection(conf.getIntValue("gui", "screenshotsheight"));
        screenshotsHeight.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent evt) {
                heightValue.setText(screenshotsHeight.getSelection() + settings.msg("dialog.settings.px"));
                heightValue.pack();
            }
        });
        heightValue = new Label(screenshots, SWT.NONE);
        heightValue.setText(screenshotsHeight.getSelection() + settings.msg("dialog.settings.px"));

        final Button okButton = new Button(composite_7, SWT.NONE);
        okButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (!isValid()) {
                    return;
                }

                for (int i = 0; i < MainWindow.columnNames.length; i++) {
                    if (conf.getBooleanValue("gui", "column" + (i + 1) + "visible") != visibleColumns[i].getChecked()) {
                        changedVisColumns = true;
                    }
                }
                for (int i = 0; i < MainWindow.EDIT_COLUMN_NAMES; i++) {
                    if (!MainWindow.columnNames[i + MainWindow.RO_COLUMN_NAMES].equals(
                                 visibleColumns[i + MainWindow.RO_COLUMN_NAMES].getText())) {
                        changedVisColumns = true;
                    }
                }
                if (changedVisColumns) {
                    resetColumnSettings();
                }

                conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                conf.setValue("communication", "port", port.getText());
                conf.setIntValue("profiledefaults", "confpath", confLocation.getSelectionIndex());
                conf.setIntValue("profiledefaults", "conffile", confFilename.getSelectionIndex());
                conf.setValue("locale", "language", locales.get(localeCombo.getText()).getLanguage());
                conf.setValue("locale", "country", locales.get(localeCombo.getText()).getCountry());
                for (int i = 0; i < MainWindow.columnNames.length; i++) {
                    conf.setBooleanValue("gui", "column" + (i + 1) + "visible", visibleColumns[i].getChecked());
                }
                conf.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
                for (int i = 0; i < MainWindow.EDIT_COLUMN_NAMES; i++) {
                    conf.setValue("gui", "custom" + (i + 1),
                            visibleColumns[i + MainWindow.RO_COLUMN_NAMES].getText());
                }
                conf.setIntValue("gui", "screenshotsheight", screenshotsHeight.getSelection());

                storeValues();
                settings.updateAndExtendWithValuesFrom(conf);
                shell.close();
            }
        });
        shell.setDefaultButton(okButton);
        final RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData(rowData);
        okButton.setText(settings.msg("button.ok"));

        final Button cancelButton = new Button(composite_7, SWT.NONE);
        final RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData(rowData_1);
        cancelButton.setText(settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                shell.close();
            }
        });
    }

    private void storeValues() {
        if (previousSelection != -1) {
            conf.setMultilineValues("profile", options.getItem(previousSelection), values.getText(),
                    values.getLineDelimiter());
        }
    }

    private int countVisibleColumns() {
        int result = 0;
        for (int i = 0; i < MainWindow.columnNames.length; i++) {
            if (visibleColumns[i].getChecked()) {
                result++;
            }
        }
        return result;
    }

    private int getFirstVisibleColumn() {
        for (int i = 0; i < MainWindow.columnNames.length; i++) {
            if (visibleColumns[i].getChecked()) {
                return i;
            }
        }
        return -1;
    }

    private void resetColumnSettings() {
        conf.setIntValue("gui", "sortcolumn", getFirstVisibleColumn());
        conf.setBooleanValue("gui", "sortascending", true);
        StringBuffer colOrder = new StringBuffer();
        for (int i = 0; i < countVisibleColumns(); i++) {
            colOrder.append(i).append(' ');
        }
        conf.setValue("gui", "columnorder", colOrder.toString().trim());
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (countVisibleColumns() == 0) {
            GeneralPurposeDialogs.addError(settings.msg("dialog.settings.required.onevisiblecolumn"), visible_columns, columnsTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(shell);
    }
}
