package com.loopy.iface;


public interface Constants {
    /**
     * ISO sector size. This does not include the 288 bytes reserved for synchronization, header, and EC on
     * CD-ROMs because this information is not used in .iso files.
     */
    static final int DEFAULT_BLOCK_SIZE = 2 * 1024;

    /**
     * The number of reserved sectors at the beginning of the file.
     */
    static final int RESERVED_SECTORS = 16;

    /**
     * The number of reserved bytes at the beginning of the file.
     */
    static final int RESERVED_BYTES = RESERVED_SECTORS * DEFAULT_BLOCK_SIZE;

    /**
     * Default character encoding.
     */
    static final String DEFAULT_ENCODING = "US-ASCII";
}