package com.loopy.iface;

/**
 * An entry in a loopy file system. Paths within the file system are unix-like ("/" separated
 * hierarchy of folders and files).
 */
public interface FileEntry {
    /**
     * Returns the entry name (the last entry of the path).
     *
     * @return the entry name
     */
    String getName();
    
    /**
     * Returns the relative entry path. The path does NOT begin with any separators.
     *
     * @return the entry path
     */
    String getPath();

    /**
     * Returns whether this entry represents a directory.
     *
     * @return true if this entry represents a directory, otherwise false.
     */
    boolean isDirectory();
}