package com.loopy.iface;

import java.util.Enumeration;
import java.io.IOException;

/**
 * A loopy file system, which is deserialize-only and consists of zero or more entries. The data
 * for each entry can be retrieved using {@link #getInputStream(FileEntry)}.
 */
public interface FileSystem {
    /**
     * Returns an enumeration of the entries within this file system.
     *
     * @return an enumeration of the entries within this file system
     */
    Enumeration<FileEntry> getEntries();

    /**
     * Closes this file system. This automatically closes all input streams opened via
     * {@link FileSystem#getInputStream(FileEntry entry)}.
     *
     * @throws IOException if there was an error closing the FileSystem.
     */
    void close() throws IOException;

    /**
     * Returns whether or not this FileSystem has been closed.
     *
     * @return true if {@link FileSystem#close()} has been called on this * FileSystem, otherwise false.
     */
    boolean isClosed();
}
