package com.loopy.iface;

import java.io.IOException;

/**
 * Contains all the volume descriptors for a block file system.
 */
public interface VolumeDescriptorSet {
    /**
     * Load a volume descriptor from the specified byte array.
     *
     * @param volumeDescriptor the volume descriptor to deserialize
     * @return true if the volume descriptor is a terminator
     * @throws IOException if there is an error deserializing the volume descriptor
     */
    boolean deserialize(byte[] volumeDescriptor) throws IOException;

    /**
     * Returns the root file entry for the file system.
     *
     * @return the root file entry for the file system
     */
    FileEntry getRootEntry();
}
