package com.loopy.iso9660;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import com.loopy.iface.Constants;
import com.loopy.iface.FileEntry;
import com.loopy.iface.VolumeDescriptorSet;
import com.loopy.impl.AbstractBlockFileSystem;


public class ISO9660FileSystem extends AbstractBlockFileSystem {

    
    public ISO9660FileSystem(File file) throws IOException {
        super(file, Constants.DEFAULT_BLOCK_SIZE, Constants.RESERVED_SECTORS);   
    }

    public String getEncoding() {
        return ((ISO9660VolumeDescriptorSet)getVolumeDescriptorSet()).getEncoding();
    }

    byte[] getBytes(ISO9660FileEntry entry) throws IOException {
        int size = entry.getSize();
        byte[] buf = new byte[size];
        readBytes(entry, 0, buf, 0, size);
        return buf;
    }

    private int readBytes(ISO9660FileEntry entry, int entryOffset, byte[] buffer, int bufferOffset, int len) throws IOException {
        long startPos = (entry.getStartBlock() * Constants.DEFAULT_BLOCK_SIZE) + entryOffset;
        return readData(startPos, buffer, bufferOffset, len);
    }

    protected Enumeration<FileEntry> enumerate(FileEntry rootEntry) {
        return new EntryEnumeration(this, (ISO9660FileEntry)rootEntry);
    }

    protected VolumeDescriptorSet createVolumeDescriptorSet() {
        return new ISO9660VolumeDescriptorSet(this);
    }
}
