package com.loopy.util;

/**
 * Big endian (MSB first) conversion methods.
 */
public abstract class BigEndian {
    /**
     * Gets a 16-bit unsigned integer from the given byte array at the given offset.
     *
     * @param src
     * @param offset
     * @return
     */
    public static int getUInt16(byte[] src, int offset) {
        final int v1 = src[offset] & 0xFF;
        final int v0 = src[offset+1] & 0xFF;
        return ((v1 << 8) | v0);
    }

    /**
     * Gets a 32-bit unsigned integer from the given byte array at the given offset.
     *
     * @param src
     * @param offset
     * @return
     */
    public static long getUInt32(byte[] src, int offset) {
        final long v3 = src[offset] & 0xFF;
        final long v2 = src[offset+1] & 0xFF;
        final long v1 = src[offset+2] & 0xFF;
        final long v0 = src[offset+3] & 0xFF;
        return ((v3 << 24) | (v2 << 16) | (v1 << 8) | v0);
    }
}
