package com.model;

import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import com.util.FileUtils;
import com.util.PlatformUtils;
import com.util.XmlUtils;


public class ExpProfile extends Profile {
    
    final private String fullConfig;
    final private String incrConfig;
    final private File gameDir;

    
    public ExpProfile(final int id, final String fConf, final String iConf, final File gDir, final Profile prof) {
        super(id, FileUtils.PROFILES_DIR + id + FileUtils.CONF_EXT, FileUtils.CAPTURES_DIR + id, prof);
        this.fullConfig = fConf;
        this.incrConfig = iConf;
        this.gameDir = gDir;
    }

    public String getFullConfig() {
        return fullConfig;
    }

    public String getIncrConfig() {
        return incrConfig;
    }

    public void setDbversionId(final int id) {
        this.dbversionId = id;
    }

    public Element getXml(final Document xmldoc, final List<DosboxVersion> dbversionsList) {
        Element profEmt = xmldoc.createElement("profile");
        XmlUtils.addElement(xmldoc, profEmt, "title", getTitle());
        XmlUtils.addElement(xmldoc, profEmt, "id", String.valueOf(getId()));
        Element captures = xmldoc.createElement("captures");
        XmlUtils.addElement(xmldoc, captures, "raw", getCaptures());
        XmlUtils.addElement(xmldoc, captures, "url", getCapturesAsUrl());
        profEmt.appendChild(captures);
        Element config = xmldoc.createElement("config-file");
        XmlUtils.addElement(xmldoc, config, "raw", getConfPathAndFile());
        XmlUtils.addElement(xmldoc, config, "url", getConfFileAsUrl());
        profEmt.appendChild(config);
        XmlUtils.addElement(xmldoc, profEmt, "setup", getSetup());
        XmlUtils.addElement(xmldoc, profEmt, "setup-parameters", getSetupParameters());
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addElement(xmldoc, meta, "developer", getDeveloperName());
        XmlUtils.addElement(xmldoc, meta, "publisher", getPublisherName());
        XmlUtils.addElement(xmldoc, meta, "year", getYear());
        XmlUtils.addElement(xmldoc, meta, "genre", getGenre());
        XmlUtils.addElement(xmldoc, meta, "status", getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", getNotes());
        for (int i = 0; i < 8; i++) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 1), getCustomString(i));
        }
        for (int i = 0; i < 2; i++) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(getCustomInt(i)));
        }
        for (int i = 0; i < 4; i++) {
            Element link = xmldoc.createElement("link" + (i + 1));
            XmlUtils.addElement(xmldoc, link, "raw", getLink(i));
            XmlUtils.addElement(xmldoc, link, "url", getLinkAsUrl(i));
            meta.appendChild(link);
        }
        profEmt.appendChild(meta);
        if (fullConfig != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "full-configuration", fullConfig);
        }
        if (incrConfig != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "incremental-configuration", incrConfig);
        }
        int index = DosboxVersion.findById(dbversionsList, getDbversionId());
        DosboxVersion dbv = dbversionsList.get(index);
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        if (gameDir != null) {
            XmlUtils.addElement(xmldoc, dosbox, "game-dir", PlatformUtils.toDosboxPath(gameDir.getPath()));
        }
        profEmt.appendChild(dosbox);
        return profEmt;
    }
}
