package com.swtdesigner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;


public final class SWTImageManager {

    private static final Map<String, Image> imageMap = new HashMap<String, Image>();


    public static void dispose() {
        for (Image image: imageMap.values()) {
            image.dispose();
        }
        imageMap.clear();
    }

    public static Image getImage(final Display display, final String path) {
        try {
            return new Image(display, path);
        } catch (Exception e) {
            Image image = new Image(display, 10, 10);
            GC graphc = new GC(image);
            graphc.setBackground(display.getSystemColor(SWT.COLOR_RED));
            graphc.fillRectangle(0, 0, 10, 10);
            graphc.dispose();
            return image;
        }
    }

    public static Image getResizedImage(final Display display, final int height, final String path) {
        Image image = imageMap.get(path);
        if (image == null) {
            Image orgImage = getImage(display, path);
            int orgW = orgImage.getBounds().width;
            int orgH = orgImage.getBounds().height;
            double factor = (double) height / (double) orgH;
            int widthFactor = (int) (orgW * factor);
            image = new Image(display, widthFactor, height);
            GC graphc = new GC(image);
            graphc.setAntialias(SWT.ON);
            graphc.drawImage(orgImage, 0, 0, orgW, orgH, 0, 0, widthFactor, height);
            graphc.dispose();
            imageMap.put(path, image);
        }
        return image;
    }
}