package com.connect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import com.gui.MainWindow;
import com.model.Settings;


public final class Messaging extends Thread {

	private transient final int port;
	private transient final Object obj;
	private transient ServerSocket server = null;
	private transient boolean cont = true;
	private Settings settings;
	
	
	public Messaging(final int port, final Object obj) {
		this.port = port;
		this.obj = obj;
		settings = Settings.getInstance();
	}
	
	public void close() {
		cont = false;
		try {
			if (server != null) {
			    server.close();
			}
		} catch (IOException e) {
			System.err.println(settings.msg("communication.error.closesocket"));
		}
	}
	
	public void run() {
		try {
			server = new ServerSocket(port);
			System.out.println(settings.msg("communication.notice.listening", new Object[] {port}));
		} catch (IOException e) {
		    cont = false;
			System.err.println(settings.msg("communication.error.createsocket", new Object[] {port}));
		}
		
		while (cont) {
			try {
				
				Socket client = server.accept();
				BufferedReader bufferedIStream = new BufferedReader(new InputStreamReader(client.getInputStream()));
				System.out.print(settings.msg("communication.notice.receivingmessage"));
				String line = bufferedIStream.readLine();
				System.out.println(' ' + line);
				client.close();
				if (line.startsWith("sendtoprofile ")) {
					((MainWindow)obj).addProfile(line.substring(14));
				}
			} catch (IOException e) {
				if (cont) {
					System.err.println(settings.msg("communication.error.io"));
				}
			}
		}
	}
}
