package com.gui;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import com.model.Settings;
import com.util.FileUtils;


public final class BrowseArchiveDialog extends Dialog {

    private String[] fileNames;
	private String file;
	private Object result;
	private Shell shell;
	private Settings settings;


	public BrowseArchiveDialog(final Shell parent, final int style) {
		super(parent, style);
		file = null;
		settings = Settings.getInstance();
	}

	public BrowseArchiveDialog(final Shell parent) {
		this(parent, SWT.NONE);
	}
	
	public void setFileToBrowse(final String fileToBrowse) {
		this.file = fileToBrowse;
	}

	public Object open() {
	    if (init()) {
    		createContents();
    		shell.open();
    		shell.layout();
    		Display display = getParent().getDisplay();
    		while (!shell.isDisposed()) {
    			if (!display.readAndDispatch()) {
    				display.sleep();
    			}
    		}
	    }
		return result;
	}
	
	private boolean init() {
	    try {
            fileNames = FileUtils.getExecutablesInZipOrIso(file);
            if (fileNames.length <= 0) {
                GeneralPurposeDialogs.warningMessage(getParent(), settings.msg("dialog.archivebrowser.notice.noexe"));
                return false;
            }
        } catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(getParent(), settings.msg("dialog.archivebrowser.error.readarchive", new Object[] {file, e.getMessage()}));
            return false;
        }
        return true;
	}

	private void createContents() {
		shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		shell.setLayout(gridLayout);
        shell.addControlListener(new SizeControlAdapter(shell, "archivebrowser"));
		shell.setText(settings.msg("dialog.archivebrowser.title"));

		final List files = new List(shell, SWT.V_SCROLL | SWT.BORDER);
		files.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		files.setItems(fileNames);
		files.setSelection(0);
		files.addMouseListener(new MouseAdapter() {
			public void mouseDoubleClick(final MouseEvent event) {
			    if (FileUtils.isArchive(file)) {
			        result = file + ':' + File.separatorChar + files.getItem(files.getSelectionIndex());
			    } else if (FileUtils.isIsoFile(file)) {
			        result = file + File.separatorChar + files.getItem(files.getSelectionIndex());
			    }
				shell.close();
			}
		});
		
		final Button okButton = new Button(shell, SWT.NONE);
		okButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
			    if (FileUtils.isArchive(file)) {
                    result = file + ':' + File.separatorChar + files.getItem(files.getSelectionIndex());
                } else if (FileUtils.isIsoFile(file)) {
                    result = file + File.separatorChar + files.getItem(files.getSelectionIndex());
                }
				shell.close();
			}
		});
		final GridData gridData = new GridData(80, SWT.DEFAULT);
		okButton.setLayoutData(gridData);
		shell.setDefaultButton(okButton);
		okButton.setText(settings.msg("button.ok"));

		final Button cancelButton = new Button(shell, SWT.NONE);
		final GridData gridData_1 = new GridData(80, SWT.DEFAULT);
		cancelButton.setLayoutData(gridData_1);
		cancelButton.setText(settings.msg("button.cancel"));
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				result = null;
				shell.close();
			}
		});
	}
}
